/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.config;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonWriter;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import mezz.jei.api.helpers.ICodecHelper;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.runtime.IEditModeConfig;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.common.codecs.EnumCodec;
import mezz.jei.core.util.WeakList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.RegistryOps;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EditModeConfig
implements IEditModeConfig {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Map<Object, Pair<IEditModeConfig.HideMode, ITypedIngredient<?>>> blacklist = new LinkedHashMap();
    private final ISerializer serializer;
    private final IIngredientManager ingredientManager;
    private final WeakList<IListener> listeners = new WeakList();

    public EditModeConfig(ISerializer serializer, IIngredientManager ingredientManager) {
        this.ingredientManager = ingredientManager;
        this.serializer = serializer;
        this.serializer.initialize(this);
        this.serializer.load(this);
    }

    public <V> void addIngredientToConfigBlacklist(ITypedIngredient<V> typedIngredient, IEditModeConfig.HideMode blacklistType, IIngredientHelper<V> ingredientHelper) {
        if (this.addIngredientToConfigBlacklistInternal(typedIngredient, blacklistType, ingredientHelper)) {
            this.serializer.save(this);
            this.notifyListenersOfVisibilityChange(typedIngredient, false);
        }
    }

    private <V> boolean addIngredientToConfigBlacklistInternal(ITypedIngredient<V> typedIngredient, IEditModeConfig.HideMode blacklistType) {
        IIngredientHelper<V> ingredientHelper = this.ingredientManager.getIngredientHelper(typedIngredient.getType());
        return this.addIngredientToConfigBlacklistInternal(typedIngredient, blacklistType, ingredientHelper);
    }

    private <V> boolean addIngredientToConfigBlacklistInternal(ITypedIngredient<V> typedIngredient, IEditModeConfig.HideMode blacklistType, IIngredientHelper<V> ingredientHelper) {
        Object wildcardUid = EditModeConfig.getIngredientUid(typedIngredient, IEditModeConfig.HideMode.WILDCARD, ingredientHelper);
        if (blacklistType == IEditModeConfig.HideMode.SINGLE) {
            Object uid = EditModeConfig.getIngredientUid(typedIngredient, blacklistType, ingredientHelper);
            if (wildcardUid.equals(uid)) {
                return this.blacklist.put(wildcardUid, new Pair((Object)blacklistType, typedIngredient)) == null;
            }
            return this.blacklist.put(uid, new Pair((Object)blacklistType, typedIngredient)) == null;
        }
        if (blacklistType == IEditModeConfig.HideMode.WILDCARD) {
            return this.blacklist.put(wildcardUid, new Pair((Object)blacklistType, typedIngredient)) == null;
        }
        return false;
    }

    public <V> void removeIngredientFromConfigBlacklist(ITypedIngredient<V> typedIngredient, IEditModeConfig.HideMode blacklistType, IIngredientHelper<V> ingredientHelper) {
        Object uid = EditModeConfig.getIngredientUid(typedIngredient, blacklistType, ingredientHelper);
        if (this.blacklist.remove(uid) != null) {
            this.serializer.save(this);
            this.notifyListenersOfVisibilityChange(typedIngredient, true);
        }
    }

    public <V> boolean isIngredientOnConfigBlacklist(ITypedIngredient<V> typedIngredient, IIngredientHelper<V> ingredientHelper) {
        for (IEditModeConfig.HideMode hideMode : IEditModeConfig.HideMode.values()) {
            if (!this.isIngredientOnConfigBlacklist(typedIngredient, hideMode, ingredientHelper)) continue;
            return true;
        }
        return false;
    }

    private <V> Set<IEditModeConfig.HideMode> getIngredientOnConfigBlacklist(ITypedIngredient<V> ingredient, IIngredientHelper<V> ingredientHelper) {
        return Arrays.stream(IEditModeConfig.HideMode.values()).filter(hideMode -> this.isIngredientOnConfigBlacklist(ingredient, (IEditModeConfig.HideMode)((Object)hideMode), ingredientHelper)).collect(Collectors.toUnmodifiableSet());
    }

    public <V> boolean isIngredientOnConfigBlacklist(ITypedIngredient<V> typedIngredient, IEditModeConfig.HideMode blacklistType, IIngredientHelper<V> ingredientHelper) {
        Object uid = EditModeConfig.getIngredientUid(typedIngredient, blacklistType, ingredientHelper);
        return this.blacklist.containsKey(uid);
    }

    private static <V> Object getIngredientUid(ITypedIngredient<V> typedIngredient, IEditModeConfig.HideMode blacklistType, IIngredientHelper<V> ingredientHelper) {
        V ingredient = typedIngredient.getIngredient();
        return switch (blacklistType) {
            default -> throw new MatchException(null, null);
            case IEditModeConfig.HideMode.SINGLE -> ingredientHelper.getUid(ingredient, UidContext.Ingredient);
            case IEditModeConfig.HideMode.WILDCARD -> ingredientHelper.getWildcardId(ingredient);
        };
    }

    @Override
    public <V> boolean isIngredientHiddenUsingConfigFile(ITypedIngredient<V> ingredient) {
        IIngredientType<V> type = ingredient.getType();
        IIngredientHelper<V> ingredientHelper = this.ingredientManager.getIngredientHelper(type);
        return this.isIngredientOnConfigBlacklist(ingredient, ingredientHelper);
    }

    @Override
    public <V> Set<IEditModeConfig.HideMode> getIngredientHiddenUsingConfigFile(ITypedIngredient<V> ingredient) {
        IIngredientType<V> type = ingredient.getType();
        IIngredientHelper<V> ingredientHelper = this.ingredientManager.getIngredientHelper(type);
        return this.getIngredientOnConfigBlacklist(ingredient, ingredientHelper);
    }

    @Override
    public <V> void hideIngredientUsingConfigFile(ITypedIngredient<V> ingredient, IEditModeConfig.HideMode hideMode) {
        IIngredientType<V> type = ingredient.getType();
        IIngredientHelper<V> ingredientHelper = this.ingredientManager.getIngredientHelper(type);
        this.addIngredientToConfigBlacklist(ingredient, hideMode, ingredientHelper);
    }

    @Override
    public <V> void showIngredientUsingConfigFile(ITypedIngredient<V> ingredient, IEditModeConfig.HideMode hideMode) {
        IIngredientType<V> type = ingredient.getType();
        IIngredientHelper<V> ingredientHelper = this.ingredientManager.getIngredientHelper(type);
        this.removeIngredientFromConfigBlacklist(ingredient, hideMode, ingredientHelper);
    }

    public void registerListener(IListener listener) {
        this.listeners.add(listener);
    }

    private <T> void notifyListenersOfVisibilityChange(ITypedIngredient<T> ingredient, boolean visible) {
        this.listeners.forEach(listener -> listener.onIngredientVisibilityChanged(ingredient, visible));
    }

    public static interface ISerializer {
        public void initialize(EditModeConfig var1);

        public void save(EditModeConfig var1);

        public void load(EditModeConfig var1);
    }

    public static interface IListener {
        public <V> void onIngredientVisibilityChanged(ITypedIngredient<V> var1, boolean var2);
    }

    public static class FileSerializer
    implements ISerializer {
        private final Path path;
        private final Codec<List<Pair<IEditModeConfig.HideMode, ITypedIngredient<?>>>> listCodec;
        private final RegistryOps<JsonElement> registryOps;

        public FileSerializer(Path path, RegistryAccess registryAccess, ICodecHelper codecHelper) {
            this.path = path;
            this.listCodec = Codec.list((Codec)Codec.pair(EnumCodec.create(IEditModeConfig.HideMode.class, IEditModeConfig.HideMode::valueOf), (Codec)codecHelper.getTypedIngredientCodec().codec()));
            this.registryOps = registryAccess.createSerializationContext((DynamicOps)JsonOps.COMPRESSED);
        }

        @Override
        public void initialize(EditModeConfig config) {
            if (!Files.exists(this.path, new LinkOption[0])) {
                this.save(config);
            }
        }

        @Override
        public void save(EditModeConfig config) {
            List<Pair<IEditModeConfig.HideMode, ITypedIngredient<?>>> values = List.copyOf(config.blacklist.values());
            DataResult results = this.listCodec.encodeStart(this.registryOps, values);
            results.ifError(error -> LOGGER.error("Encountered errors when saving the blacklist config to file {}\n{}", (Object)this.path, error));
            if (results.hasResultOrPartial()) {
                try (JsonWriter jsonWriter = new JsonWriter((Writer)Files.newBufferedWriter(this.path, new OpenOption[0]));){
                    Gson gson = new Gson();
                    JsonElement jsonElement = (JsonElement)results.getPartialOrThrow();
                    gson.toJson(jsonElement, jsonWriter);
                    jsonWriter.flush();
                    LOGGER.debug("Saved blacklist config to file: {}", (Object)this.path);
                }
                catch (IOException e) {
                    LOGGER.error("Failed to save blacklist config to file {}", (Object)this.path, (Object)e);
                }
            }
        }

        @Override
        public void load(EditModeConfig config) {
            if (!Files.exists(this.path, new LinkOption[0])) {
                return;
            }
            try {
                JsonElement jsonElement = JsonParser.parseReader((Reader)Files.newBufferedReader(this.path));
                DataResult results = this.listCodec.decode(this.registryOps, (Object)jsonElement);
                results.ifError(error -> LOGGER.error("Encountered errors when loading the blacklist config from file {}\n{}", (Object)this.path, error));
                if (results.hasResultOrPartial()) {
                    config.blacklist.clear();
                    List list = (List)((Pair)results.getPartialOrThrow()).getFirst();
                    for (Pair pair : list) {
                        config.addIngredientToConfigBlacklistInternal((ITypedIngredient)pair.getSecond(), (IEditModeConfig.HideMode)((Object)pair.getFirst()));
                    }
                }
            }
            catch (IOException | IllegalArgumentException e) {
                LOGGER.error("Failed to load blacklist from file {}", (Object)this.path, (Object)e);
            }
        }
    }
}

