/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.config;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonWriter;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.MapCodec;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import mezz.jei.api.helpers.ICodecHelper;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusFactory;
import mezz.jei.api.recipe.IRecipeManager;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.common.codecs.EnumCodec;
import mezz.jei.common.util.ServerConfigPathUtil;
import mezz.jei.core.util.PathUtil;
import mezz.jei.gui.bookmarks.BookmarkList;
import mezz.jei.gui.bookmarks.BookmarkType;
import mezz.jei.gui.bookmarks.IBookmark;
import mezz.jei.gui.config.IBookmarkConfig;
import mezz.jei.gui.config.LegacyBookmarkConfig;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.RegistryOps;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class BookmarkJsonConfig
implements IBookmarkConfig {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Codec<BookmarkType> TYPE_CODEC = EnumCodec.create(BookmarkType.class, BookmarkType::valueOf);
    @Nullable
    private static MapCodec<IBookmark> BOOKMARK_CODEC;
    private final LegacyBookmarkConfig legacyBookmarkConfig;
    private final Path jeiConfigurationDir;

    private static MapCodec<IBookmark> getBookmarkCodec(ICodecHelper codecHelper, IIngredientManager ingredientManager, IRecipeManager recipeManager) {
        if (BOOKMARK_CODEC == null) {
            BOOKMARK_CODEC = TYPE_CODEC.dispatchMap("bookmarkType", IBookmark::getType, type -> type.getCodec(codecHelper, ingredientManager, recipeManager));
        }
        return BOOKMARK_CODEC;
    }

    private static Optional<Path> getPath(Path jeiConfigurationDir) {
        return ServerConfigPathUtil.getWorldPath(jeiConfigurationDir).flatMap(configPath -> {
            try {
                Files.createDirectories(configPath, new FileAttribute[0]);
            }
            catch (IOException e) {
                LOGGER.error("Unable to create bookmark config folder: {}", configPath);
                return Optional.empty();
            }
            Path path = configPath.resolve("bookmarks.json");
            return Optional.of(path);
        });
    }

    public BookmarkJsonConfig(Path jeiConfigurationDir) {
        this.jeiConfigurationDir = jeiConfigurationDir;
        this.legacyBookmarkConfig = new LegacyBookmarkConfig(jeiConfigurationDir);
    }

    private RegistryOps<JsonElement> getRegistryOps(RegistryAccess registryAccess) {
        return registryAccess.createSerializationContext((DynamicOps)JsonOps.COMPRESSED);
    }

    @Override
    public boolean saveBookmarks(IRecipeManager recipeManager, IFocusFactory focusFactory, IGuiHelper guiHelper, IIngredientManager ingredientManager, RegistryAccess registryAccess, ICodecHelper codecHelper, List<IBookmark> bookmarks) {
        return BookmarkJsonConfig.getPath(this.jeiConfigurationDir).map(path -> {
            Codec bookmarkCodec = BookmarkJsonConfig.getBookmarkCodec(codecHelper, ingredientManager, recipeManager).codec();
            Codec listCodec = Codec.list((Codec)bookmarkCodec);
            RegistryOps<JsonElement> registryOps = this.getRegistryOps(registryAccess);
            DataResult results = listCodec.encodeStart(registryOps, (Object)bookmarks);
            results.ifError(error -> LOGGER.error("Encountered errors when saving the bookmarks config to file {}\n{}", path, error));
            if (results.hasResultOrPartial()) {
                Boolean bl;
                JsonWriter jsonWriter = new JsonWriter((Writer)Files.newBufferedWriter(path, new OpenOption[0]));
                try {
                    Gson gson = new Gson();
                    JsonElement jsonElement = (JsonElement)results.getPartialOrThrow();
                    gson.toJson(jsonElement, jsonWriter);
                    jsonWriter.flush();
                    LOGGER.debug("Saved bookmarks config to file: {}", path);
                    bl = true;
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            jsonWriter.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        LOGGER.error("Failed to save bookmarks config to file {}", path, (Object)e);
                        return false;
                    }
                }
                jsonWriter.close();
                return bl;
            }
            return false;
        }).orElse(false);
    }

    @Override
    public void loadBookmarks(IRecipeManager recipeManager, IFocusFactory focusFactory, IGuiHelper guiHelper, IIngredientManager ingredientManager, RegistryAccess registryAccess, BookmarkList bookmarkList, ICodecHelper codecHelper) {
        List<IBookmark> bookmarks = this.loadJsonBookmarks(ingredientManager, recipeManager, registryAccess, codecHelper);
        List<IBookmark> legacyBookmarks = this.legacyBookmarkConfig.loadBookmarks(recipeManager, focusFactory, ingredientManager, registryAccess);
        if (!legacyBookmarks.isEmpty()) {
            bookmarks = new ArrayList<IBookmark>(bookmarks);
            bookmarks.addAll(legacyBookmarks);
            if (this.saveBookmarks(recipeManager, focusFactory, guiHelper, ingredientManager, registryAccess, codecHelper, bookmarks)) {
                LegacyBookmarkConfig.getPath(this.jeiConfigurationDir).ifPresent(legacyPath -> {
                    try {
                        Path backupPath = legacyPath.resolveSibling(String.valueOf(legacyPath.getFileName()) + ".bak");
                        PathUtil.moveAtomicReplace(legacyPath, backupPath);
                        LOGGER.info("Backed up legacy bookmarks config file to '{}'", (Object)backupPath);
                    }
                    catch (IOException e) {
                        LOGGER.error("Failed to back up legacy bookmarks config file '{}'", legacyPath, (Object)e);
                    }
                });
            }
        }
        bookmarkList.setFromConfigFile(bookmarks);
    }

    private @Unmodifiable List<IBookmark> loadJsonBookmarks(IIngredientManager ingredientManager, IRecipeManager recipeManager, RegistryAccess registryAccess, ICodecHelper codecHelper) {
        return BookmarkJsonConfig.getPath(this.jeiConfigurationDir).map(path -> {
            if (!Files.exists(path, new LinkOption[0])) {
                return List.of();
            }
            List bookmarks = new ArrayList();
            Codec bookmarkCodec = BookmarkJsonConfig.getBookmarkCodec(codecHelper, ingredientManager, recipeManager).codec();
            Codec listCodec = Codec.list((Codec)bookmarkCodec);
            RegistryOps<JsonElement> registryOps = this.getRegistryOps(registryAccess);
            try {
                JsonElement jsonElement = JsonParser.parseReader((Reader)Files.newBufferedReader(path));
                DataResult results = listCodec.decode(registryOps, (Object)jsonElement);
                results.ifError(error -> LOGGER.error("Encountered errors when loading the bookmark config from file {}\n{}", path, error));
                if (results.hasResultOrPartial()) {
                    bookmarks = (List)((Pair)results.getPartialOrThrow()).getFirst();
                }
            }
            catch (IOException | IllegalArgumentException e) {
                LOGGER.error("Failed to load bookmarks from file {}", path, (Object)e);
            }
            return bookmarks;
        }).orElseGet(List::of);
    }
}

