/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.waypointmanager.waypoint;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicBoolean;
import journeymap.api.services.EventBus;
import journeymap.api.v2.common.event.common.WaypointEvent;
import journeymap.api.v2.common.waypoint.Waypoint;
import journeymap.client.Constants;
import journeymap.client.JourneymapClient;
import journeymap.client.command.CmdTeleportWaypoint;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.texture.TextureCache;
import journeymap.client.ui.UIManager;
import journeymap.client.ui.component.Slot;
import journeymap.client.ui.component.buttons.BasicImageButton;
import journeymap.client.ui.component.dropdown.DropDownItem;
import journeymap.client.ui.component.dropdown.SelectableParent;
import journeymap.client.ui.component.popupscreenbutton.ImagePopupButton;
import journeymap.client.ui.component.widgets.ColoredImageWidget;
import journeymap.client.ui.component.widgets.StringWidget;
import journeymap.client.ui.fullscreen.Fullscreen;
import journeymap.client.ui.option.SlotMetadata;
import journeymap.client.ui.waypointmanager.ManagerSlot;
import journeymap.client.ui.waypointmanager.WaypointChat;
import journeymap.client.ui.waypointmanager.waypoint.DeleteConfirmWaypointPopup;
import journeymap.client.ui.waypointmanager.waypoint.WaypointEditor;
import journeymap.client.waypoint.ClientWaypointImpl;
import journeymap.common.Journeymap;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.layouts.FrameLayout;
import net.minecraft.client.gui.layouts.Layout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LayoutSettings;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

public class WaypointSlot
extends ManagerSlot
implements SelectableParent {
    private final ClientWaypointImpl waypoint;
    private boolean dragging = false;
    private double dragX;
    private double dragY;
    private Integer distance;
    private final NumberFormat formatter = new DecimalFormat("0.##E0");
    private int y;
    private int x;
    private int listWidth;
    private int itemHeight;
    private ManagerSlot.ToolTipMeta tooltips;
    private LinearLayout layout;

    public WaypointSlot(ClientWaypointImpl waypoint) {
        this.waypoint = waypoint;
    }

    @Override
    public void repositionElements() {
        this.layout.arrangeElements();
        FrameLayout.centerInRectangle((LayoutElement)this.layout, (ScreenRectangle)this.getRectangle());
    }

    @Override
    public void init() {
        boolean waypointValid;
        int scale = Minecraft.getInstance().getWindow().getGuiScaledWidth() / 100;
        Font font = Minecraft.getInstance().font;
        int fontWidth = 30 * scale;
        int size = 16;
        LinearLayout buttonsLayout = LinearLayout.horizontal().spacing(scale - 1);
        this.buildTooltips();
        this.layout = LinearLayout.horizontal().spacing(scale);
        LinearLayout contentLayout = LinearLayout.horizontal().spacing(scale);
        this.layout.addChild((LayoutElement)contentLayout);
        contentLayout.addChild((LayoutElement)ColoredImageWidget.texture(size, size, this.waypoint.getTexture(), size, size, this.waypoint.getIconColor(), false), LayoutSettings::alignVerticallyMiddle);
        StringWidget dist = (StringWidget)contentLayout.addChild((LayoutElement)new StringWidget((Component)Component.literal((String)this.getDistanceString()), 40, font).alignLeft(), LayoutSettings::alignVerticallyMiddle);
        StringWidget name = (StringWidget)contentLayout.addChild((LayoutElement)new StringWidget((Component)Component.literal((String)this.waypoint.getName()), fontWidth, font).alignLeft(), LayoutSettings::alignVerticallyMiddle);
        boolean bl = waypointValid = this.waypoint.isEnabled() && this.waypoint.isInPlayerDimension();
        if (!waypointValid) {
            Style style = Style.EMPTY.withColor(0x808080).withStrikethrough(Boolean.valueOf(JourneymapClient.getInstance().getWaypointProperties().disableStrikeThrough.get() == false));
            dist.setMessage((Component)dist.getMessage().copy().withStyle(style));
            name.setMessage((Component)name.getMessage().copy().withStyle(style));
        }
        if (CmdTeleportWaypoint.isPermitted(Minecraft.getInstance())) {
            ((BasicImageButton)buttonsLayout.addChild((LayoutElement)new BasicImageButton(12, 12, TextureCache.TELEPORT_SPRITE, this::teleport, (Component)Component.translatable((String)"jm.waypoint.teleport.tooltip")))).setTexWidth(8).setTexHeight(8).setXOffset(2).setYOffset(2).setTooltip(Tooltip.create((Component)Component.translatable((String)"jm.waypoint.teleport.tooltip")));
        }
        ((BasicImageButton)buttonsLayout.addChild((LayoutElement)new BasicImageButton(12, 12, TextureCache.PIN_SPRITE, this::goToMap, (Component)Component.translatable((String)"jm.waypoint.find.tooltip")))).setTexWidth(10).setTexHeight(10).setXOffset(1).setYOffset(1).setTooltip(Tooltip.create((Component)Component.translatable((String)"jm.waypoint.find.tooltip")));
        if (!JourneymapClient.getInstance().getWaypointProperties().disableShare.get().booleanValue()) {
            ((BasicImageButton)buttonsLayout.addChild((LayoutElement)new BasicImageButton(12, 12, TextureCache.SHARE_SPRITE, this::share, (Component)Component.translatable((String)"jm.waypoint.share.tooltip")))).setTexWidth(8).setTexHeight(8).setXOffset(2).setYOffset(2).setTooltip(Tooltip.create((Component)Component.translatable((String)"jm.waypoint.share.tooltip")));
        }
        ((BasicImageButton)buttonsLayout.addChild((LayoutElement)new BasicImageButton(12, 12, TextureCache.POWER_SPRITE, (Integer)(this.waypoint.isEnabled() ? 65280 : 0xFF0000), this::onEnable, this.getEnabledComponent(this.waypoint.isEnabled())))).setTexWidth(10).setTexHeight(10).setXOffset(1).setYOffset(1).setTooltip(Tooltip.create((Component)this.getEnabledComponent(this.waypoint.isEnabled())));
        ((ImagePopupButton)buttonsLayout.addChild(new ImagePopupButton<Waypoint>(12, 12, TextureCache.OPTIONS_SPRITE, Constants.getString("jm.waypoint.edit_title"), () -> new WaypointEditor(this.waypoint), this::onEdit))).setTooltip(Tooltip.create((Component)Component.translatable((String)"jm.waypoint.edit_title")));
        if (JourneymapClient.getInstance().getWaypointProperties().showDeleteConfirmation.get().booleanValue()) {
            ((ImagePopupButton)buttonsLayout.addChild(new ImagePopupButton<Boolean>(12, 12, TextureCache.X_OUTLINE_SPRITE, ChatFormatting.RED.getColor(), Constants.getString("jm.waypoint.delete.label"), () -> new DeleteConfirmWaypointPopup(this.waypoint), this::onDelete))).setTooltip(Tooltip.create((Component)Component.translatable((String)"jm.waypoint.delete.label")));
        } else {
            ((BasicImageButton)buttonsLayout.addChild((LayoutElement)new BasicImageButton(12, 12, TextureCache.X_OUTLINE_SPRITE, ChatFormatting.RED.getColor(), b -> this.onDelete(true), (Component)Component.translatable((String)"jm.waypoint.delete.label")))).setTexWidth(10).setTexHeight(10).setXOffset(1).setYOffset(1).setTooltip(Tooltip.create((Component)Component.translatable((String)"jm.waypoint.delete.label")));
        }
        LayoutSettings settings = LayoutSettings.defaults().alignVerticallyMiddle();
        contentLayout.addChild((LayoutElement)buttonsLayout, settings);
        this.repositionElements();
    }

    private Component getEnabledComponent(boolean enabled) {
        return enabled ? Component.translatable((String)"jm.waypoint.disable_waypoint") : Component.translatable((String)"jm.waypoint.enable_waypoint");
    }

    private void onEnable(Button button) {
        button.setMessage(this.getEnabledComponent(this.waypoint.isEnabled()));
        button.setTooltip(Tooltip.create((Component)this.getEnabledComponent(this.waypoint.isEnabled())));
        boolean enabled = !this.waypoint.isEnabled();
        this.waypoint.setEnabled(enabled);
        EventBus.post(new WaypointEvent((Waypoint)this.waypoint, WaypointEvent.Context.UPDATE, null));
    }

    private void share(Button button) {
        try {
            Minecraft.getInstance().setScreen((Screen)new WaypointChat(this.waypoint));
        }
        catch (Exception e1) {
            Journeymap.getLogger().error("Error opening waypoint chat for waypoint {} :", (Object)this.waypoint.toString(), (Object)e1);
        }
    }

    private void goToMap(Button button) {
        UIManager.INSTANCE.openFullscreenMap(this.waypoint);
    }

    private void onEdit(Waypoint waypoint) {
    }

    private void teleport(Button button) {
        if (CmdTeleportWaypoint.isPermitted(Minecraft.getInstance())) {
            new CmdTeleportWaypoint(this.waypoint).run();
            Fullscreen.state().follow.set(true);
            UIManager.INSTANCE.closeAll();
        }
    }

    private void onDelete(boolean delete) {
        if (delete) {
            EventBus.post(new WaypointEvent((Waypoint)this.waypoint, WaypointEvent.Context.DELETED, null));
        }
    }

    public int getDistance() {
        return this.distance == null ? this.getDistanceTo((Player)Minecraft.getInstance().player) : this.distance.intValue();
    }

    public int getDistanceTo(Player player) {
        if (this.distance == null) {
            this.distance = (int)player.position().distanceTo(this.waypoint.getPosition());
        }
        return this.distance;
    }

    private String getDistanceString() {
        String distance = String.valueOf(this.getDistance());
        int width = Minecraft.getInstance().font.width(distance);
        if (width > 25) {
            distance = this.formatter.format(this.getDistance()).toLowerCase(Locale.ROOT);
        }
        return String.format("%sm", distance);
    }

    private void buildTooltips() {
        ArrayList<FormattedCharSequence> tooltip = new ArrayList<FormattedCharSequence>();
        tooltip.add(FormattedCharSequence.forward((String)this.waypoint.getName(), (Style)Style.EMPTY.applyFormats(new ChatFormatting[]{ChatFormatting.AQUA, ChatFormatting.UNDERLINE})));
        tooltip.add(FormattedCharSequence.forward((String)"", (Style)Style.EMPTY));
        tooltip.add(FormattedCharSequence.forward((String)Constants.getString("jm.waypoint.slot.mod_id", this.waypoint.getModId()), (Style)Style.EMPTY.applyFormat(ChatFormatting.BLUE)));
        tooltip.add(FormattedCharSequence.forward((String)Constants.getString("jm.waypoint.slot.pos", this.waypoint.getBlockPos().toShortString()), (Style)Style.EMPTY.applyFormat(ChatFormatting.BLUE)));
        tooltip.add(FormattedCharSequence.forward((String)Constants.getString("jm.waypoint.slot.group", this.waypoint.getGroup().getName()), (Style)Style.EMPTY.applyFormat(ChatFormatting.GREEN)));
        tooltip.add(FormattedCharSequence.forward((String)Constants.getString("jm.waypoint.slot.enabled", this.waypoint.isEnabled()), (Style)Style.EMPTY.applyFormat(ChatFormatting.GREEN)));
        this.tooltips = new ManagerSlot.ToolTipMeta(tooltip);
    }

    @Override
    public Layout getLayout() {
        return this.layout;
    }

    @Override
    public int compareTo(@NotNull ManagerSlot o) {
        return 0;
    }

    @Override
    public Collection<SlotMetadata> getMetadata() {
        return null;
    }

    public boolean charTyped(char typedChar, int keyCode) {
        return false;
    }

    public boolean keyPressed(int key, int value, int modifier) {
        return false;
    }

    @Override
    public List<? extends Slot> getChildSlots(int listWidth, int columnWidth) {
        return null;
    }

    @Override
    public SlotMetadata getLastPressed() {
        return null;
    }

    @Override
    public SlotMetadata getCurrentTooltip() {
        AtomicBoolean showTooltip = new AtomicBoolean(true);
        this.layout.visitWidgets(widget -> {
            Button button;
            if (widget instanceof Button && (button = (Button)widget).isHovered()) {
                showTooltip.set(false);
            }
        });
        return showTooltip.get() ? this.tooltips : null;
    }

    @Override
    public void setEnabled(boolean enabled) {
    }

    @Override
    public int getColumnWidth() {
        return 0;
    }

    @Override
    public boolean contains(SlotMetadata slotMetadata) {
        return false;
    }

    public void render(GuiGraphics graphics, int slotIndex, int y, int x, int listWidth, int itemHeight, int mouseX, int mouseY, boolean isMouseOver, float partialTicks) {
        float alpha;
        this.y = y;
        this.x = x;
        this.listWidth = listWidth;
        this.itemHeight = itemHeight;
        Integer color = isMouseOver ? backgroundHover : background;
        float f = alpha = isMouseOver ? 1.0f : 0.4f;
        if (!this.isFocused()) {
            DrawUtil.drawRectangle(graphics, x, y, listWidth - 4, itemHeight, color, alpha);
        }
        this.renderSlot(graphics, x, y, listWidth - 4, itemHeight, mouseX, mouseY, color, alpha, partialTicks);
    }

    public void renderGhost(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        int xOffset = (int)((double)mouseX - (this.dragX - (double)this.x));
        int yOffest = (int)((double)mouseY - (this.dragY - (double)this.y));
        graphics.pose().translate(0.0f, 0.0f, 100.0f);
        DrawUtil.drawRectangle(graphics, xOffset, yOffest, this.listWidth - 4, this.itemHeight, backgroundHover, 0.4f);
        this.renderSlot(graphics, xOffset, yOffest, this.listWidth, this.itemHeight, xOffset, yOffest, backgroundHover, 0.2f, partialTicks);
    }

    private void renderSlot(GuiGraphics graphics, int x, int y, int listWidth, int itemHeight, int mouseX, int mouseY, int color, float alpha, float partialTicks) {
        this.layout.setX(x + 3);
        this.layout.setY(y);
        this.layout.visitWidgets(widget -> widget.render(graphics, mouseX, mouseY, partialTicks));
        this.outline(graphics, x - 1, y - 1, listWidth + 1, itemHeight + 1, this.waypoint.getRenderColor(), alpha * 2.0f);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        long clickTime = Util.getMillis();
        boolean bl = this.doubleclick = clickTime - this.lastClickTime < 250L && this.lastClickButton == button;
        if (this.doubleclick) {
            this.doubleclick = false;
            this.lastClickTime = 0L;
            new WaypointEditor(this.waypoint).display();
            return true;
        }
        this.dragX = mouseX;
        this.dragY = mouseY;
        this.lastClickTime = clickTime;
        this.lastClickButton = button;
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        this.dragging = false;
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (!this.dragging) {
            this.dragging = this.isMouseOver(mouseX, mouseY);
        }
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    @Override
    public boolean isDragging() {
        return this.dragging;
    }

    @NotNull
    public ClientWaypointImpl getWaypoint() {
        return this.waypoint;
    }

    @Override
    public void setSelected(DropDownItem button) {
    }
}

