/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.waypointmanager.waypoint;

import java.util.function.Consumer;
import journeymap.client.ui.component.ScrollListLayoutPane;
import journeymap.client.ui.waypointmanager.waypoint.WaypointSlot;
import journeymap.common.Journeymap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;

public class WaypointPanel<T extends WaypointSlot>
extends ScrollListLayoutPane<T> {
    final int offset = 6;
    WaypointSlot draggingSlot = null;

    public WaypointPanel(Minecraft mc, int x, int y, int width, int height, int slotHeight) {
        super(mc, x, y, width, height, slotHeight);
    }

    public int getRowLeft() {
        return super.getRowLeft();
    }

    @Override
    public void updateSize(int width, int height, int x, int y) {
        super.setRectangle(width, height, x - 3, y);
        this.scrollbarX = this.width + x - 6;
        this.listWidth = this.width - 6;
    }

    @Override
    public void setListWidth(int width) {
        this.scrollbarX = (this.width + width) / 2 - 6;
        this.listWidth = width - 6;
    }

    @Override
    public void renderItem(GuiGraphics graphics, int mouseX, int mouseY, float partialTick, int index, int left, int top, int width, int height) {
        try {
            WaypointSlot slot = (WaypointSlot)this.getEntry(index);
            super.renderItem(graphics, mouseX, mouseY, partialTick, index, left, top, width, height);
            if (slot.isDragging()) {
                this.draggingSlot = slot;
            }
            if (this.draggingSlot != null && (this.getRowBottom(index + 1) > this.getBottom() || index + 1 >= this.children().size())) {
                graphics.disableScissor();
                this.draggingSlot.renderGhost(graphics, mouseX, mouseY, partialTick);
                this.enableScissor(graphics);
            }
        }
        catch (Throwable t) {
            Journeymap.getLogger().error("Error rendering waypoint slot item:", t);
        }
    }

    @Override
    public void renderBackground(GuiGraphics graphics, int i, int j, float f) {
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        this.draggingSlot = null;
        return super.mouseReleased(mouseX, mouseY, button);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.isMouseOver(mouseX, mouseY) && this.isMouseOver(mouseX, mouseY)) {
            this.getRootSlots().forEach(slot -> slot.getLayout().visitWidgets(widget -> widget.mouseClicked(mouseX, mouseY, button)));
            return super.mouseClicked(mouseX, mouseY, button);
        }
        return false;
    }

    public WaypointSlot getDraggingSlot() {
        return this.draggingSlot;
    }

    @Override
    public void visitSlots(Consumer<AbstractWidget> consumer) {
        this.getRootSlots().forEach(slot -> {
            if (slot != null && slot.getLayout() != null) {
                slot.getLayout().visitWidgets(consumer);
            }
        });
    }

    @Override
    public void initSlots() {
        this.getRootSlots().forEach(WaypointSlot::init);
    }

    @Override
    public void repositionSlots() {
        this.getRootSlots().forEach(WaypointSlot::repositionElements);
    }
}

