/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.waypointmanager.waypoint;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import journeymap.api.services.EventBus;
import journeymap.api.v2.common.event.common.WaypointEvent;
import journeymap.api.v2.common.event.common.WaypointGroupEvent;
import journeymap.api.v2.common.waypoint.Waypoint;
import journeymap.api.v2.common.waypoint.WaypointFactory;
import journeymap.api.v2.common.waypoint.WaypointGroup;
import journeymap.client.Constants;
import journeymap.client.cartography.color.RGB;
import journeymap.client.data.WorldData;
import journeymap.client.log.JMLogger;
import journeymap.client.texture.TextureCache;
import journeymap.client.ui.component.TextBox;
import journeymap.client.ui.component.dropdown.DropDownButton;
import journeymap.client.ui.component.dropdown.DropDownItem;
import journeymap.client.ui.component.dropdown.ImageDropDownItem;
import journeymap.client.ui.component.dropdown.SelectableParent;
import journeymap.client.ui.component.popupscreenbutton.PopupButton;
import journeymap.client.ui.component.popupscreenbutton.PopupButtonScreen;
import journeymap.client.ui.component.popupscreenbutton.colorpicker.ColorPickerButton;
import journeymap.client.ui.component.popupscreenbutton.colorpicker.ColorPickerScreen;
import journeymap.client.ui.component.widgets.ColoredImageWidget;
import journeymap.client.ui.component.widgets.StringWidget;
import journeymap.client.ui.waypointmanager.WaypointManager;
import journeymap.client.ui.waypointmanager.group.EditGroupPopup;
import journeymap.client.ui.waypointmanager.waypoint.DeleteConfirmWaypointPopup;
import journeymap.client.ui.waypointmanager.waypoint.DimensionPanel;
import journeymap.client.ui.waypointmanager.waypoint.DimensionSlot;
import journeymap.client.waypoint.ClientWaypointImpl;
import journeymap.client.waypoint.WaypointHandler;
import journeymap.common.waypoint.WaypointGroupStore;
import journeymap.common.waypoint.WaypointStore;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.FrameLayout;
import net.minecraft.client.gui.layouts.GridLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LayoutSettings;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.layouts.SpacerElement;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class WaypointEditor
extends PopupButtonScreen<Waypoint>
implements SelectableParent {
    private TextBox nameTextBox;
    private TextBox xLocTextBox;
    private TextBox yLocTextBox;
    private TextBox zLocTextBox;
    private TextBox zyzLocTextBox;
    private boolean enabled;
    private int color;
    private DropDownButton iconDropDown;
    private DropDownButton groupDropDown;
    private List<DimensionSlot> dimensionSlots;
    private List<DropDownItem> iconDropDownItems;
    private List<DropDownItem> groupDropDownItems;
    private DimensionPanel<DimensionSlot> dimensionPanel;
    private DimensionSlot primarySlot;
    private LinearLayout layout = LinearLayout.vertical();
    private LinearLayout editorLayout;
    private ClientWaypointImpl waypoint;
    private final DynamicTexture question = TextureCache.getTexture(TextureCache.Question);
    private WaypointGroup group;
    private boolean isNewWaypoint = false;
    private boolean openedWithHotkey = false;

    public WaypointEditor(ClientWaypointImpl waypoint) {
        this((Component)Component.translatable((String)"jm.waypoint.edit_title"), waypoint, null);
    }

    public WaypointEditor(boolean openedWithHotkey, @Nullable BlockPos pos) {
        this((Component)Component.translatable((String)"jm.waypoint.new_title"), null, pos);
        this.openedWithHotkey = openedWithHotkey;
    }

    public WaypointEditor(Component title, @Nullable ClientWaypointImpl waypoint, @Nullable BlockPos pos) {
        super(title);
        this.isNewWaypoint = waypoint == null;
        this.waypoint = waypoint != null ? (ClientWaypointImpl)WaypointHandler.getInstance().getDao().copyWaypoint(waypoint) : this.buildNewWaypoint(pos);
    }

    public WaypointEditor(boolean openedWithHotkey, ClientWaypointImpl waypoint, WaypointGroup group) {
        this(false, null);
        this.group = group;
    }

    private ClientWaypointImpl buildNewWaypoint(@Nullable BlockPos pos) {
        LocalPlayer player = Minecraft.getInstance().player;
        return (ClientWaypointImpl)WaypointFactory.createClientWaypoint((String)"journeymap", (BlockPos)(pos == null ? player.blockPosition() : pos), (ResourceKey)player.level().dimension(), (boolean)true);
    }

    public void renderPopupScreenBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderTransparentBackground(guiGraphics);
        guiGraphics.blitSprite(BACKGROUND_SPRITE, this.editorLayout.getX() - 18, this.editorLayout.getY() - 18, this.editorLayout.getWidth() + 36, this.editorLayout.getHeight() + 36);
    }

    protected void renderPopupScreen(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.renderPopupScreen(graphics, mouseX, mouseY, partialTicks);
        Optional child = this.dimensionPanel.getChildAt(mouseX, mouseY);
        if (child.isPresent()) {
            List lastTooltip = this.dimensionPanel.lastTooltip;
            long lastTooltipTime = this.dimensionPanel.lastTooltipTime;
            if (this.dimensionPanel.lastTooltip != null && this.dimensionPanel.lastTooltip.equals(lastTooltip)) {
                this.dimensionPanel.lastTooltipTime = lastTooltipTime;
                if (System.currentTimeMillis() - this.dimensionPanel.lastTooltipTime > this.dimensionPanel.hoverDelay) {
                    graphics.renderTooltip(this.font, this.dimensionPanel.lastTooltip, mouseX, mouseY + 15);
                }
            }
        }
    }

    protected void init() {
        this.dimensionSlots = this.buildDimensionSlots();
        this.dimensionPanel = new DimensionPanel(this.minecraft, 0, 0, 20);
        this.iconDropDownItems = this.buildIconDropdownItems();
        this.groupDropDownItems = this.buildGroupDropdownItems();
        this.enabled = this.waypoint.isEnabled();
        this.setColor(this.waypoint.getIconColor());
        this.layout.spacing(6);
        this.editorLayout = LinearLayout.horizontal();
        this.layout.addChild((LayoutElement)this.editorLayout);
        LinearLayout editTab = (LinearLayout)this.editorLayout.addChild((LayoutElement)this.editTab());
        this.editorLayout.addChild((LayoutElement)this.dimensionsLayout());
        this.editorLayout.spacing(12);
        this.layout.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
        this.dimensionPanel.setSlots(this.dimensionSlots);
        this.dimensionPanel.initSlots();
        this.dimensionPanel.visitSlots(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addWidget((GuiEventListener)x$0);
        });
        this.repositionElements();
        this.setInitialFocus((GuiEventListener)this.nameTextBox);
    }

    protected void repositionElements() {
        this.layout.arrangeElements();
        this.dimensionPanel.repositionSlots();
        this.dimensionPanel.updateSize(120, this.layout.getHeight() - 20, 0, 0);
        this.layout.arrangeElements();
        FrameLayout.centerInRectangle((LayoutElement)this.layout, (ScreenRectangle)this.getRectangle());
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        DimensionSlot dimSlot;
        boolean clicked = super.mouseClicked(mouseX, mouseY, button);
        if (button == 0 && (dimSlot = (DimensionSlot)this.dimensionPanel.getSelected()) != null && this.dimensionPanel.isMouseOver(mouseX, mouseY)) {
            if (dimSlot.isPrimary() && !dimSlot.getDimId().equals(this.primarySlot.getDimId())) {
                this.dimensionPanel.getRootSlots().forEach(slot -> slot.setPrimary(false));
                dimSlot.setPrimary(true);
                this.primarySlot = dimSlot;
            }
            if (!this.dimensionPanel.getRootSlots().stream().anyMatch(DimensionSlot::isPrimary)) {
                this.primarySlot.setPrimary(true);
            }
        }
        return clicked;
    }

    private LinearLayout dimensionsLayout() {
        int size = 10;
        LinearLayout layout = LinearLayout.vertical();
        LinearLayout topLayout = LinearLayout.horizontal();
        topLayout.spacing(4);
        layout.spacing(6);
        topLayout.addChild((LayoutElement)new StringWidget((Component)Component.translatable((String)"jm.waypoint.dimensions").copy().withStyle(ChatFormatting.AQUA).withStyle(ChatFormatting.UNDERLINE), this.font));
        ColoredImageWidget image = (ColoredImageWidget)topLayout.addChild((LayoutElement)ColoredImageWidget.texture(size, size, this.question, size, size, 65535, true));
        image.setTooltip(Tooltip.create((Component)Component.translatable((String)"jm.waypoint.dimensions.question.tooltip")));
        layout.addChild((LayoutElement)topLayout, LayoutSettings::alignHorizontallyCenter);
        layout.addChild(this.dimensionPanel);
        return layout;
    }

    private LinearLayout editTab() {
        LinearLayout layout = LinearLayout.vertical();
        LinearLayout topLayout = LinearLayout.horizontal();
        layout.addChild((LayoutElement)new StringWidget((Component)this.getTitle().copy().withStyle(ChatFormatting.AQUA).withStyle(ChatFormatting.UNDERLINE), this.font), LayoutSettings::alignHorizontallyCenter);
        layout.addChild((LayoutElement)topLayout);
        layout.spacing(4);
        topLayout.spacing(4);
        topLayout.addChild((LayoutElement)new StringWidget((Component)Component.translatable((String)"jm.waypoint.name").copy().withStyle(ChatFormatting.AQUA).withStyle(ChatFormatting.UNDERLINE), this.font), LayoutSettings::alignVerticallyBottom);
        topLayout.addChild((LayoutElement)new SpacerElement(30, 20));
        this.groupDropDown = (DropDownButton)topLayout.addChild((LayoutElement)new DropDownButton("", this::onGroupSelectDropDown), LayoutSettings::alignVerticallyMiddle);
        this.groupDropDown.setItems(this.groupDropDownItems);
        this.groupDropDown.setDefaultStyle(false);
        this.groupDropDown.setDrawBackground(false);
        if (this.group != null && !this.group.getGuid().equals(WaypointGroupStore.ALL.getGuid())) {
            this.groupDropDown.setSelectedId(this.group.getGuid());
        } else {
            this.groupDropDown.setSelectedId(this.waypoint.getGroupId());
        }
        this.groupDropDown.setRenderSolidBackground(true);
        PopupButton createGroupButton = (PopupButton)topLayout.addChild(new PopupButton<WaypointGroup>(0, 0, "+", () -> new EditGroupPopup((Component)Component.translatable((String)"jm.waypoint.group.new_group.label")), this::addNewGroup), LayoutSettings::alignVerticallyMiddle);
        createGroupButton.setMessage((Component)Component.literal((String)"+").withStyle(ChatFormatting.DARK_GREEN));
        createGroupButton.setSize(12, 12);
        createGroupButton.setTooltip(Tooltip.create((Component)Component.translatable((String)"jm.waypoint.group.new_group.label")));
        this.nameTextBox = (TextBox)layout.addChild((LayoutElement)new TextBox(this.waypoint.getName(), this.font, 222, 20));
        GridLayout locGridLayout = new GridLayout();
        locGridLayout.columnSpacing(6);
        locGridLayout.rowSpacing(4);
        layout.addChild((LayoutElement)locGridLayout);
        locGridLayout.addChild((LayoutElement)new StringWidget((Component)Component.translatable((String)"jm.waypoint.x").copy().withStyle(ChatFormatting.AQUA).withStyle(ChatFormatting.UNDERLINE), this.font), 0, 0);
        this.xLocTextBox = (TextBox)locGridLayout.addChild((LayoutElement)new TextBox(this.waypoint.getX(), this.font, 70, 20, true, true), 1, 0);
        locGridLayout.addChild((LayoutElement)new StringWidget((Component)Component.translatable((String)"jm.waypoint.z").copy().withStyle(ChatFormatting.AQUA).withStyle(ChatFormatting.UNDERLINE), this.font), 0, 1);
        locGridLayout.addChild((LayoutElement)new StringWidget((Component)Component.translatable((String)"jm.waypoint.y").copy().withStyle(ChatFormatting.AQUA).withStyle(ChatFormatting.UNDERLINE), this.font), 0, 2);
        this.zLocTextBox = (TextBox)locGridLayout.addChild((LayoutElement)new TextBox(this.waypoint.getZ(), this.font, 70, 20, true, true), 1, 1);
        this.yLocTextBox = (TextBox)locGridLayout.addChild((LayoutElement)new TextBox(this.waypoint.getY(), this.font, 70, 20, true, true), 1, 2);
        LinearLayout colorLayout = LinearLayout.horizontal();
        colorLayout.spacing(10);
        layout.addChild((LayoutElement)colorLayout, LayoutSettings::alignHorizontallyCenter);
        colorLayout.addChild((LayoutElement)Button.builder((Component)Component.translatable((String)"jm.waypoint.randomize"), this::randomColor).width(20 + this.font.width((FormattedText)Component.translatable((String)"jm.waypoint.randomize"))).build(), LayoutSettings::alignVerticallyMiddle);
        this.iconDropDown = (DropDownButton)colorLayout.addChild((LayoutElement)new DropDownButton("", this::iconDropDown), LayoutSettings::alignVerticallyMiddle);
        this.iconDropDown.setItems(this.iconDropDownItems);
        this.iconDropDown.setDefaultStyle(false);
        this.iconDropDown.setDrawBackground(false);
        this.iconDropDown.setSelectedId(this.waypoint.getIconResourceLocation().toString().replace("ui/img", "textures/waypoint/icon"));
        this.iconDropDown.setRenderSolidBackground(true);
        colorLayout.addChild((LayoutElement)new ColorPickerButton(20, 20, () -> this.waypoint.getRenderColor(), this::updateWaypointColor));
        LinearLayout bottomOneLayout = LinearLayout.horizontal();
        LinearLayout bottomTwoLayout = LinearLayout.horizontal();
        layout.addChild((LayoutElement)bottomOneLayout, LayoutSettings::alignHorizontallyCenter);
        layout.addChild((LayoutElement)bottomTwoLayout, LayoutSettings::alignHorizontallyCenter);
        bottomOneLayout.spacing(4);
        bottomTwoLayout.spacing(4);
        bottomOneLayout.addChild((LayoutElement)Button.builder((Component)Component.translatable((String)"jm.waypoint.enable.toggle", (Object[])new Object[]{this.enabled ? "On" : "Off"}), this::toggle).width(20 + this.font.width((FormattedText)Component.translatable((String)"jm.waypoint.enable.toggle", (Object[])new Object[]{this.enabled ? "On" : "Off"}))).build());
        bottomOneLayout.addChild((LayoutElement)Button.builder((Component)Component.translatable((String)"jm.waypoint.reset"), this::reset).width(20 + this.font.width((FormattedText)Component.translatable((String)"jm.waypoint.reset"))).build());
        PopupButton deleteButton = (PopupButton)bottomTwoLayout.addChild(new PopupButton<Boolean>(20 + this.font.width(Constants.getString("jm.common.delete")), 0, Constants.getString("jm.common.delete"), () -> new DeleteConfirmWaypointPopup(this.waypoint), this::delete));
        if (this.isNewWaypoint) {
            deleteButton.setEnabled(false);
        }
        bottomTwoLayout.addChild((LayoutElement)Button.builder((Component)Component.translatable((String)"jm.waypoint.save"), this::save).width(20 + this.font.width((FormattedText)Component.translatable((String)"jm.waypoint.save"))).build());
        bottomTwoLayout.addChild((LayoutElement)Button.builder((Component)Component.translatable((String)"jm.common.cancel"), this::cancel).width(20 + this.font.width((FormattedText)Component.translatable((String)"jm.common.cancel"))).build());
        return layout;
    }

    private void addNewGroup(WaypointGroup group) {
        if (!EventBus.post(new WaypointGroupEvent(group, WaypointGroupEvent.Context.CREATE)).isCancelled()) {
            if (this.backgroundScreen == null || !(this.backgroundScreen instanceof WaypointManager)) {
                WaypointGroupStore.getInstance().put(group);
            }
            this.groupDropDownItems = this.buildGroupDropdownItems();
            this.groupDropDown.setItems(this.groupDropDownItems);
        }
    }

    private void randomColor(Button button) {
        this.setColor(RGB.randomColor());
    }

    private void setColor(int color) {
        this.color = color;
        this.iconDropDownItems.forEach(item -> ((ImageDropDownItem)((Object)item)).setColor(color));
    }

    private void toggle(Button button) {
        this.enabled = !this.enabled;
        button.setMessage((Component)Component.translatable((String)"jm.waypoint.enable.toggle", (Object[])new Object[]{this.enabled ? "On" : "Off"}));
    }

    private void delete(boolean button) {
        EventBus.post(new WaypointEvent((Waypoint)this.waypoint, WaypointEvent.Context.DELETED, null));
        this.onClose();
    }

    private void save(Button button) {
        this.waypoint.setName(this.nameTextBox.getValue());
        this.waypoint.setX(Integer.parseInt(this.xLocTextBox.getValue()));
        this.waypoint.setY(Integer.parseInt(this.yLocTextBox.getValue()));
        this.waypoint.setZ(Integer.parseInt(this.zLocTextBox.getValue()));
        this.waypoint.getIcon().setResourceLoctaion(ResourceLocation.parse((String)this.iconDropDown.getSelected().getId().toString()));
        this.waypoint.setEnabled(this.enabled);
        this.waypoint.setColor(this.color);
        if (this.groupDropDown.getSelected() == null) {
            this.waypoint.setGroupId(WaypointGroupStore.DEFAULT.getGuid());
        } else {
            this.waypoint.setGroupId(this.groupDropDown.getSelected().getId().toString());
        }
        List<String> dims = this.dimensionSlots.stream().filter(DimensionSlot::isEnabled).map(DimensionSlot::getDimId).toList();
        this.waypoint.setDimensions(dims);
        Optional<DimensionSlot> primary = this.dimensionSlots.stream().filter(DimensionSlot::isEnabled).filter(DimensionSlot::isPrimary).findFirst();
        primary.ifPresent(dimensionSlot -> this.waypoint.setPrimaryDimension(dimensionSlot.getDimId()));
        if (!(EventBus.post(new WaypointEvent((Waypoint)this.waypoint, this.isNewWaypoint ? WaypointEvent.Context.CREATE : WaypointEvent.Context.UPDATE, null)).isCancelled() || this.backgroundScreen != null && this.backgroundScreen instanceof WaypointManager)) {
            WaypointStore.getInstance().save(this.waypoint, false, this.isNewWaypoint);
        }
        this.onClose();
    }

    private void cancel(Button button) {
        this.onClose();
    }

    private void reset(Button button) {
        double scrollPos = this.dimensionPanel.getScrollAmount();
        this.clearWidgets();
        this.layout = LinearLayout.vertical();
        this.init();
        this.dimensionPanel.setScrollAmount(scrollPos);
    }

    private void updateWaypointColor(ColorPickerScreen.ColorPickerResponse colorPickerResponse) {
        if (!colorPickerResponse.canceled()) {
            this.setColor(colorPickerResponse.color());
        }
    }

    private LinearLayout tabs() {
        LinearLayout layout = LinearLayout.horizontal();
        layout.spacing(6);
        layout.addChild((LayoutElement)Button.builder((Component)Component.translatable((String)"Edit"), b -> this.tab()).width(50).build());
        layout.addChild((LayoutElement)Button.builder((Component)Component.translatable((String)"Server"), b -> this.tab()).width(50).build());
        layout.addChild((LayoutElement)Button.builder((Component)Component.translatable((String)"Options"), b -> this.tab()).width(50).build());
        return layout;
    }

    void tab() {
    }

    private List<DropDownItem> buildIconDropdownItems() {
        ArrayList<DropDownItem> list = new ArrayList<DropDownItem>();
        TextureCache.waypointIconMap.forEach((loc, tex) -> {
            ImageDropDownItem icon = new ImageDropDownItem((SelectableParent)this, loc, (DynamicTexture)tex, 16, 16, this::onIconSelect, loc.toString());
            icon.setColor(this.waypoint.getIconColor());
            list.add(icon);
        });
        return list;
    }

    private List<DropDownItem> buildGroupDropdownItems() {
        ArrayList<DropDownItem> list = new ArrayList<DropDownItem>();
        if (!this.waypoint.getGroup().isLocked()) {
            WaypointGroupStore.getInstance().getAll().forEach(group -> {
                if (!(group.getGuid().equals(WaypointGroupStore.TEMP.getGuid()) || group.getGuid().equals(WaypointGroupStore.DEATH.getGuid()) || group.getGuid().equals(WaypointGroupStore.ALL.getGuid()))) {
                    list.add(new DropDownItem((SelectableParent)this, (Object)group.getGuid(), this.clipText(group.getName()), group.getName()));
                }
            });
        } else {
            list.add(new DropDownItem((SelectableParent)this, (Object)this.waypoint.getGroup().getGuid(), this.waypoint.getGroup().getName(), this.waypoint.getGroup().getName()));
        }
        return list;
    }

    private String clipText(String message) {
        int maxWidth = this.font.width("XXXXXXXXX");
        int width = this.font.width(message);
        Font font = Minecraft.getInstance().font;
        if (width > maxWidth) {
            String formattedtext = font.plainSubstrByWidth(message, maxWidth - font.width((FormattedText)CommonComponents.ELLIPSIS));
            return formattedtext + "...";
        }
        return message;
    }

    private void onIconSelect(Button button) {
    }

    private void iconDropDown(Button button) {
    }

    @Override
    public void setSelected(DropDownItem button) {
        if (button instanceof ImageDropDownItem) {
            ImageDropDownItem imgButton = (ImageDropDownItem)button;
            this.iconDropDown.setSelected(imgButton);
        } else {
            this.groupDropDown.setSelected(button);
        }
    }

    private void onGroupSelectDropDown(Button button) {
    }

    private List<DimensionSlot> buildDimensionSlots() {
        ArrayList<DimensionSlot> list = new ArrayList<DimensionSlot>();
        for (WorldData.DimensionProvider provider : WorldData.getDimensionProviders(WaypointStore.getInstance().getLoadedDimensions())) {
            String dimName = WorldData.getSafeDimensionName(provider);
            String dimId = provider.getDimensionId();
            try {
                dimName = provider.getName();
            }
            catch (Exception e) {
                JMLogger.throwLogOnce("Can't get dimension name from provider: ", e);
            }
            DimensionSlot slot = new DimensionSlot(dimId, dimName, this.waypoint.getDimensions().contains(dimId), this.waypoint.getPrimaryDimension().equals(provider.getDimensionId()));
            if (slot.isPrimary()) {
                this.primarySlot = slot;
            }
            list.add(slot);
        }
        return list;
    }

    public boolean charTyped(char typedChar, int keyCode) {
        if (this.openedWithHotkey && this.isNewWaypoint) {
            this.openedWithHotkey = false;
            return true;
        }
        return super.charTyped(typedChar, keyCode);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 257) {
            this.save(null);
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }
}

