/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.component.screens;

import java.awt.Color;
import java.util.Arrays;
import java.util.List;
import java.util.Stack;
import java.util.stream.Collectors;
import journeymap.client.Constants;
import journeymap.client.render.RenderWrapper;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.texture.TextureAccess;
import journeymap.client.texture.TextureCache;
import journeymap.client.ui.UIManager;
import journeymap.client.ui.component.buttons.Button;
import journeymap.client.ui.component.screens.JmUI;
import journeymap.common.Journeymap;
import journeymap.common.log.LogFormatter;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import org.apache.logging.log4j.Logger;
import org.joml.Matrix4f;

public abstract class JmUILegacy
extends Screen {
    protected final String title;
    protected final int headerHeight = 36;
    protected final int footerHeight = 30;
    protected final Logger logger = Journeymap.getLogger();
    protected double scaleFactor = 1.0;
    protected static Stack<Screen> returnDisplayStack = JmUI.returnDisplayStack;
    protected DynamicTexture logo = TextureCache.getTexture(TextureCache.Logo);
    protected boolean renderBottomBar = false;

    public JmUILegacy(String title) {
        this(title, null);
    }

    public JmUILegacy(String title, Screen returnDisplay) {
        super((Component)Constants.getStringTextComponent(title));
        this.title = title;
        returnDisplayStack.push(returnDisplay);
    }

    public Minecraft getMinecraft() {
        this.minecraft = Minecraft.getInstance();
        return this.minecraft;
    }

    public void init(Minecraft minecraft, int width, int height) {
        super.init(minecraft, width, height);
        this.scaleFactor = JmUI.calculateScaleFactor();
    }

    public boolean isPauseScreen() {
        return true;
    }

    public Font getFontRenderer() {
        return this.font;
    }

    public void sizeDisplay(boolean scaled) {
        int glwidth = scaled ? this.width : this.minecraft.getWindow().getScreenWidth();
        int glheight = scaled ? this.height : this.minecraft.getWindow().getScreenHeight();
        DrawUtil.sizeDisplay(glwidth, glheight);
    }

    protected boolean isMouseOverButton(double mouseX, double mouseY) {
        for (int k = 0; k < this.getRenderables().size(); ++k) {
            Button button;
            net.minecraft.client.gui.components.Button guibutton = (net.minecraft.client.gui.components.Button)this.getRenderables().get(k);
            if (!(guibutton instanceof Button) || !(button = (Button)guibutton).mouseOver(mouseX, mouseY)) continue;
            return true;
        }
        return false;
    }

    public boolean mouseReleased(double mouseX, double mouseY, int mouseEvent) {
        return super.mouseReleased(mouseX, mouseY, mouseEvent);
    }

    protected void drawLogo(GuiGraphics graphics) {
        if (!((TextureAccess)this.logo).journeymap$hasImage()) {
            this.logo = TextureCache.getTexture(TextureCache.Logo);
        }
        DrawUtil.sizeDisplay(this.minecraft.getWindow().getScreenWidth(), this.minecraft.getWindow().getScreenHeight());
        DrawUtil.drawImage(graphics.pose(), this.logo, 8.0, 8.0, false, 0.5f, 0.0);
        DrawUtil.sizeDisplay(this.width, this.height);
    }

    protected void renderBottomBar(GuiGraphics graphics) {
        if (this.renderBottomBar) {
            DrawUtil.drawRectangle(graphics, 0.0, this.height - 30, this.width, this.height, 0, 0.6f);
        }
    }

    protected void drawTitle(GuiGraphics graphics) {
        DrawUtil.drawRectangle(graphics, 0.0, 0.0, this.width, 36.0, 0, 0.9f);
        DrawUtil.drawLabel(graphics, this.title, this.width / 2, 18.0, DrawUtil.HAlign.Center, DrawUtil.VAlign.Middle, 0, 0.0f, Color.CYAN.getRGB(), 1.0f, 1.0, true, 0.0);
        String apiVersion = "API v2.0.0-SNAPSHOT";
        DrawUtil.drawLabel(graphics, apiVersion, this.width - 10, 18.0, DrawUtil.HAlign.Left, DrawUtil.VAlign.Middle, 0, 0.0f, 0xCCCCCC, 1.0f, 0.5, true, 0.0);
    }

    public void init() {
        this.getRenderables().clear();
    }

    public void renderBackground(GuiGraphics graphics, int i, int j, float f) {
        if (Minecraft.getInstance().level == null) {
            this.drawGradientRect(graphics, 0, 0, this.width, this.height, -1072689136, -804253680, 0);
        } else {
            super.renderBackground(graphics, i, j, f);
        }
    }

    protected abstract void layoutButtons(GuiGraphics var1);

    public List getButtonList() {
        return this.getRenderables();
    }

    public void render(GuiGraphics graphics, int x, int y, float partialTicks) {
        try {
            this.renderBackground(graphics, x, y, partialTicks);
            this.renderBottomBar(graphics);
            this.layoutButtons(graphics);
            this.drawTitle(graphics);
            this.drawLogo(graphics);
            List<FormattedCharSequence> tooltip = null;
            for (int k = 0; k < this.getRenderables().size(); ++k) {
                Button button;
                Renderable guibutton = this.getRenderables().get(k);
                guibutton.render(graphics, x, y, 0.0f);
                if (tooltip != null || !(guibutton instanceof Button) || !(button = (Button)guibutton).mouseOver(x, y)) continue;
                tooltip = button.getWrappedTooltip();
            }
            if (tooltip != null && !tooltip.isEmpty()) {
                this.renderWrappedToolTip(graphics, tooltip, x, y, this.getFontRenderer());
            }
        }
        catch (Throwable t) {
            Journeymap.getLogger().error("Error in UI: " + LogFormatter.toString(t));
            this.closeAndReturn();
        }
    }

    public void drawGradientRect(GuiGraphics graphics, int pX1, int pY1, int pX2, int pY2, int pColorFrom, int pColorTo, int pBlitOffset) {
        graphics.fillGradient(RenderType.guiOverlay(), pX1, pY1, pX2, pY2, pColorFrom, pColorTo, pBlitOffset);
    }

    protected void closeAndReturn() {
        if (returnDisplayStack == null || returnDisplayStack.peek() == null) {
            UIManager.INSTANCE.closeAll();
        } else {
            UIManager.INSTANCE.open(returnDisplayStack.pop());
        }
    }

    public void closeWithKeyBind() {
        this.closeAndReturn();
    }

    public boolean charTyped(char c, int i) {
        return super.charTyped(c, i);
    }

    public void setRenderBottomBar(boolean renderBottomBar) {
        this.renderBottomBar = renderBottomBar;
    }

    public boolean keyPressed(int key, int value, int modifier) {
        switch (key) {
            case 256: {
                this.closeAndReturn();
                return true;
            }
        }
        return super.keyPressed(key, value, modifier);
    }

    public void renderTooltip(GuiGraphics graphics, String[] tooltip, int mouseX, int mouseY) {
        List tooltips = Arrays.stream(tooltip).map(e -> FormattedCharSequence.forward((String)e, (Style)Style.EMPTY)).collect(Collectors.toList());
        this.renderWrappedToolTip(graphics, tooltips, mouseX, mouseY, this.getFontRenderer());
    }

    public Screen getReturnDisplay() {
        return returnDisplayStack.peek();
    }

    public void renderWrappedToolTip(GuiGraphics graphics, List tooltip, int mouseX, int mouseY, Font fontRenderer) {
        if (!tooltip.isEmpty() && tooltip.get(0) instanceof FormattedCharSequence && Minecraft.getInstance().screen == this) {
            RenderWrapper.disableDepthTest();
            int maxLineWidth = 0;
            for (FormattedCharSequence line : tooltip) {
                int lineWidth = fontRenderer.width(line);
                if (fontRenderer.isBidirectional()) {
                    lineWidth = (int)Math.ceil((double)lineWidth * 1.25);
                }
                if (lineWidth <= maxLineWidth) continue;
                maxLineWidth = lineWidth;
            }
            int drawX = mouseX + 12;
            int drawY = mouseY - 12;
            int boxHeight = 8;
            if (tooltip.size() > 1) {
                boxHeight += 2 + (tooltip.size() - 1) * 10;
            }
            if (drawX + maxLineWidth > this.width) {
                drawX -= 28 + maxLineWidth;
            }
            if (drawY + boxHeight + 6 > this.height) {
                drawY = this.height - boxHeight - 6;
            }
            int j1 = -267386864;
            this.drawGradientRect(graphics, drawX - 3, drawY - 4, drawX + maxLineWidth + 3, drawY - 3, j1, j1, 300);
            this.drawGradientRect(graphics, drawX - 3, drawY + boxHeight + 3, drawX + maxLineWidth + 3, drawY + boxHeight + 4, j1, j1, 300);
            this.drawGradientRect(graphics, drawX - 3, drawY - 3, drawX + maxLineWidth + 3, drawY + boxHeight + 3, j1, j1, 300);
            this.drawGradientRect(graphics, drawX - 4, drawY - 3, drawX - 3, drawY + boxHeight + 3, j1, j1, 300);
            this.drawGradientRect(graphics, drawX + maxLineWidth + 3, drawY - 3, drawX + maxLineWidth + 4, drawY + boxHeight + 3, j1, j1, 300);
            int k1 = 0x505000FF;
            int l1 = (k1 & 0xFEFEFE) >> 1 | k1 & 0xFF000000;
            this.drawGradientRect(graphics, drawX - 3, drawY - 3 + 1, drawX - 3 + 1, drawY + boxHeight + 3 - 1, k1, l1, 300);
            this.drawGradientRect(graphics, drawX + maxLineWidth + 2, drawY - 3 + 1, drawX + maxLineWidth + 3, drawY + boxHeight + 3 - 1, k1, l1, 300);
            this.drawGradientRect(graphics, drawX - 3, drawY - 3, drawX + maxLineWidth + 3, drawY - 3 + 1, k1, k1, 300);
            this.drawGradientRect(graphics, drawX - 3, drawY + boxHeight + 2, drawX + maxLineWidth + 3, drawY + boxHeight + 3, l1, l1, 300);
            for (int i2 = 0; i2 < tooltip.size(); ++i2) {
                FormattedCharSequence line = (FormattedCharSequence)tooltip.get(i2);
                Matrix4f matrixPos = graphics.pose().last().pose();
                if (fontRenderer.isBidirectional()) {
                    int lineWidth = (int)Math.ceil((double)fontRenderer.width(line) * 1.1);
                    fontRenderer.drawInBatch(line, (float)(drawX + maxLineWidth - lineWidth), (float)drawY, -1, true, matrixPos, (MultiBufferSource)graphics.bufferSource(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
                } else {
                    fontRenderer.drawInBatch(line, (float)drawX, (float)drawY, -1, true, matrixPos, (MultiBufferSource)graphics.bufferSource(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
                }
                if (i2 == 0) {
                    drawY += 2;
                }
                drawY += 10;
            }
            RenderWrapper.enableDepthTest();
        }
    }

    public List<Renderable> getRenderables() {
        return this.renderables;
    }
}

