/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.model;

import com.google.common.cache.Cache;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import journeymap.client.data.DataCache;
import journeymap.client.io.FileHandler;
import journeymap.client.io.nbt.RegionLoader;
import journeymap.client.model.MapType;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;

public class RegionCoord
implements Comparable<RegionCoord> {
    public static final transient int SIZE = 5;
    private static final transient int chunkSqRt = (int)Math.pow(2.0, 5.0);
    public final File worldDir;
    public final Path dimDir;
    public final int regionX;
    public final int regionZ;
    public final ResourceKey<Level> dimension;
    private final int theHashCode;
    private final String theCacheKey;
    private final String fileName;

    public RegionCoord(File worldDir, int regionX, int regionZ, ResourceKey<Level> dimension) {
        this(worldDir, regionX, regionZ, dimension, true);
    }

    public RegionCoord(File worldDir, int regionX, int regionZ, ResourceKey<Level> dimension, boolean createCache) {
        this.worldDir = worldDir;
        this.dimDir = createCache ? FileHandler.getDimPath(worldDir, dimension) : null;
        this.regionX = regionX;
        this.regionZ = regionZ;
        this.dimension = dimension;
        this.theCacheKey = RegionCoord.toCacheKey(this.dimDir, regionX, regionZ);
        this.theHashCode = this.theCacheKey.hashCode();
        this.fileName = regionX + "," + regionZ + ".png";
    }

    public static RegionCoord fromChunkPos(File worldDir, MapType mapType, int chunkX, int chunkZ) {
        int regionX = RegionCoord.getRegionPos(chunkX);
        int regionZ = RegionCoord.getRegionPos(chunkZ);
        return RegionCoord.fromRegionPos(worldDir, regionX, regionZ, mapType.dimension);
    }

    public static RegionCoord fromRegionPos(File worldDir, int regionX, int regionZ, ResourceKey<Level> dimension) {
        Cache<String, RegionCoord> cache = DataCache.INSTANCE.getRegionCoords();
        RegionCoord regionCoord = (RegionCoord)cache.getIfPresent((Object)RegionCoord.toCacheKey(FileHandler.getDimPath(worldDir, dimension), regionX, regionZ));
        if (regionCoord == null || regionX != regionCoord.regionX || regionZ != regionCoord.regionZ || dimension != regionCoord.dimension) {
            regionCoord = new RegionCoord(worldDir, regionX, regionZ, dimension);
            cache.put((Object)regionCoord.theCacheKey, (Object)regionCoord);
        }
        return regionCoord;
    }

    public static int getMinChunkX(int rX) {
        return rX << 5;
    }

    public static int getMaxChunkX(int rX) {
        return RegionCoord.getMinChunkX(rX) + (int)Math.pow(2.0, 5.0) - 1;
    }

    public static int getMinChunkZ(int rZ) {
        return rZ << 5;
    }

    public static int getMaxChunkZ(int rZ) {
        return RegionCoord.getMinChunkZ(rZ) + (int)Math.pow(2.0, 5.0) - 1;
    }

    public static int getRegionPos(int chunkPos) {
        return chunkPos >> 5;
    }

    public static String toCacheKey(Path dimDir, int regionX, int regionZ) {
        return regionX + (dimDir == null ? "" : dimDir.toString()) + regionZ;
    }

    public boolean exists() {
        return RegionLoader.getRegionFile(Minecraft.getInstance(), this.getMinChunkX(), this.getMinChunkZ()).exists();
    }

    public int getXOffset(int chunkX) {
        if (chunkX >> 5 != this.regionX) {
            throw new IllegalArgumentException("chunkX " + chunkX + " out of bounds for regionX " + this.regionX);
        }
        int offset = chunkX % chunkSqRt * 16;
        if (offset < 0) {
            offset = chunkSqRt * 16 + offset;
        }
        return offset;
    }

    public int getZOffset(int chunkZ) {
        if (RegionCoord.getRegionPos(chunkZ) != this.regionZ) {
            throw new IllegalArgumentException("chunkZ " + chunkZ + " out of bounds for regionZ " + this.regionZ);
        }
        int offset = chunkZ % chunkSqRt * 16;
        if (offset < 0) {
            offset = chunkSqRt * 16 + offset;
        }
        return offset;
    }

    public ChunkPos getCenterChunk() {
        int midX = this.getMaxChunkX() + this.getMinChunkX() >> 1;
        int midZ = this.getMaxChunkZ() + this.getMinChunkZ() >> 1;
        return new ChunkPos(midX, midZ);
    }

    public BlockPos getMiddleBlock() {
        ChunkPos mid = this.getCenterChunk();
        return new BlockPos(mid.getMaxBlockZ(), 0, mid.getMaxBlockZ());
    }

    public int getMinChunkX() {
        return RegionCoord.getMinChunkX(this.regionX);
    }

    public int getMaxChunkX() {
        return RegionCoord.getMaxChunkX(this.regionX);
    }

    public int getMinChunkZ() {
        return RegionCoord.getMinChunkZ(this.regionZ);
    }

    public int getMaxChunkZ() {
        return RegionCoord.getMaxChunkZ(this.regionZ);
    }

    public ChunkPos getMinChunkCoord() {
        return new ChunkPos(this.getMinChunkX(), this.getMinChunkZ());
    }

    public ChunkPos getMaxChunkCoord() {
        return new ChunkPos(this.getMaxChunkX(), this.getMaxChunkZ());
    }

    public List<ChunkPos> getChunkCoordsInRegion() {
        ArrayList<ChunkPos> list = new ArrayList<ChunkPos>(1024);
        ChunkPos min = this.getMinChunkCoord();
        ChunkPos max = this.getMaxChunkCoord();
        for (int x = min.x; x <= max.x; ++x) {
            for (int z = min.z; z <= max.z; ++z) {
                list.add(new ChunkPos(x, z));
            }
        }
        return list;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("RegionCoord [");
        builder.append(this.regionX);
        builder.append(",");
        builder.append(this.regionZ);
        builder.append("]");
        return builder.toString();
    }

    public String getFileName() {
        return this.fileName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RegionCoord that = (RegionCoord)o;
        if (this.dimension != that.dimension) {
            return false;
        }
        if (this.regionX != that.regionX) {
            return false;
        }
        if (this.regionZ != that.regionZ) {
            return false;
        }
        if (!this.dimDir.equals(that.dimDir)) {
            return false;
        }
        return this.worldDir.equals(that.worldDir);
    }

    public String cacheKey() {
        return this.theCacheKey;
    }

    public int hashCode() {
        return this.theHashCode;
    }

    @Override
    public int compareTo(RegionCoord o) {
        int cx = Double.compare(this.regionX, o.regionX);
        return cx == 0 ? Double.compare(this.regionZ, o.regionZ) : cx;
    }

    public static Comparator<RegionCoord> getComparator() {
        return new Comparator<RegionCoord>(){

            @Override
            public int compare(RegionCoord o1, RegionCoord o2) {
                Float d1 = Float.valueOf(this.distanceToPlayer(o1));
                Float d2 = Float.valueOf(this.distanceToPlayer(o2));
                int comp = d2.compareTo(d1);
                if (comp == 0) {
                    return o2.compareTo(o1);
                }
                return comp;
            }

            float distanceToPlayer(RegionCoord rc) {
                float x = rc.regionX - Minecraft.getInstance().player.chunkPosition().getRegionX();
                float z = rc.regionZ - Minecraft.getInstance().player.chunkPosition().getRegionZ();
                return x * x + z * z;
            }
        };
    }
}

