/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.mod.vanilla;

import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import journeymap.api.services.Services;
import journeymap.client.JourneymapClient;
import journeymap.client.cartography.color.ColorManager;
import journeymap.client.cartography.color.ColoredSprite;
import journeymap.client.cartography.color.RGB;
import journeymap.client.mod.IBlockColorProxy;
import journeymap.client.model.BiomeMD;
import journeymap.client.model.BlockFlag;
import journeymap.client.model.BlockMD;
import journeymap.client.model.ChunkMD;
import journeymap.client.properties.CoreProperties;
import journeymap.client.world.BiomeColors;
import journeymap.client.world.JmBlockAccess;
import journeymap.common.Journeymap;
import journeymap.common.log.LogFormatter;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.logging.log4j.Logger;

public class VanillaBlockColorProxy
implements IBlockColorProxy {
    static Logger logger = Journeymap.getLogger();
    private final BlockColors blockColors = Minecraft.getInstance().getBlockColors();
    private final CoreProperties coreProperties = JourneymapClient.getInstance().getCoreProperties();

    @Override
    public int deriveBlockColor(BlockMD blockMD, @Nullable ChunkMD chunkMD, @Nullable BlockPos blockPos) {
        BlockState blockState = blockMD.getBlockState();
        try {
            if (blockState.getBlock() instanceof LiquidBlock) {
                return VanillaBlockColorProxy.getSpriteColor(blockMD, 0xBCBCBC, chunkMD, blockPos);
            }
            Integer color = VanillaBlockColorProxy.getSpriteColor(blockMD, null, chunkMD, blockPos);
            if (color == null) {
                color = VanillaBlockColorProxy.setBlockColorToMaterial(blockMD);
            }
            return color;
        }
        catch (Throwable e) {
            logger.error("Error deriving color for " + String.valueOf(blockMD) + ": " + LogFormatter.toPartialString(e));
            blockMD.addFlags(BlockFlag.Error);
            return VanillaBlockColorProxy.setBlockColorToMaterial(blockMD);
        }
    }

    @Override
    public int getBlockColor(ChunkMD chunkMD, BlockMD blockMD, BlockPos blockPos) {
        boolean showBiomeWaterColor = this.coreProperties.mapWaterBiomeColors.get();
        int result = blockMD.getTextureColor(chunkMD, blockPos);
        if (blockMD.isFoliage()) {
            result = RGB.adjustBrightness(result, 0.8f);
        } else if (!(!blockMD.isFluid() || blockMD.isWater() && showBiomeWaterColor)) {
            return RGB.multiply(result, Services.CLIENT_SERVICE.getFluidTint(blockMD));
        }
        return RGB.multiply(result, this.getColorMultiplier(chunkMD, blockMD, blockPos, blockMD.getBlockState().getRenderShape().ordinal()));
    }

    public int getColorMultiplier(ChunkMD chunkMD, BlockMD blockMD, BlockPos blockPos, int tintIndex) {
        boolean blendFoliage = this.coreProperties.mapBlendFoliage.get();
        boolean blendGrass = this.coreProperties.mapBlendGrass.get();
        boolean blendWater = this.coreProperties.mapBlendWater.get();
        if (blockMD.isGrass()) {
            if (blendGrass) {
                return BiomeColors.getAverageGrassColor(JmBlockAccess.INSTANCE, blockPos);
            }
            return BiomeMD.get((ResourceKey<Biome>)((ResourceKey)chunkMD.getBiomeHolder(blockPos).unwrapKey().get())).getGrassColor(blockPos.getX(), blockPos.getZ());
        }
        if (blockMD.isFoliage()) {
            if (blendFoliage) {
                return BiomeColors.getAverageFoliageColor(JmBlockAccess.INSTANCE, blockPos);
            }
            return BiomeMD.get((ResourceKey<Biome>)((ResourceKey)chunkMD.getBiomeHolder(blockPos).unwrapKey().get())).getFoliageColor();
        }
        if (blockMD.isWater()) {
            if (blendWater) {
                return BiomeColors.getAverageWaterColor(JmBlockAccess.INSTANCE, blockPos);
            }
            return BiomeMD.get((ResourceKey<Biome>)((ResourceKey)chunkMD.getBiomeHolder(blockPos).unwrapKey().get())).getWaterColor();
        }
        return this.blockColors.getColor(blockMD.getBlockState(), (BlockAndTintGetter)JmBlockAccess.INSTANCE, blockPos, tintIndex);
    }

    public static Integer getSpriteColor(@Nonnull BlockMD blockMD, @Nullable Integer defaultColor, @Nullable ChunkMD chunkMD, @Nullable BlockPos blockPos) {
        Collection<ColoredSprite> sprites = blockMD.getBlockSpritesProxy().getSprites(blockMD, chunkMD, blockPos);
        float[] rgba = ColorManager.INSTANCE.getAverageColor(sprites);
        if (rgba != null) {
            return RGB.toInteger(rgba);
        }
        return defaultColor;
    }

    public static int setBlockColorToError(BlockMD blockMD) {
        blockMD.setAlpha(0.0f);
        blockMD.addFlags(BlockFlag.Ignore, BlockFlag.Error);
        blockMD.setColor(-1);
        return -1;
    }

    public static int setBlockColorToMaterial(BlockMD blockMD) {
        try {
            blockMD.setAlpha(1.0f);
            blockMD.addFlags(BlockFlag.Ignore);
            return blockMD.setColor(blockMD.getBlock().defaultMapColor().col);
        }
        catch (Exception e) {
            logger.warn(String.format("Failed to use MaterialMapColor, marking as error: %s", blockMD));
            return VanillaBlockColorProxy.setBlockColorToError(blockMD);
        }
    }
}

