/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.io.nbt;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import java.util.EnumSet;
import journeymap.common.Journeymap;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.IdMap;
import net.minecraft.core.Registry;
import net.minecraft.core.SectionPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.PalettedContainer;
import net.minecraft.world.level.chunk.PalettedContainerRO;
import net.minecraft.world.level.chunk.status.ChunkType;
import net.minecraft.world.level.chunk.storage.ChunkSerializer;
import net.minecraft.world.level.levelgen.Heightmap;
import org.apache.logging.log4j.Logger;

public class CustomChunkReader {
    private static final Logger logger = Journeymap.getLogger();

    public static ProcessedChunk read(ClientLevel level, ChunkPos chunkPos, CompoundTag chunkTag) {
        if (ChunkType.LEVELCHUNK == ChunkSerializer.getChunkTypeFromTag((CompoundTag)chunkTag)) {
            byte[][][][] lights = new byte[24][16][16][16];
            boolean lightOn = chunkTag.getBoolean("isLightOn");
            ListTag sections = chunkTag.getList("sections", 10);
            int sectionsCount = level.getSectionsCount();
            LevelChunkSection[] chunkSections = new LevelChunkSection[sectionsCount];
            Registry registry = level.registryAccess().registryOrThrow(Registries.BIOME);
            Codec codec = ChunkSerializer.makeBiomeCodec((Registry)registry);
            for (int j = 0; j < sections.size(); ++j) {
                CompoundTag section = sections.getCompound(j);
                byte sectionTopY = section.getByte("Y");
                int sectionIndex = level.getSectionIndexFromSectionY((int)sectionTopY);
                if (sectionIndex >= 0 && sectionIndex < chunkSections.length) {
                    LevelChunkSection chunkSection;
                    PalettedContainer blockStateContainer = section.contains("block_states", 10) ? (PalettedContainer)ChunkSerializer.BLOCK_STATE_CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)section.getCompound("block_states")).promotePartial(stringx -> ChunkSerializer.logErrors((ChunkPos)chunkPos, (int)sectionTopY, (String)stringx)).getOrThrow(ChunkSerializer.ChunkReadException::new) : new PalettedContainer((IdMap)Block.BLOCK_STATE_REGISTRY, (Object)Blocks.AIR.defaultBlockState(), PalettedContainer.Strategy.SECTION_STATES);
                    Object biomeContainer = section.contains("biomes", 10) ? (PalettedContainerRO)codec.parse((DynamicOps)NbtOps.INSTANCE, (Object)section.getCompound("biomes")).promotePartial(stringx -> ChunkSerializer.logErrors((ChunkPos)chunkPos, (int)sectionTopY, (String)stringx)).getOrThrow(ChunkSerializer.ChunkReadException::new) : new PalettedContainer(registry.asHolderIdMap(), (Object)registry.getHolderOrThrow(Biomes.PLAINS), PalettedContainer.Strategy.SECTION_BIOMES);
                    chunkSections[sectionIndex] = chunkSection = new LevelChunkSection(blockStateContainer, (PalettedContainerRO)biomeContainer);
                }
                if (!lightOn || !section.contains("BlockLight", 7)) continue;
                SectionPos lightPos = SectionPos.of((ChunkPos)chunkPos, (int)sectionTopY);
                byte[] lightsArray = section.getByteArray("BlockLight");
                for (int z = 0; z <= 15; ++z) {
                    for (int x = 0; x <= 15; ++x) {
                        for (int y = lightPos.minBlockY(); y <= lightPos.maxBlockY(); ++y) {
                            if (lightsArray.length != 2048) continue;
                            int localY = SectionPos.sectionRelative((int)y);
                            lights[j][x][localY][z] = CustomChunkReader.getSectionLightValue(lightsArray, x, localY, z);
                        }
                    }
                }
            }
            LevelChunk chunkAccess = new LevelChunk((Level)level, chunkPos, null, null, null, 0L, chunkSections, null, null);
            chunkAccess.setLightCorrect(lightOn);
            CompoundTag heightmaps = chunkTag.getCompound("Heightmaps");
            EnumSet<Heightmap.Types> heightmapEnums = EnumSet.noneOf(Heightmap.Types.class);
            for (Heightmap.Types heightmapTypes : chunkAccess.getPersistedStatus().heightmapsAfter()) {
                String key = heightmapTypes.getSerializationKey();
                if (heightmaps.contains(key, 12)) {
                    chunkAccess.setHeightmap(heightmapTypes, heightmaps.getLongArray(key));
                    continue;
                }
                heightmapEnums.add(heightmapTypes);
            }
            Heightmap.primeHeightmaps((ChunkAccess)chunkAccess, heightmapEnums);
            return new ProcessedChunk(chunkAccess, lights);
        }
        return null;
    }

    private static byte getSectionLightValue(byte[] array, int x, int y, int z) {
        try {
            if (array != null) {
                int index = y << 8 | (z << 4) + x;
                int byteIndex = index >> 1;
                int nibbleIndex = index & 1;
                return (byte)(array[byteIndex] >> 4 * nibbleIndex & 0xF);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0;
    }

    public record ProcessedChunk(LevelChunk chunk, byte[][][][] light) {
    }
}

