/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.event.handlers;

import journeymap.api.v2.client.ui.component.LayeredScreen;
import journeymap.client.JourneymapClient;
import journeymap.client.log.JMLogger;
import journeymap.client.ui.UIManager;
import journeymap.client.ui.fullscreen.Fullscreen;
import journeymap.client.ui.minimap.MiniMap;
import journeymap.client.ui.option.ClientOptionsManager;
import journeymap.client.ui.option.MinimapOptions;
import journeymap.client.ui.option.OptionScreen;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.gui.screens.Screen;

public class ScreenEventHandler {
    boolean clicked = false;
    boolean didDrag = false;
    static ScreenEventHandler instance;

    private ScreenEventHandler() {
    }

    public static ScreenEventHandler getInstance() {
        if (instance == null) {
            instance = new ScreenEventHandler();
        }
        return instance;
    }

    public void onScreenPreRender(Screen screen, GuiGraphics graphics, int mouseX, int mouseY) {
        if (JourneymapClient.getInstance().enabled()) {
            try {
                boolean preview;
                boolean bl = preview = screen instanceof ClientOptionsManager && ((ClientOptionsManager)screen).previewMiniMap();
                if (this.allowableDrawScreens(screen) && JourneymapClient.getInstance().isMapping().booleanValue() && UIManager.INSTANCE.isMiniMapEnabled()) {
                    graphics.pose().pushPose();
                    MiniMap miniMap = UIManager.INSTANCE.getMiniMap();
                    miniMap.drawMap(graphics, true);
                    graphics.pose().popPose();
                } else if (!preview) {
                    this.clicked = false;
                }
            }
            catch (Throwable t) {
                JMLogger.throwLogOnce("Unexpected error during onScreenPreRender: " + String.valueOf(t), t);
            }
        }
    }

    public boolean onScreenMousePressedEvent(Screen screen, double mouseX, double mouseY, int button) {
        if (JourneymapClient.getInstance().enabled() && !this.clicked && this.allowableDragScreens(screen) && JourneymapClient.getInstance().isMapping().booleanValue()) {
            this.clicked = UIManager.INSTANCE.getMiniMap().mouseClicked(mouseX, mouseY, 0);
            return this.clicked;
        }
        return false;
    }

    public boolean onScreenMouseDraggedEvent(Screen screen, double mouseX, double mouseY, double dragX, double dragY, int mouseButton) {
        if (JourneymapClient.getInstance().enabled() && this.clicked && this.allowableDragScreens(screen) && JourneymapClient.getInstance().isMapping().booleanValue()) {
            this.didDrag = UIManager.INSTANCE.getMiniMap().mouseDragged(mouseX, mouseY, mouseButton, dragX, dragY);
            return this.didDrag;
        }
        return false;
    }

    public boolean onScreenMouseReleasedEvent(Screen screen, double mouseX, double mouseY, int button) {
        if (JourneymapClient.getInstance().enabled() && UIManager.INSTANCE.getMiniMap() != null && UIManager.INSTANCE.getMiniMap().mouseReleased(mouseX, mouseY, button)) {
            this.clicked = false;
            return true;
        }
        return false;
    }

    public void onScreenClosedEvent(Screen screen) {
        if (JourneymapClient.getInstance().enabled() && JourneymapClient.getInstance().isMapping().booleanValue() && UIManager.INSTANCE.getMiniMap() != null) {
            UIManager.INSTANCE.getMiniMap().mouseReleased(0.0, 0.0, 0);
            this.clicked = false;
            this.didDrag = false;
        }
    }

    private boolean allowableDragScreens(Screen screen) {
        return screen instanceof ClientOptionsManager;
    }

    private boolean allowableDrawScreens(Screen screen) {
        if (screen instanceof LayeredScreen) {
            LayeredScreen layeredScreen = (LayeredScreen)screen;
            return this.allowableDrawScreens(layeredScreen.getBackgroundScreen());
        }
        return !(screen instanceof Fullscreen) && !(screen instanceof MinimapOptions) && !(screen instanceof OptionScreen) && !(screen instanceof ChatScreen);
    }
}

