/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.compat.jei.arcfurnace;

import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.api.crafting.ArcFurnaceRecipe;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.register.IEMultiblockLogic;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.compat.jei.IERecipeCategory;
import blusunrize.immersiveengineering.common.util.compat.jei.JEIHelper;
import blusunrize.immersiveengineering.common.util.compat.jei.JEIRecipeTypes;
import java.util.Arrays;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;

public class ArcFurnaceRecipeCategory
extends IERecipeCategory<ArcFurnaceRecipe> {
    private final IDrawableStatic arrow;

    public ArcFurnaceRecipeCategory(IGuiHelper helper, RecipeType<RecipeHolder<ArcFurnaceRecipe>> type) {
        super(helper, type, "block.immersiveengineering.arc_furnace");
        this.setBackground(helper.createBlankDrawable(148, 54));
        this.setIcon(helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)IEMultiblockLogic.ARC_FURNACE.iconStack()));
        this.arrow = helper.drawableBuilder(JEIHelper.JEI_GUI, 19, 4, 24, 18).setTextureSize(128, 128).build();
    }

    public static ArcFurnaceRecipeCategory getDefault(IGuiHelper helper) {
        return new ArcFurnaceRecipeCategory(helper, JEIRecipeTypes.ARC_FURNACE);
    }

    public static ArcFurnaceRecipeCategory getRecycling(IGuiHelper helper) {
        ArcFurnaceRecipeCategory cat = new ArcFurnaceRecipeCategory(helper, JEIRecipeTypes.ARC_FURNACE_RECYCLING);
        cat.title.append(" - Recycling");
        cat.setIcon((IDrawable)helper.drawableBuilder(IEApi.ieLoc("textures/gui/recycle.png"), 0, 0, 16, 16).setTextureSize(16, 16).build());
        return cat;
    }

    @Override
    public void setRecipe(IRecipeLayoutBuilder builder, ArcFurnaceRecipe recipe, IFocusGroup focuses) {
        int x = (148 - this.getWidth(recipe)) / 2 + 1;
        builder.addSlot(RecipeIngredientRole.INPUT, x + 8, 1).addItemStacks(recipe.input.getMatchingStackList());
        for (int j = 0; j < recipe.additives.size(); ++j) {
            builder.addSlot(RecipeIngredientRole.INPUT, x + j % 2 * 18, 19 + j / 2 * 18).addItemStacks(recipe.additives.get(j).getMatchingStackList());
        }
        NonNullList<ItemStack> simulatedOutput = recipe.getBaseOutputs();
        int outputSize = simulatedOutput.size();
        for (int j = 0; j < outputSize; ++j) {
            builder.addSlot(RecipeIngredientRole.OUTPUT, x + 68 + j % 2 * 18, j / 2 * 18 + 1).addItemStack((ItemStack)simulatedOutput.get(j));
        }
        int xSecondary = x + (outputSize > 1 ? 106 : 88);
        for (int j = 0; j < recipe.secondaryOutputs.size(); ++j) {
            builder.addSlot(RecipeIngredientRole.OUTPUT, xSecondary, j * 18 + 1).addItemStack(recipe.secondaryOutputs.get(j).stack().get());
        }
        if (!recipe.slag.get().isEmpty()) {
            builder.addSlot(RecipeIngredientRole.OUTPUT, x + 68, 37).addItemStack(recipe.slag.get());
        }
    }

    private int getWidth(ArcFurnaceRecipe recipe) {
        int w = 86;
        if (recipe.getBaseOutputs().size() > 1) {
            w += 18;
        }
        if (recipe.secondaryOutputs.size() > 0) {
            w += 40;
        }
        return w;
    }

    @Override
    public void draw(ArcFurnaceRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics graphics, double mouseX, double mouseY) {
        int j;
        int x = (148 - this.getWidth(recipe)) / 2;
        this.arrow.draw(graphics, x + 40, 10);
        JEIHelper.slotDrawable.draw(graphics, x + 8, 0);
        for (j = 0; j < 4; ++j) {
            JEIHelper.slotDrawable.draw(graphics, x + j % 2 * 18, 18 + j / 2 * 18);
        }
        for (j = 0; j < recipe.getBaseOutputs().size(); ++j) {
            JEIHelper.slotDrawable.draw(graphics, x + 68 + j % 2 * 18, j / 2 * 18);
        }
        int xSecondary = x + (recipe.getBaseOutputs().size() > 1 ? 106 : 88);
        for (int j2 = 0; j2 < recipe.secondaryOutputs.size(); ++j2) {
            JEIHelper.slotDrawable.draw(graphics, xSecondary, j2 * 18);
            graphics.drawString(ClientUtils.font(), Utils.formatDouble(recipe.secondaryOutputs.get(j2).chance() * 100.0f, "0.##") + "%", xSecondary + 20, j2 * 18 + 6, 0x777777, false);
        }
        JEIHelper.slotDrawable.draw(graphics, x + 68, 36);
    }

    public List<Component> getTooltipStrings(RecipeHolder<ArcFurnaceRecipe> holder, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        ArcFurnaceRecipe recipe = (ArcFurnaceRecipe)holder.value();
        int x = (148 - this.getWidth(recipe)) / 2;
        if (mouseX >= (double)(x + 40) && mouseX <= (double)(x + 64) && mouseY >= 8.0 && mouseY <= 26.0) {
            float time = recipe.getTotalProcessTime();
            float energy = (float)recipe.getTotalProcessEnergy() / time;
            Utils.formatDouble(energy, "#.##");
            return Arrays.asList(Component.translatable((String)"desc.immersiveengineering.info.ift", (Object[])new Object[]{Utils.formatDouble(energy, "#.##")}), Component.translatable((String)"desc.immersiveengineering.info.seconds", (Object[])new Object[]{Utils.formatDouble(time / 20.0f, "#.##")}));
        }
        return super.getTooltipStrings(holder, recipeSlotsView, mouseX, mouseY);
    }
}

