/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.register;

import blusunrize.immersiveengineering.api.EnumMetals;
import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.api.IETags;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredRegister;

public class IEArmorMaterials {
    private static final DeferredRegister<ArmorMaterial> REGISTER = DeferredRegister.create((ResourceKey)Registries.ARMOR_MATERIAL, (String)"immersiveengineering");
    public static final Holder<ArmorMaterial> FARADAY = REGISTER.register("faraday", () -> new ArmorMaterial(Map.of(ArmorItem.Type.BOOTS, 1, ArmorItem.Type.HELMET, 1, ArmorItem.Type.LEGGINGS, 2, ArmorItem.Type.CHESTPLATE, 3), 0, SoundEvents.ARMOR_EQUIP_CHAIN, () -> Ingredient.of(IETags.getTagsFor((EnumMetals)EnumMetals.ALUMINUM).plate), List.of(new ArmorMaterial.Layer(IEApi.ieLoc("faraday"))), 0.0f, 0.0f));
    public static final Holder<ArmorMaterial> STEEL = REGISTER.register("steel", () -> new ArmorMaterial(Map.of(ArmorItem.Type.BOOTS, 273, ArmorItem.Type.LEGGINGS, 315, ArmorItem.Type.CHESTPLATE, 336, ArmorItem.Type.HELMET, 231), 10, SoundEvents.ARMOR_EQUIP_IRON, () -> Ingredient.of(IETags.getTagsFor((EnumMetals)EnumMetals.STEEL).ingot), List.of(new ArmorMaterial.Layer(IEApi.ieLoc("steel"))), 0.0f, 0.0f));

    public static void init(IEventBus modBus) {
        REGISTER.register(modBus);
    }

    public static Item.Properties getProperties(Holder<ArmorMaterial> material, ArmorItem.Type type) {
        return new Item.Properties().durability(IEArmorMaterials.getDurability(material, type));
    }

    public static int getDurability(Holder<ArmorMaterial> material, ArmorItem.Type type) {
        if (material.value() == STEEL.value()) {
            return switch (type) {
                default -> throw new MatchException(null, null);
                case ArmorItem.Type.BOOTS -> 273;
                case ArmorItem.Type.LEGGINGS -> 315;
                case ArmorItem.Type.CHESTPLATE -> 336;
                case ArmorItem.Type.HELMET -> 231;
                case ArmorItem.Type.BODY -> throw new UnsupportedOperationException("Steel body armor not implemented");
            };
        }
        if (material.value() == FARADAY.value()) {
            return switch (type) {
                default -> throw new MatchException(null, null);
                case ArmorItem.Type.BOOTS -> 13;
                case ArmorItem.Type.LEGGINGS -> 15;
                case ArmorItem.Type.CHESTPLATE -> 16;
                case ArmorItem.Type.HELMET -> 11;
                case ArmorItem.Type.BODY -> throw new UnsupportedOperationException("Faraday body armor not implemented");
            };
        }
        throw new UnsupportedOperationException("Unknown material " + material.getRegisteredName());
    }
}

