/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.network;

import blusunrize.immersiveengineering.api.tool.upgrade.PrevSlot;
import blusunrize.immersiveengineering.api.tool.upgrade.UpgradeData;
import blusunrize.immersiveengineering.api.tool.upgrade.UpgradeEffect;
import blusunrize.immersiveengineering.common.items.IEShieldItem;
import blusunrize.immersiveengineering.common.items.UpgradeableToolItem;
import blusunrize.immersiveengineering.common.network.IMessage;
import blusunrize.immersiveengineering.common.register.IEDataComponents;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record MessageMagnetEquip(int fetchSlot) implements IMessage
{
    public static final CustomPacketPayload.Type<MessageMagnetEquip> ID = IMessage.createType("magnet_equip");
    public static final StreamCodec<ByteBuf, MessageMagnetEquip> CODEC = ByteBufCodecs.INT.map(MessageMagnetEquip::new, MessageMagnetEquip::fetchSlot);

    @Override
    public void process(IPayloadContext context) {
        Player player = context.player();
        context.enqueueWork(() -> {
            ItemStack held = player.getItemInHand(InteractionHand.OFF_HAND);
            UpgradeData upgrades = UpgradeableToolItem.getUpgradesStatic(held);
            if (this.fetchSlot >= 0) {
                ItemStack s = (ItemStack)player.getInventory().items.get(this.fetchSlot);
                if (s.getItem() instanceof IEShieldItem && upgrades.has(UpgradeEffect.MAGNET)) {
                    UpgradeData withSlot = upgrades.with(UpgradeEffect.MAGNET, new PrevSlot(this.fetchSlot));
                    s.set(IEDataComponents.UPGRADE_DATA, (Object)withSlot);
                    player.getInventory().items.set(this.fetchSlot, (Object)held);
                    player.setItemInHand(InteractionHand.OFF_HAND, s);
                }
            } else {
                Optional<Integer> prevSlot = upgrades.get(UpgradeEffect.MAGNET).prevSlot();
                if (held.getItem() instanceof IEShieldItem && ((IEShieldItem)held.getItem()).getUpgrades(held).has(UpgradeEffect.MAGNET) && prevSlot.isPresent()) {
                    UpgradeData withSlot = upgrades.with(UpgradeEffect.MAGNET, PrevSlot.NONE);
                    held.set(IEDataComponents.UPGRADE_DATA, (Object)withSlot);
                    ItemStack s = (ItemStack)player.getInventory().items.get(prevSlot.get().intValue());
                    player.getInventory().items.set(prevSlot.get().intValue(), (Object)held);
                    player.setItemInHand(InteractionHand.OFF_HAND, s);
                }
            }
        });
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }
}

