/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.api.IEApiDataComponents;
import blusunrize.immersiveengineering.api.TargetingInfo;
import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import blusunrize.immersiveengineering.api.wires.GlobalWireNetwork;
import blusunrize.immersiveengineering.api.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.wires.LocalWireNetwork;
import blusunrize.immersiveengineering.api.wires.localhandlers.EnergyTransferHandler;
import blusunrize.immersiveengineering.api.wires.utils.WireLink;
import blusunrize.immersiveengineering.common.items.IEBaseItem;
import blusunrize.immersiveengineering.common.network.MessageRequestRedstoneUpdate;
import blusunrize.immersiveengineering.common.util.ChatUtils;
import blusunrize.immersiveengineering.common.util.Utils;
import com.mojang.datafixers.util.Either;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;

public class VoltmeterItem
extends IEBaseItem {
    public static RemoteEnergyData lastEnergyUpdate = new RemoteEnergyData((Either<BlockPos, Integer>)Either.left((Object)BlockPos.ZERO), 0L, false, 0, 0);
    public static RemoteRedstoneData lastRedstoneUpdate = new RemoteRedstoneData(BlockPos.ZERO, 0L, false, 0);

    public VoltmeterItem() {
        super(new Item.Properties().stacksTo(1));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext ctx, List<Component> tooltip, TooltipFlag flagIn) {
        super.appendHoverText(stack, ctx, tooltip, flagIn);
        WireLink link = (WireLink)stack.get(IEApiDataComponents.WIRE_LINK);
        if (link != null) {
            tooltip.add((Component)Component.translatable((String)"desc.immersiveengineering.info.attachedToDim", (Object[])new Object[]{link.cp().getX(), link.cp().getY(), link.cp().getZ(), link.dimension().toString()}));
        }
    }

    public InteractionResult useOn(UseOnContext context) {
        IEnergyStorage energyCap;
        Level world = context.getLevel();
        BlockPos pos = context.getClickedPos();
        Player player = context.getPlayer();
        ItemStack stack = context.getItemInHand();
        BlockEntity bEntity = world.getBlockEntity(pos);
        if (!(player != null && player.isShiftKeyDown() || (energyCap = (IEnergyStorage)world.getCapability(Capabilities.EnergyStorage.BLOCK, pos, null)) == null)) {
            int max = energyCap.getMaxEnergyStored();
            int stored = energyCap.getEnergyStored();
            if (max > 0) {
                ChatUtils.sendServerNoSpamMessages(player, (Component)Component.translatable((String)"chat.immersiveengineering.info.energyStorage", (Object[])new Object[]{stored, max}));
            }
            return InteractionResult.SUCCESS;
        }
        if (player != null && player.isShiftKeyDown()) {
            if (bEntity instanceof IImmersiveConnectable) {
                if (world.isClientSide) {
                    return InteractionResult.SUCCESS;
                }
                TargetingInfo targetingInfo = new TargetingInfo(context);
                BlockPos masterPos = ((IImmersiveConnectable)bEntity).getConnectionMaster(null, targetingInfo);
                BlockPos delta = pos.subtract((Vec3i)masterPos);
                ConnectionPoint cp = ((IImmersiveConnectable)bEntity).getTargetedPoint(targetingInfo, (Vec3i)delta);
                if (cp == null) {
                    return InteractionResult.FAIL;
                }
                if (!stack.has(IEApiDataComponents.WIRE_LINK)) {
                    stack.set(IEApiDataComponents.WIRE_LINK, (Object)WireLink.create(cp, world, delta, targetingInfo));
                } else {
                    EnergyTransferHandler energyHandler;
                    LocalWireNetwork netLink;
                    GlobalWireNetwork global;
                    LocalWireNetwork netHere;
                    WireLink link = (WireLink)stack.remove(IEApiDataComponents.WIRE_LINK);
                    if (link.dimension().equals((Object)world.dimension()) && (netHere = (global = GlobalWireNetwork.getNetwork(world)).getNullableLocalNet(cp)) == (netLink = global.getNullableLocalNet(link.cp())) && netHere != null && (energyHandler = netHere.getHandler(EnergyTransferHandler.ID, EnergyTransferHandler.class)) != null) {
                        EnergyTransferHandler.Path energyPath = energyHandler.getPath(link.cp(), cp);
                        double loss = energyPath != null ? energyPath.loss : 1.0;
                        player.sendSystemMessage((Component)Component.translatable((String)"chat.immersiveengineering.info.averageLoss", (Object[])new Object[]{Utils.formatDouble(loss * 100.0, "###.000")}));
                    }
                }
                return InteractionResult.SUCCESS;
            }
            if (!world.isClientSide) {
                ChatUtils.sendServerNoSpamMessages(player, (Component)Component.translatable((String)"chat.immersiveengineering.info.redstoneLevel", (Object[])new Object[]{MessageRequestRedstoneUpdate.redstoneLevel(world, pos)}));
            }
        }
        return InteractionResult.PASS;
    }

    public record RemoteEnergyData(Either<BlockPos, Integer> pos, long measuredInTick, boolean isValid, int stored, int capacity) {
        public static final StreamCodec<ByteBuf, RemoteEnergyData> CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.either((StreamCodec)BlockPos.STREAM_CODEC, (StreamCodec)ByteBufCodecs.INT), RemoteEnergyData::pos, (StreamCodec)ByteBufCodecs.VAR_LONG, RemoteEnergyData::measuredInTick, (StreamCodec)ByteBufCodecs.BOOL, RemoteEnergyData::isValid, (StreamCodec)ByteBufCodecs.INT, RemoteEnergyData::stored, (StreamCodec)ByteBufCodecs.INT, RemoteEnergyData::capacity, RemoteEnergyData::new);
    }

    public record RemoteRedstoneData(BlockPos pos, long measuredInTick, boolean isSignalSource, byte rsLevel) {
        public static final StreamCodec<ByteBuf, RemoteRedstoneData> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, RemoteRedstoneData::pos, (StreamCodec)ByteBufCodecs.VAR_LONG, RemoteRedstoneData::measuredInTick, (StreamCodec)ByteBufCodecs.BOOL, RemoteRedstoneData::isSignalSource, (StreamCodec)ByteBufCodecs.BYTE, RemoteRedstoneData::rsLevel, RemoteRedstoneData::new);
    }
}

