/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.api.client.TextUtils;
import blusunrize.immersiveengineering.api.shader.CapabilityShader;
import blusunrize.immersiveengineering.api.tool.ChemthrowerHandler;
import blusunrize.immersiveengineering.api.tool.upgrade.UpgradeEffect;
import blusunrize.immersiveengineering.api.utils.codec.IEDualCodecs;
import blusunrize.immersiveengineering.common.config.IEServerConfig;
import blusunrize.immersiveengineering.common.entities.ChemthrowerShotEntity;
import blusunrize.immersiveengineering.common.fluids.IEItemFluidHandler;
import blusunrize.immersiveengineering.common.gui.IESlot;
import blusunrize.immersiveengineering.common.items.IEItemInterfaces;
import blusunrize.immersiveengineering.common.items.ItemCapabilityRegistration;
import blusunrize.immersiveengineering.common.items.UpgradeableToolItem;
import blusunrize.immersiveengineering.common.register.IEDataComponents;
import blusunrize.immersiveengineering.common.util.IESounds;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import malte0811.dualcodecs.DualCodec;
import malte0811.dualcodecs.DualCodecs;
import malte0811.dualcodecs.DualCompositeCodecs;
import malte0811.dualcodecs.DualMapCodec;
import net.minecraft.ChatFormatting;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.items.IItemHandler;

public class ChemthrowerItem
extends UpgradeableToolItem
implements IEItemInterfaces.IAdvancedFluidItem,
IEItemInterfaces.IScrollwheel {
    public static final String TYPE = "CHEMTHROWER";
    private static final int CAPACITY = 2000;

    public ChemthrowerItem() {
        super(new Item.Properties().stacksTo(1).component(IEDataComponents.CHEMTHROWER_DATA, (Object)ChemthrowerData.DEFAULT), TYPE, 4);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext ctx, List<Component> list, TooltipFlag flag) {
        int cap = this.getCapacity(stack, 2000);
        int numberOfTanks = this.getUpgrades(stack).has(UpgradeEffect.MULTITANK) ? 3 : 1;
        for (int i = 0; i < numberOfTanks; ++i) {
            Component add = IEItemFluidHandler.fluidItemInfoFlavor(ChemthrowerItem.getData(stack).getFluid(i), cap);
            if (i > 0) {
                TextUtils.applyFormat(add, ChatFormatting.GRAY);
            }
            list.add(add);
        }
    }

    @Nonnull
    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.NONE;
    }

    @Override
    public void removeFromWorkbench(Player player, ItemStack stack) {
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (player.isShiftKeyDown()) {
            if (!world.isClientSide) {
                ChemthrowerItem.setIgniteEnable(stack, !ChemthrowerItem.isIgniteEnable(stack));
            }
        } else {
            player.startUsingItem(hand);
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    public void onUseTick(Level level, LivingEntity player, ItemStack stack, int remainingUseDuration) {
        FluidStack fs = this.getFluid(stack);
        if (!fs.isEmpty()) {
            int duration = this.getUseDuration(stack, player) - remainingUseDuration;
            int consumed = (Integer)IEServerConfig.TOOLS.chemthrower_consumption.get();
            if (consumed * duration <= fs.getAmount()) {
                float range;
                Vec3 v = player.getLookAngle();
                int split = 8;
                boolean isGas = fs.getFluid().is(Tags.Fluids.GASEOUS);
                float scatter = isGas ? 0.25f : 0.15f;
                float f = range = isGas ? 0.5f : 1.0f;
                if (this.getUpgrades(stack).has(UpgradeEffect.FOCUS)) {
                    range += 0.25f;
                    scatter = 0.025f;
                }
                boolean ignite = ChemthrowerHandler.isFlammable(fs.getFluid()) && ChemthrowerItem.isIgniteEnable(stack);
                for (int i = 0; i < split; ++i) {
                    Vec3 vecDir = v.add(player.getRandom().nextGaussian() * (double)scatter, player.getRandom().nextGaussian() * (double)scatter, player.getRandom().nextGaussian() * (double)scatter);
                    ChemthrowerShotEntity chem = new ChemthrowerShotEntity(player.level(), player, vecDir.x * 0.25, vecDir.y * 0.25, vecDir.z * 0.25, fs);
                    chem.setDeltaMovement(player.getDeltaMovement().add(vecDir.scale((double)range)));
                    if (!player.onGround()) {
                        player.setDeltaMovement(player.getDeltaMovement().subtract(vecDir.scale(0.0025 * (double)range)));
                    }
                    if (ignite) {
                        chem.igniteForSeconds(10.0f);
                    }
                    if (player.level().isClientSide) continue;
                    player.level().addFreshEntity((Entity)chem);
                }
                if (remainingUseDuration % 4 == 0) {
                    if (ignite) {
                        player.level().playSound(null, player.getX(), player.getY(), player.getZ(), (SoundEvent)IESounds.sprayFire.value(), SoundSource.PLAYERS, 0.5f, 1.5f);
                    } else {
                        player.level().playSound(null, player.getX(), player.getY(), player.getZ(), (SoundEvent)IESounds.spray.value(), SoundSource.PLAYERS, 0.5f, 0.75f);
                    }
                }
            } else {
                player.releaseUsingItem();
            }
        } else {
            player.releaseUsingItem();
        }
    }

    public void releaseUsing(ItemStack stack, Level world, LivingEntity player, int timeLeft) {
        ChemthrowerData data = ChemthrowerItem.getData(stack);
        FluidStack fs = data.mainFluid.copy();
        if (fs.isEmpty()) {
            return;
        }
        int duration = this.getUseDuration(stack, player) - timeLeft;
        fs.shrink((Integer)IEServerConfig.TOOLS.chemthrower_consumption.get() * duration);
        stack.set(IEDataComponents.CHEMTHROWER_DATA, (Object)new ChemthrowerData(data.ignite, fs, data.fluid1, data.fluid2));
    }

    public int getUseDuration(ItemStack p_41454_, LivingEntity p_344979_) {
        return 72000;
    }

    @Override
    public void onScrollwheel(ItemStack stack, Player playerEntity, boolean forward) {
        if (this.getUpgrades(stack).has(UpgradeEffect.MULTITANK)) {
            ChemthrowerData oldData = ChemthrowerItem.getData(stack);
            if (forward) {
                stack.set(IEDataComponents.CHEMTHROWER_DATA, (Object)new ChemthrowerData(oldData.ignite, oldData.fluid2, oldData.mainFluid, oldData.fluid1));
            } else {
                stack.set(IEDataComponents.CHEMTHROWER_DATA, (Object)new ChemthrowerData(oldData.ignite, oldData.fluid1, oldData.fluid2, oldData.mainFluid));
            }
        }
    }

    @Override
    public void finishUpgradeRecalculation(ItemStack stack, RegistryAccess registries) {
        ChemthrowerData data = ChemthrowerItem.getData(stack);
        FluidStack fs = data.mainFluid.copy();
        int capacity = this.getCapacity(stack, 2000);
        if (fs.getAmount() > capacity) {
            stack.set(IEDataComponents.CHEMTHROWER_DATA, (Object)new ChemthrowerData(data.ignite, fs.copyWithAmount(capacity), data.fluid1, data.fluid2));
        }
    }

    @Override
    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        if (slotChanged || CapabilityShader.shouldReequipDueToShader(oldStack, newStack)) {
            return true;
        }
        return super.shouldCauseReequipAnimation(oldStack, newStack, slotChanged);
    }

    public static void registerCapabilities(ItemCapabilityRegistration.ItemCapabilityRegistrar registrar) {
        ChemthrowerItem.registerCapabilitiesISI(registrar);
        registrar.register(Capabilities.FluidHandler.ITEM, stack -> new IEItemFluidHandler((ItemStack)stack, 2000));
        registrar.register(CapabilityShader.ITEM, stack -> new CapabilityShader.ShaderWrapper_Item(IEApi.ieLoc("chemthrower"), (ItemStack)stack));
    }

    @Override
    public int getCapacity(ItemStack stack, int baseCapacity) {
        return baseCapacity + this.getUpgrades(stack).get(UpgradeEffect.CAPACITY);
    }

    @Override
    public boolean canModify(ItemStack stack) {
        return true;
    }

    @Override
    public Slot[] getWorkbenchSlots(AbstractContainerMenu container, ItemStack stack, Level level, Supplier<Player> getPlayer, IItemHandler toolInventory) {
        return new Slot[]{new IESlot.Upgrades(container, toolInventory, 0, 80, 32, TYPE, stack, true, level, getPlayer), new IESlot.Upgrades(container, toolInventory, 1, 100, 32, TYPE, stack, true, level, getPlayer)};
    }

    public static void setIgniteEnable(ItemStack chemthrower, boolean enabled) {
        ChemthrowerData data = ChemthrowerItem.getData(chemthrower);
        chemthrower.set(IEDataComponents.CHEMTHROWER_DATA, (Object)new ChemthrowerData(enabled, data.mainFluid, data.fluid1, data.fluid2));
    }

    public static boolean isIgniteEnable(ItemStack chemthrower) {
        return ChemthrowerItem.getData((ItemStack)chemthrower).ignite;
    }

    @Override
    public FluidStack getFluid(ItemStack container) {
        return ChemthrowerItem.getData((ItemStack)container).mainFluid;
    }

    private static ChemthrowerData getData(ItemStack chemthrower) {
        return (ChemthrowerData)chemthrower.getOrDefault(IEDataComponents.CHEMTHROWER_DATA, (Object)ChemthrowerData.DEFAULT);
    }

    public record ChemthrowerData(boolean ignite, FluidStack mainFluid, FluidStack fluid1, FluidStack fluid2) {
        public static final DualCodec<RegistryFriendlyByteBuf, ChemthrowerData> CODECS = DualCompositeCodecs.composite((DualMapCodec)DualCodecs.BOOL.fieldOf("ignite"), ChemthrowerData::ignite, (DualMapCodec)IEDualCodecs.FLUID_STACK.fieldOf("mainFluid"), ChemthrowerData::mainFluid, (DualMapCodec)IEDualCodecs.FLUID_STACK.fieldOf("fluid1"), ChemthrowerData::fluid1, (DualMapCodec)IEDualCodecs.FLUID_STACK.fieldOf("fluid2"), ChemthrowerData::fluid2, ChemthrowerData::new);
        public static final ChemthrowerData DEFAULT = new ChemthrowerData(false, FluidStack.EMPTY, FluidStack.EMPTY, FluidStack.EMPTY);

        public ChemthrowerData {
            mainFluid = mainFluid.copy();
            fluid1 = fluid1.copy();
            fluid2 = fluid2.copy();
        }

        public FluidStack getFluid(int i) {
            return switch (i) {
                case 0 -> this.mainFluid;
                case 1 -> this.fluid1;
                case 2 -> this.fluid2;
                default -> throw new IllegalStateException("Unexpected value: " + i);
            };
        }
    }
}

