/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.api.IETags;
import blusunrize.immersiveengineering.api.tool.ChemthrowerHandler;
import blusunrize.immersiveengineering.common.entities.ChemthrowerShotEntity;
import blusunrize.immersiveengineering.common.register.IEBlocks;
import blusunrize.immersiveengineering.common.register.IEPotions;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.SnowyDirtBlock;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.fluids.FluidStack;

public class ChemthrowerEffects {
    public static void register() {
        ChemthrowerHandler.registerEffect((TagKey<Fluid>)FluidTags.WATER, new ChemthrowerHandler.ChemthrowerEffect_Extinguish());
        ChemthrowerHandler.registerEffect(IETags.fluidPotion, new ChemthrowerHandler.ChemthrowerEffect(){

            @Override
            public void applyToEntity(LivingEntity target, @Nullable Player shooter, ItemStack thrower, FluidStack fluid) {
                if (fluid.has(DataComponents.POTION_CONTENTS)) {
                    PotionContents potionContents = (PotionContents)fluid.get(DataComponents.POTION_CONTENTS);
                    for (MobEffectInstance e : potionContents.getAllEffects()) {
                        MobEffectInstance newEffect = new MobEffectInstance(e.getEffect(), (int)Math.ceil((double)e.getDuration() * 0.05), e.getAmplifier());
                        target.addEffect(newEffect);
                    }
                }
            }

            @Override
            public void applyToEntity(LivingEntity target, @Nullable Player shooter, ItemStack thrower, Fluid fluid) {
            }

            @Override
            public void applyToBlock(Level world, HitResult mop, @Nullable Player shooter, ItemStack thrower, FluidStack fluid) {
            }

            @Override
            public void applyToBlock(Level world, HitResult mop, @Nullable Player shooter, ItemStack thrower, Fluid fluid) {
            }
        });
        ChemthrowerHandler.registerEffect(IETags.fluidConcrete, new ChemthrowerHandler.ChemthrowerEffect(){

            @Override
            public void applyToEntity(LivingEntity target, @Nullable Player shooter, ItemStack thrower, FluidStack fluid) {
                this.hit(target.level(), target.blockPosition(), Direction.UP);
            }

            @Override
            public void applyToEntity(LivingEntity target, @Nullable Player shooter, ItemStack thrower, Fluid fluid) {
            }

            @Override
            public void applyToBlock(Level world, HitResult mop, @Nullable Player shooter, ItemStack thrower, FluidStack fluid) {
                if (!(mop instanceof BlockHitResult)) {
                    return;
                }
                BlockHitResult brtr = (BlockHitResult)mop;
                BlockState hit = world.getBlockState(brtr.getBlockPos());
                if (hit.getBlock() != IEBlocks.StoneDecoration.CONCRETE_SPRAYED.get()) {
                    BlockPos pos = brtr.getBlockPos().relative(brtr.getDirection());
                    if (!world.isEmptyBlock(pos)) {
                        return;
                    }
                    AABB aabb = new AABB(pos);
                    List otherProjectiles = world.getEntitiesOfClass(ChemthrowerShotEntity.class, aabb);
                    if (otherProjectiles.size() >= 8) {
                        this.hit(world, pos, brtr.getDirection());
                    }
                }
            }

            @Override
            public void applyToBlock(Level world, HitResult mop, @Nullable Player shooter, ItemStack thrower, Fluid fluid) {
            }

            private void hit(Level world, BlockPos pos, Direction side) {
                AABB aabb = new AABB(pos);
                List otherProjectiles = world.getEntitiesOfClass(ChemthrowerShotEntity.class, aabb);
                for (ChemthrowerShotEntity shot : otherProjectiles) {
                    shot.discard();
                }
                world.setBlockAndUpdate(pos, IEBlocks.StoneDecoration.CONCRETE_SPRAYED.defaultBlockState());
                for (LivingEntity living : world.getEntitiesOfClass(LivingEntity.class, aabb)) {
                    living.addEffect(new MobEffectInstance(IEPotions.CONCRETE_FEET, Integer.MAX_VALUE));
                }
            }
        });
        ChemthrowerHandler.registerEffect(IETags.fluidHerbicide, new ChemthrowerHandler.ChemthrowerEffect(){

            @Override
            public void applyToEntity(LivingEntity target, @Nullable Player shooter, ItemStack thrower, Fluid fluid) {
            }

            @Override
            public void applyToBlock(Level world, HitResult mop, @Nullable Player shooter, ItemStack thrower, Fluid fluid) {
                if (!(mop instanceof BlockHitResult)) {
                    return;
                }
                BlockHitResult brtr = (BlockHitResult)mop;
                BlockState hit = world.getBlockState(brtr.getBlockPos());
                if (hit.is(BlockTags.LEAVES)) {
                    world.removeBlock(brtr.getBlockPos(), false);
                } else if (hit.getBlock() instanceof SnowyDirtBlock || hit.getBlock() instanceof FarmBlock) {
                    world.setBlockAndUpdate(brtr.getBlockPos(), Blocks.DIRT.defaultBlockState());
                    BlockPos above = brtr.getBlockPos().above();
                    if (world.getBlockState(above).getBlock() instanceof BushBlock) {
                        world.removeBlock(above, false);
                    }
                }
                AABB aabb = new AABB(brtr.getBlockPos()).inflate(0.25);
                List otherProjectiles = world.getEntitiesOfClass(ChemthrowerShotEntity.class, aabb);
                for (ChemthrowerShotEntity shot : otherProjectiles) {
                    shot.discard();
                }
            }
        });
        ChemthrowerHandler.registerEffect(IETags.fluidCreosote, new ChemthrowerHandler.ChemthrowerEffect_Potion(null, 0.0f, IEPotions.FLAMMABLE, 140, 0));
        ChemthrowerHandler.registerFlammable(IETags.fluidCreosote);
        ChemthrowerHandler.registerEffect(IETags.fluidBiodiesel, new ChemthrowerHandler.ChemthrowerEffect_Potion(null, 0.0f, IEPotions.FLAMMABLE, 140, 1));
        ChemthrowerHandler.registerFlammable(IETags.fluidBiodiesel);
        ChemthrowerHandler.registerFlammable(IETags.fluidEthanol);
        ChemthrowerHandler.registerFlammable(IETags.fluidAcetaldehyde);
        ChemthrowerHandler.registerEffect(IETags.fluidResin, new ChemthrowerHandler.ChemthrowerEffect_Potion(null, 0.0f, IEPotions.STICKY, 140, 1));
        ChemthrowerHandler.registerEffect(IETags.fluidRedstoneAcid, new ChemthrowerHandler.ChemthrowerEffect_Potion(null, 0.0f, (Holder)IEPotions.CONDUCTIVE, 140, 1){

            @Override
            public void applyToBlock(Level world, HitResult mop, @Nullable Player shooter, ItemStack thrower, Fluid fluid) {
                BlockHitResult blockHit;
                block5: {
                    block4: {
                        if (!(mop instanceof BlockHitResult)) break block4;
                        blockHit = (BlockHitResult)mop;
                        if (world instanceof ServerLevel) break block5;
                    }
                    return;
                }
                ServerLevel serverLevel = (ServerLevel)world;
                BlockState hit = world.getBlockState(blockHit.getBlockPos());
                Block block = hit.getBlock();
                if (block instanceof WeatheringCopper) {
                    WeatheringCopper copperBlock = (WeatheringCopper)block;
                    copperBlock.changeOverTime(hit, serverLevel, blockHit.getBlockPos(), world.random);
                }
            }
        });
    }
}

