/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.gui;

import blusunrize.immersiveengineering.api.utils.DirectionUtils;
import blusunrize.immersiveengineering.common.blocks.wooden.FluidSorterBlockEntity;
import blusunrize.immersiveengineering.common.gui.IEContainerMenu;
import blusunrize.immersiveengineering.common.gui.sync.GenericContainerData;
import blusunrize.immersiveengineering.common.gui.sync.GenericDataSerializers;
import blusunrize.immersiveengineering.common.gui.sync.GetterAndSetter;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.fluids.FluidStack;

public class FluidSorterMenu
extends IEContainerMenu {
    public final GetterAndSetter<byte[]> sortWithNBT;
    public final List<List<GetterAndSetter<FluidStack>>> filters;

    public static FluidSorterMenu makeServer(MenuType<?> type, int id, Inventory invPlayer, FluidSorterBlockEntity be) {
        return new FluidSorterMenu(FluidSorterMenu.blockCtx(type, id, be), invPlayer, GetterAndSetter.getterOnly(() -> be.sortWithNBT), be.filters);
    }

    public static FluidSorterMenu makeClient(MenuType<?> type, int id, Inventory invPlayer) {
        return new FluidSorterMenu(FluidSorterMenu.clientCtx(type, id), invPlayer, GetterAndSetter.standalone(new byte[DirectionUtils.VALUES.length]), FluidSorterBlockEntity.makeFilterArray());
    }

    private FluidSorterMenu(IEContainerMenu.MenuContext ctx, Inventory inventoryPlayer, GetterAndSetter<byte[]> sortWithNBT, FluidStack[][] filters) {
        super(ctx);
        int i;
        this.sortWithNBT = sortWithNBT;
        this.filters = Arrays.stream(filters).map(GetterAndSetter::forArray).toList();
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)inventoryPlayer, j + i * 9 + 9, 8 + j * 18, 163 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)inventoryPlayer, i, 8 + i * 18, 221));
        }
        for (List<GetterAndSetter<FluidStack>> sideFilter : this.filters) {
            for (GetterAndSetter<FluidStack> filter : sideFilter) {
                this.addGenericData(new GenericContainerData<FluidStack>(GenericDataSerializers.FLUID_STACK, filter));
            }
        }
        this.addGenericData(new GenericContainerData<byte[]>(GenericDataSerializers.BYTE_ARRAY, sortWithNBT));
    }

    @Override
    public void receiveMessageFromScreen(CompoundTag message) {
        if (message.contains("useNBT", 3)) {
            byte config = message.getByte("useNBT");
            int side = message.getInt("side");
            this.sortWithNBT.get()[side] = config;
        }
        if (message.contains("filter_side", 3)) {
            int side = message.getInt("filter_side");
            int slot = message.getInt("filter_slot");
            FluidStack newFilter = FluidStack.parseOptional((HolderLookup.Provider)Minecraft.getInstance().level.registryAccess(), (CompoundTag)message.getCompound("filter"));
            if (!newFilter.isEmpty()) {
                newFilter.setAmount(1);
            }
            this.filters.get(side).get(slot).set(newFilter);
        }
    }

    @Override
    @Nonnull
    public ItemStack quickMoveStack(Player player, int slot) {
        return ItemStack.EMPTY;
    }

    public FluidStack getFilter(int side, int slot) {
        return this.filters.get(side).get(slot).get();
    }
}

