/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.wooden;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.energy.IRotationAcceptor;
import blusunrize.immersiveengineering.api.utils.SafeChunkUtils;
import blusunrize.immersiveengineering.common.blocks.IEBaseBlockEntity;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.PlacementLimitation;
import blusunrize.immersiveengineering.common.blocks.ticking.IEClientTickableBE;
import blusunrize.immersiveengineering.common.blocks.ticking.IEServerTickableBE;
import blusunrize.immersiveengineering.common.util.IEBlockCapabilityCaches;
import blusunrize.immersiveengineering.common.util.IESounds;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public class WatermillBlockEntity
extends IEBaseBlockEntity
implements IEServerTickableBE,
IEClientTickableBE,
IEBlockInterfaces.IStateBasedDirectional,
IEBlockInterfaces.IHasDummyBlocks,
IEBlockInterfaces.ISoundBE {
    public int[] offset = new int[]{0, 0};
    private double rotation = 0.0;
    private double speed = 0.0;
    private double powerOut = 0.0;
    private long deferredUpdateTick = 0L;
    private boolean beingBroken = false;
    private IEBlockCapabilityCaches.IEBlockCapabilityCache<IRotationAcceptor> dynamo = null;
    private static final List<Vec3> offsetsZ = Arrays.asList(new Vec3(3.0, 1.0, 0.0), new Vec3(3.0, 0.0, 0.0), new Vec3(3.0, -1.0, 0.0), new Vec3(2.0, -2.0, 0.0), new Vec3(1.0, -3.0, 0.0), new Vec3(0.0, -3.0, 0.0), new Vec3(-1.0, -3.0, 0.0), new Vec3(-2.0, -2.0, 0.0), new Vec3(-3.0, -1.0, 0.0), new Vec3(-3.0, 0.0, 0.0), new Vec3(-3.0, 1.0, 0.0), new Vec3(-2.0, 2.0, 0.0), new Vec3(-1.0, 3.0, 0.0), new Vec3(0.0, 3.0, 0.0), new Vec3(1.0, 3.0, 0.0), new Vec3(2.0, 2.0, 0.0));
    private static final List<Vec3> offsetsX = Arrays.asList(new Vec3(0.0, 1.0, 3.0), new Vec3(0.0, 0.0, 3.0), new Vec3(0.0, -1.0, 3.0), new Vec3(0.0, -2.0, 2.0), new Vec3(0.0, -3.0, 1.0), new Vec3(0.0, -3.0, 0.0), new Vec3(0.0, -3.0, -1.0), new Vec3(0.0, -2.0, -2.0), new Vec3(0.0, -1.0, -3.0), new Vec3(0.0, 0.0, -3.0), new Vec3(0.0, 1.0, -3.0), new Vec3(0.0, 2.0, -2.0), new Vec3(0.0, 3.0, -1.0), new Vec3(0.0, 3.0, 0.0), new Vec3(0.0, 3.0, 1.0), new Vec3(0.0, 2.0, 2.0));
    private static final int MAX_WHEELS = 3;
    public AABB renderAABB;

    public WatermillBlockEntity(BlockEntityType<WatermillBlockEntity> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void tickClient() {
        this.rotation += this.speed;
        this.rotation %= 1.0;
        ImmersiveEngineering.proxy.handleTileSound(IESounds.mill_creaking, this, Math.abs(this.speed) > 0.0, 0.5f, 1.0f);
    }

    @Override
    public void tickServer() {
        this.rotation += this.speed;
        this.rotation %= 1.0;
        if (this.dynamo != null && this.powerOut > 0.0 && this.dynamo.getCapability() != null) {
            this.dynamo.getCapability().inputRotation(this.powerOut);
            if (this.level.getGameTime() % 1024L == (long)((this.getBlockPos().getX() ^ this.getBlockPos().getZ()) & 0x3FF)) {
                this.handleUpdate(null);
            }
        }
        if (this.dynamo == null || this.level.getGameTime() > this.deferredUpdateTick) {
            this.handleUpdate(null);
        }
    }

    @Override
    public void onLoad() {
        IEBlockInterfaces.IGeneralMultiblock iGeneralMultiblock;
        super.onLoad();
        if (this.level instanceof ServerLevel && (iGeneralMultiblock = this.master()) instanceof WatermillBlockEntity) {
            WatermillBlockEntity master = (WatermillBlockEntity)iGeneralMultiblock;
            master.setShouldUpdate();
        }
    }

    @Override
    public void onNeighborBlockChange(BlockPos pos) {
        super.onNeighborBlockChange(pos);
        IEBlockInterfaces.IGeneralMultiblock iGeneralMultiblock = this.master();
        if (iGeneralMultiblock instanceof WatermillBlockEntity) {
            WatermillBlockEntity master = (WatermillBlockEntity)iGeneralMultiblock;
            master.setShouldUpdate();
        }
    }

    public void handleUpdate(@Nullable Direction search) {
        IEBlockCapabilityCaches.IEBlockCapabilityCache<IRotationAcceptor> facingCap = IEBlockCapabilityCaches.forNeighbor(IRotationAcceptor.CAPABILITY, this, this::getFacing);
        IEBlockCapabilityCaches.IEBlockCapabilityCache<IRotationAcceptor> oppositeCap = IEBlockCapabilityCaches.forNeighbor(IRotationAcceptor.CAPABILITY, this, () -> this.getFacing().getOpposite());
        IEBlockCapabilityCaches.IEBlockCapabilityCache<IRotationAcceptor> iEBlockCapabilityCache = this.dynamo = facingCap.getCapability() == null ? oppositeCap : facingCap;
        if (this.dynamo.getCapability() != null) {
            WatermillBlockEntity watermill;
            BlockEntity be;
            int wheels;
            Direction step = facingCap.getCapability() == null ? this.getFacing() : this.getFacing().getOpposite();
            double torque = this.getIFScaledTorque();
            for (wheels = 1; wheels < 3 && (be = SafeChunkUtils.getSafeBE((LevelAccessor)this.level, this.getBlockPos().relative(step, wheels))) instanceof WatermillBlockEntity && !(watermill = (WatermillBlockEntity)be).isBlocked(); ++wheels) {
                torque += watermill.getIFScaledTorque();
            }
            this.powerOut = Math.abs(torque);
            this.speed = 2.5E-4 * torque / (double)wheels;
            this.level.sendBlockUpdated(this.getBlockPos(), this.level.getBlockState(this.getBlockPos()), this.level.getBlockState(this.getBlockPos()), 3);
            for (int i = 1; i < wheels; ++i) {
                BlockPos pos = this.getBlockPos().relative(step, i);
                BlockEntity be2 = SafeChunkUtils.getSafeBE((LevelAccessor)this.level, pos);
                if (be2 instanceof WatermillBlockEntity) {
                    WatermillBlockEntity watermill2 = (WatermillBlockEntity)be2;
                    if (watermill2.isBlocked()) break;
                    watermill2.speed = this.speed;
                    watermill2.rotation = this.rotation;
                }
                this.level.sendBlockUpdated(pos, this.level.getBlockState(pos), this.level.getBlockState(pos), 3);
            }
        } else if (search == null) {
            WatermillBlockEntity watermill;
            BlockEntity be = SafeChunkUtils.getSafeBE((LevelAccessor)this.level, this.getBlockPos().relative(this.getFacing()));
            if (be instanceof WatermillBlockEntity) {
                watermill = (WatermillBlockEntity)be;
                watermill.handleUpdate(this.getFacing());
            }
            if ((be = SafeChunkUtils.getSafeBE((LevelAccessor)this.level, this.getBlockPos().relative(this.getFacing().getOpposite()))) instanceof WatermillBlockEntity) {
                watermill = (WatermillBlockEntity)be;
                watermill.handleUpdate(this.getFacing().getOpposite());
            }
        } else {
            BlockEntity be = SafeChunkUtils.getSafeBE((LevelAccessor)this.level, this.getBlockPos().relative(search));
            if (be instanceof WatermillBlockEntity) {
                WatermillBlockEntity watermill = (WatermillBlockEntity)be;
                watermill.handleUpdate(search);
            }
        }
        this.deferredUpdateTick = Long.MAX_VALUE;
        this.markChunkDirty();
    }

    public boolean isBlocked() {
        Direction[] directionArray;
        if (this.level == null) {
            return true;
        }
        for (Direction fdY : new Direction[]{Direction.UP, Direction.DOWN}) {
            Direction[] directionArray2;
            if (this.getFacing().getAxis() == Direction.Axis.Z) {
                Direction[] directionArray3 = new Direction[2];
                directionArray3[0] = Direction.EAST;
                directionArray2 = directionArray3;
                directionArray3[1] = Direction.WEST;
            } else {
                Direction[] directionArray4 = new Direction[2];
                directionArray4[0] = Direction.SOUTH;
                directionArray2 = directionArray4;
                directionArray4[1] = Direction.NORTH;
            }
            for (Direction fdW : directionArray2) {
                BlockPos pos = this.getBlockPos().relative(fdW, 2).relative(fdY, 2);
                BlockState state = this.level.getBlockState(pos);
                if (Block.isFaceFull((VoxelShape)state.getShape((BlockGetter)this.level, pos), (Direction)fdW.getOpposite())) {
                    return true;
                }
                if (!Block.isFaceFull((VoxelShape)state.getShape((BlockGetter)this.level, pos), (Direction)fdY.getOpposite())) continue;
                return true;
            }
        }
        if (this.getFacing().getAxis() == Direction.Axis.Z) {
            Direction[] directionArray5 = new Direction[4];
            directionArray5[0] = Direction.EAST;
            directionArray5[1] = Direction.WEST;
            directionArray5[2] = Direction.UP;
            directionArray = directionArray5;
            directionArray5[3] = Direction.DOWN;
        } else {
            Direction[] directionArray6 = new Direction[4];
            directionArray6[0] = Direction.SOUTH;
            directionArray6[1] = Direction.NORTH;
            directionArray6[2] = Direction.UP;
            directionArray = directionArray6;
            directionArray6[3] = Direction.DOWN;
        }
        for (Direction side : directionArray) {
            BlockPos pos = this.getBlockPos().relative(side, 3).relative(side.getClockWise(this.getFacing().getAxis()));
            BlockState state = this.level.getBlockState(pos);
            if (Block.isFaceFull((VoxelShape)state.getShape((BlockGetter)this.level, pos), (Direction)side.getOpposite())) {
                return true;
            }
            pos = this.getBlockPos().relative(side, 3);
            state = this.level.getBlockState(pos);
            if (Block.isFaceFull((VoxelShape)state.getShape((BlockGetter)this.level, pos), (Direction)side.getOpposite())) {
                return true;
            }
            pos = this.getBlockPos().relative(side, 3).relative(side.getCounterClockWise(this.getFacing().getAxis()));
            state = this.level.getBlockState(pos);
            if (!Block.isFaceFull((VoxelShape)state.getShape((BlockGetter)this.level, pos), (Direction)side.getOpposite())) continue;
            return true;
        }
        return false;
    }

    public double getIFScaledTorque() {
        boolean zFacing = this.getFacing().ordinal() <= 3;
        boolean overshot = this.getOvershot(zFacing);
        return (zFacing ? this.getTorque(zFacing, overshot).z() : this.getTorque(zFacing, overshot).x()) * 1.25;
    }

    public Vec3 getTorque(boolean zAxis, boolean overshot) {
        Vec3 torqueVec = overshot ? this.getOvershotTorque(zAxis) : this.getBreastshotTorque(zAxis);
        torqueVec = torqueVec.add(this.getResistanceTorque(torqueVec, zAxis));
        return torqueVec;
    }

    private boolean getOvershot(boolean zAxis) {
        boolean overshot = false;
        overshot = !this.level.getFluidState(this.getBlockPos().offset(-(zAxis ? 1 : 0), 3, -(zAxis ? 0 : 1))).isEmpty() || overshot;
        overshot = !this.level.getFluidState(this.getBlockPos().offset(0, 3, 0)).isEmpty() || overshot;
        overshot = !this.level.getFluidState(this.getBlockPos().offset(zAxis ? 1 : 0, 3, zAxis ? 0 : 1)).isEmpty() || overshot;
        overshot = !this.level.getFluidState(this.getBlockPos().offset(-(zAxis ? 2 : 0), 2, -(zAxis ? 0 : 2))).isEmpty() || overshot;
        overshot = !this.level.getFluidState(this.getBlockPos().offset(zAxis ? 2 : 0, 2, zAxis ? 0 : 2)).isEmpty() || overshot;
        overshot = (double)this.level.getFluidState(this.getBlockPos().offset(-(zAxis ? 3 : 0), 1, -(zAxis ? 0 : 3))).getOwnHeight() > 0.8 || overshot;
        overshot = (double)this.level.getFluidState(this.getBlockPos().offset(zAxis ? 3 : 0, 1, zAxis ? 0 : 3)).getOwnHeight() > 0.8 || overshot;
        return overshot;
    }

    private Vec3 getOvershotTorque(boolean zAxis) {
        Vec3 torque = new Vec3(0.0, 0.0, 0.0);
        for (Vec3 position : zAxis ? offsetsZ : offsetsX) {
            Vec3i tmp = new Vec3i((int)position.x(), (int)position.y(), (int)position.z());
            torque = torque.add(position.cross(Utils.getScaledFlowVector(this.level, this.getBlockPos().offset(tmp))));
        }
        return torque;
    }

    private Vec3 getBreastshotTorque(boolean zAxis) {
        Vec3 torque = new Vec3(0.0, 0.0, 0.0);
        for (int i = 0; i < 11; ++i) {
            Vec3 position = zAxis ? offsetsZ.get(i) : offsetsX.get(i);
            Vec3i tmp = new Vec3i((int)position.x(), (int)position.y(), (int)position.z());
            torque = torque.add(position.cross(Utils.getScaledFlowVector(this.level, this.getBlockPos().offset(tmp))));
        }
        if (torque.length() < 3.25) {
            return torque;
        }
        return torque.add(zAxis ? 0.0 : (torque.x > 0.0 ? 2.9116 : -2.9116), 0.0, zAxis ? (torque.z > 0.0 ? 2.9116 : -2.9116) : 0.0).scale((double)1.35f);
    }

    private Vec3 getResistanceTorque(Vec3 torque, boolean zAxis) {
        Vec3 resistanceTorque = new Vec3(0.0, 0.0, 0.0);
        if (Math.abs(torque.length()) < (double)0.1f) {
            return resistanceTorque;
        }
        for (Vec3 position : zAxis ? offsetsZ : offsetsX) {
            double resistance;
            Vec3i tmp = new Vec3i((int)position.x(), (int)position.y(), (int)position.z());
            double d = resistance = this.level.getFluidState(this.getBlockPos().offset(tmp)).isSourceOfType(this.level.getFluidState(this.getBlockPos().offset(tmp)).getType()) ? 2.0 + 0.1 * torque.length() : 0.0;
            resistanceTorque = zAxis ? resistanceTorque.add(0.0, 0.0, torque.z() > 0.0 ? -resistance : resistance) : resistanceTorque.add(torque.x() > 0.0 ? -resistance : resistance, 0.0, 0.0);
        }
        return resistanceTorque.length() > torque.length() ? torque.scale(-0.9) : resistanceTorque;
    }

    @Override
    public void readCustomNBT(CompoundTag nbt, boolean descPacket, HolderLookup.Provider provider) {
        this.offset = nbt.getIntArray("offset");
        this.rotation = nbt.getDouble("rotation");
        this.speed = nbt.getDouble("speed");
        if (this.offset == null || this.offset.length < 2) {
            this.offset = new int[]{0, 0};
        }
    }

    @Override
    public void writeCustomNBT(CompoundTag nbt, boolean descPacket, HolderLookup.Provider provider) {
        nbt.putIntArray("offset", this.offset);
        nbt.putDouble("rotation", this.rotation);
        nbt.putDouble("speed", this.speed);
    }

    @Override
    public Property<Direction> getFacingProperty() {
        return IEProperties.FACING_HORIZONTAL;
    }

    @Override
    public PlacementLimitation getFacingLimitation() {
        return PlacementLimitation.HORIZONTAL_PREFER_SIDE;
    }

    @Override
    public boolean mirrorFacingOnPlacement(LivingEntity placer) {
        return true;
    }

    @Override
    public boolean canHammerRotate(Direction side, Vec3 hit, LivingEntity entity) {
        return false;
    }

    @Override
    public boolean isDummy() {
        return this.offset[0] != 0 || this.offset[1] != 0;
    }

    @Override
    @Nullable
    public IEBlockInterfaces.IGeneralMultiblock master() {
        if (!this.isDummy()) {
            return this;
        }
        BlockPos masterPos = this.getBlockPos().offset(this.getFacing().getAxis() == Direction.Axis.Z ? -this.offset[0] : 0, -this.offset[1], this.getFacing().getAxis() == Direction.Axis.Z ? 0 : -this.offset[0]);
        BlockEntity te = SafeChunkUtils.getSafeBE((LevelAccessor)this.level, masterPos);
        return this.getClass().isInstance(te) ? (IEBlockInterfaces.IGeneralMultiblock)te : null;
    }

    @Override
    public void placeDummies(BlockPlaceContext ctx, BlockState state) {
        state = (BlockState)state.setValue((Property)IEProperties.MULTIBLOCKSLAVE, (Comparable)Boolean.valueOf(true));
        for (int hh = -2; hh <= 2; ++hh) {
            for (int ww = -2; ww <= 2; ++ww) {
                if ((hh <= -2 || hh >= 2) && (ww <= -2 || ww >= 2) || hh == 0 && ww == 0) continue;
                BlockPos pos2 = this.worldPosition.offset(this.getFacing().getAxis() == Direction.Axis.Z ? ww : 0, hh, this.getFacing().getAxis() == Direction.Axis.Z ? 0 : ww);
                this.level.setBlockAndUpdate(pos2, state);
                WatermillBlockEntity dummy = (WatermillBlockEntity)this.level.getBlockEntity(pos2);
                dummy.setFacing(this.getFacing());
                dummy.offset = new int[]{ww, hh};
            }
        }
    }

    @Override
    public void breakDummies(BlockPos pos, BlockState state) {
        if (this.beingBroken) {
            return;
        }
        BlockPos initPos = pos.offset(this.getFacing().getAxis() == Direction.Axis.Z ? -this.offset[0] : 0, -this.offset[1], this.getFacing().getAxis() == Direction.Axis.X ? -this.offset[0] : 0);
        for (int hh = -2; hh <= 2; ++hh) {
            for (int ww = -2; ww <= 2; ++ww) {
                BlockPos pos2;
                BlockEntity blockEntity;
                if ((hh <= -2 || hh >= 2) && (ww <= -2 || ww >= 2) || !((blockEntity = this.level.getBlockEntity(pos2 = initPos.offset(this.getFacing().getAxis() == Direction.Axis.Z ? ww : 0, hh, this.getFacing().getAxis() == Direction.Axis.X ? ww : 0))) instanceof WatermillBlockEntity)) continue;
                WatermillBlockEntity dummy = (WatermillBlockEntity)blockEntity;
                dummy.beingBroken = true;
                this.level.removeBlock(pos2, false);
            }
        }
    }

    @Override
    public boolean shouldPlaySound(String sound) {
        return Math.abs(this.speed) > 0.0;
    }

    public double getRotation() {
        return this.rotation;
    }

    public double getSpeed() {
        return this.speed;
    }

    public void setShouldUpdate() {
        if (this.isDummy()) {
            return;
        }
        this.deferredUpdateTick = Math.min(this.deferredUpdateTick, this.level.getGameTime());
    }
}

