/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.multiblocks.logic;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.energy.GeneratorFuel;
import blusunrize.immersiveengineering.api.energy.NullEnergyStorage;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IClientTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IMultiblockComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IServerTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.RedstoneControl;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IInitialMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockLogic;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockState;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.CapabilityPosition;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.RelativeBlockFace;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.ShapeType;
import blusunrize.immersiveengineering.api.tool.MachineInterfaceHandler;
import blusunrize.immersiveengineering.common.blocks.multiblocks.shapes.DieselGeneratorShapes;
import blusunrize.immersiveengineering.common.config.IEServerConfig;
import blusunrize.immersiveengineering.common.util.CachedRecipe;
import blusunrize.immersiveengineering.common.util.EnergyHelper;
import blusunrize.immersiveengineering.common.util.IESounds;
import blusunrize.immersiveengineering.common.util.sound.MultiblockSound;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import org.jetbrains.annotations.Nullable;

public class DieselGeneratorLogic
implements IMultiblockLogic<State>,
IServerTickableComponent<State>,
IClientTickableComponent<State> {
    private static final List<BlockPos> ENERGY_OUTPUTS = IntStream.range(0, 3).mapToObj(i -> new BlockPos(i, 2, 4)).toList();
    private static final Vec3 SMOKE_POSITION = new Vec3(2.1875, 3.25, 2.1875);
    public static final BlockPos REDSTONE_POS = new BlockPos(2, 1, 2);
    private static final CapabilityPosition FLUID_INPUT_A = new CapabilityPosition(0, 0, 4, RelativeBlockFace.RIGHT);
    private static final CapabilityPosition FLUID_INPUT_B = new CapabilityPosition(2, 0, 4, RelativeBlockFace.LEFT);

    @Override
    public void tickServer(IMultiblockContext<State> context) {
        State state = context.getState();
        boolean active = context.getState().active;
        if (state.rsState.isEnabled(context) && !state.tank.getFluid().isEmpty()) {
            int output = (Integer)IEServerConfig.MACHINES.dieselGen_output.get();
            List<IEnergyStorage> presentOutputs = state.energyOutputs.stream().map(Supplier::get).filter(Objects::nonNull).collect(Collectors.toList());
            GeneratorFuel recipe = state.recipeGetter.apply(context.getLevel().getRawLevel(), state.tank.getFluid().getFluid());
            if (recipe != null && !presentOutputs.isEmpty() && EnergyHelper.distributeFlux(presentOutputs, output, true) < output) {
                --state.consumeTick;
                if (state.consumeTick <= 0) {
                    float f;
                    int toConsume = 10000 / recipe.getBurnTime();
                    float fluidConsumed = state.tank.drain(toConsume, IFluidHandler.FluidAction.EXECUTE).getAmount();
                    if (f > 0.0f) {
                        if (!active) {
                            active = true;
                        }
                        state.consumeTick = 10 * (int)(fluidConsumed / (float)toConsume);
                    } else if (active) {
                        active = false;
                    }
                }
                EnergyHelper.distributeFlux(presentOutputs, output, false);
            } else if (active) {
                active = false;
            }
        } else if (active) {
            active = false;
        }
        if (active != state.active) {
            state.active = active;
            context.markMasterDirty();
            context.requestMasterBESync();
        }
    }

    @Override
    public void tickClient(IMultiblockContext<State> context) {
        State state = context.getState();
        if (state.active || state.animation_fanFadeIn > 0 || state.animation_fanFadeOut > 0) {
            float step;
            float base = 18.0f;
            float f = step = state.active ? base : 0.0f;
            if (state.animation_fanFadeIn > 0) {
                step -= (float)state.animation_fanFadeIn / 80.0f * base;
                --state.animation_fanFadeIn;
            }
            if (state.animation_fanFadeOut > 0) {
                step += (float)state.animation_fanFadeOut / 80.0f * base;
                --state.animation_fanFadeOut;
            }
            state.animation_fanRotationStep = step;
            state.animation_fanRotation += step;
            state.animation_fanRotation %= 360.0f;
        }
        if (!state.isSoundPlaying.getAsBoolean()) {
            Vec3 soundPos = context.getLevel().toAbsolute(new Vec3(2.5, 1.5, 1.5));
            state.isSoundPlaying = MultiblockSound.startSound(() -> state.active, context.isValid(), soundPos, IESounds.dieselGenerator, 0.5f);
        }
        if (state.active && context.getLevel().shouldTickModulo(2)) {
            Vec3 absoluteSmokePosition = context.getLevel().toAbsolute(SMOKE_POSITION);
            context.getLevel().getRawLevel().addAlwaysVisibleParticle((ParticleOptions)ParticleTypes.CAMPFIRE_COSY_SMOKE, absoluteSmokePosition.x, absoluteSmokePosition.y, absoluteSmokePosition.z, this.particleXZSpeed(), 0.0625, this.particleXZSpeed());
        }
    }

    private double particleXZSpeed() {
        return ApiUtils.RANDOM.nextDouble(-0.015625, 0.015625);
    }

    @Override
    public State createInitialState(IInitialMultiblockContext<State> capabilitySource) {
        return new State(capabilitySource);
    }

    @Override
    public void registerCapabilities(IMultiblockComponent.CapabilityRegistrar<State> register) {
        register.register(Capabilities.FluidHandler.BLOCK, (state, position) -> {
            if (FLUID_INPUT_A.equalsOrNullFace(position) || FLUID_INPUT_B.equalsOrNullFace(position)) {
                return state.tank;
            }
            return null;
        });
        register.register(Capabilities.EnergyStorage.BLOCK, (state, position) -> {
            if (position.side() == null || position.side() == RelativeBlockFace.UP && ENERGY_OUTPUTS.contains(position.posInMultiblock())) {
                return NullEnergyStorage.INSTANCE;
            }
            return null;
        });
        register.registerAtBlockPos(MachineInterfaceHandler.IMachineInterfaceConnection.CAPABILITY, REDSTONE_POS, state -> state.mifHandler);
    }

    @Override
    public Function<BlockPos, VoxelShape> shapeGetter(ShapeType forType) {
        if (forType == ShapeType.BLOCK_SUPPORT) {
            return DieselGeneratorShapes.GETTER_WITH_REDSTONE_SUPPORT;
        }
        return DieselGeneratorShapes.SHAPE_GETTER;
    }

    public static class State
    implements IMultiblockState {
        public final FluidTank tank = new FluidTank(24000);
        private boolean active = false;
        private int consumeTick = 0;
        public final RedstoneControl.RSState rsState = RedstoneControl.RSState.enabledByDefault();
        public float animation_fanRotationStep = 0.0f;
        public float animation_fanRotation = 0.0f;
        private int animation_fanFadeIn = 0;
        private int animation_fanFadeOut = 0;
        private BooleanSupplier isSoundPlaying = () -> false;
        private final BiFunction<Level, Fluid, GeneratorFuel> recipeGetter = CachedRecipe.cached(GeneratorFuel::getRecipeFor);
        private final List<Supplier<@Nullable IEnergyStorage>> energyOutputs;
        private final MachineInterfaceHandler.IMachineInterfaceConnection mifHandler;

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        public State(IInitialMultiblockContext<State> ctx) {
            // Could not load outer class - annotation placement on inner may be incorrect
            @Nullable ImmutableList.Builder outputs = ImmutableList.builder();
            for (BlockPos pos : ENERGY_OUTPUTS) {
                outputs.add(ctx.getCapabilityAt(Capabilities.EnergyStorage.BLOCK, pos, RelativeBlockFace.DOWN));
            }
            this.energyOutputs = outputs.build();
            this.mifHandler = () -> new MachineInterfaceHandler.MachineCheckImplementation[]{new MachineInterfaceHandler.MachineCheckImplementation<BooleanSupplier>(() -> this.active, MachineInterfaceHandler.BASIC_ACTIVE), new MachineInterfaceHandler.MachineCheckImplementation<FluidTank>(this.tank, MachineInterfaceHandler.BASIC_FLUID_IN)};
        }

        @Override
        public void writeSaveNBT(CompoundTag nbt, HolderLookup.Provider provider) {
            nbt.put("tank0", (Tag)this.tank.writeToNBT(provider, new CompoundTag()));
            nbt.putBoolean("active", this.active);
            nbt.putInt("consumeTick", this.consumeTick);
        }

        @Override
        public void readSaveNBT(CompoundTag nbt, HolderLookup.Provider provider) {
            this.tank.readFromNBT(provider, nbt.getCompound("tank0"));
            this.active = nbt.getBoolean("active");
            this.consumeTick = nbt.getInt("consumeTick");
        }

        @Override
        public void writeSyncNBT(CompoundTag nbt, HolderLookup.Provider provider) {
            nbt.putBoolean("active", this.active);
        }

        @Override
        public void readSyncNBT(CompoundTag nbt, HolderLookup.Provider provider) {
            boolean oldActive = this.active;
            this.active = nbt.getBoolean("active");
            if (this.active && !oldActive) {
                this.animation_fanFadeIn = 80;
            } else if (!this.active && oldActive) {
                this.animation_fanFadeOut = 80;
            }
        }

        public boolean isActive() {
            return this.active;
        }
    }
}

