/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.TargetingInfo;
import blusunrize.immersiveengineering.api.utils.shapes.CachedVoxelShapes;
import blusunrize.immersiveengineering.api.utils.shapes.ShapeUtils;
import blusunrize.immersiveengineering.api.wires.Connection;
import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import blusunrize.immersiveengineering.api.wires.WireType;
import blusunrize.immersiveengineering.api.wires.redstone.IRedstoneConnector;
import blusunrize.immersiveengineering.api.wires.redstone.RedstoneNetworkHandler;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.PlacementLimitation;
import blusunrize.immersiveengineering.common.blocks.generic.ImmersiveConnectableBlockEntity;
import blusunrize.immersiveengineering.common.blocks.ticking.IEServerTickableBE;
import blusunrize.immersiveengineering.common.register.IEBlockEntities;
import blusunrize.immersiveengineering.common.util.Utils;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class RedstoneSwitchboardBlockEntity
extends ImmersiveConnectableBlockEntity
implements IEServerTickableBE,
IEBlockInterfaces.IStateBasedDirectional,
IEBlockInterfaces.IScrewdriverInteraction,
IEBlockInterfaces.IBlockBounds,
IEBlockInterfaces.IBlockOverlayText,
IRedstoneConnector {
    protected static final int RIGHT_INDEX = 0;
    protected static final int LEFT_INDEX = 1;
    public boolean rsDirty = false;
    public List<SwitchboardSetting> settings = new ArrayList<SwitchboardSetting>();
    byte[] output = new byte[16];
    CachedVoxelShapes<Direction> SHAPES = new CachedVoxelShapes<Direction>(key -> ImmutableList.of((Object)ShapeUtils.transformAABB(new AABB(0.125, 0.0, 0.0, 0.875, 0.75, 0.375), key), (Object)ShapeUtils.transformAABB(new AABB(0.1875, 0.75, 0.0625, 0.4375, 1.0, 0.3125), key), (Object)ShapeUtils.transformAABB(new AABB(0.5625, 0.75, 0.0625, 0.8125, 1.0, 0.3125), key)));

    public RedstoneSwitchboardBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)IEBlockEntities.REDSTONE_SWITCHBOARD.get(), pos, state);
    }

    public void addSetting(SwitchboardSetting newSetting) {
        this.settings.removeIf(oldSetting -> oldSetting.input().equals((Object)newSetting.input()) || oldSetting.output().equals((Object)newSetting.output()));
        this.settings.add(newSetting);
        this.rsDirty = true;
    }

    public void removeSetting(DyeColor output) {
        this.settings.removeIf(oldSetting -> oldSetting.output().equals((Object)output));
        this.rsDirty = true;
    }

    @Override
    public void tickServer() {
        RedstoneNetworkHandler rightHander;
        if (this.rsDirty && (rightHander = this.globalNet.getLocalNet(new ConnectionPoint(this.worldPosition, 0)).getHandler(RedstoneNetworkHandler.ID, RedstoneNetworkHandler.class)) != null) {
            rightHander.updateValues();
        }
    }

    @Override
    public void onChange(ConnectionPoint cp, RedstoneNetworkHandler handler) {
        if (cp.index() == 1) {
            this.settings.forEach(setting -> {
                this.output[setting.output().getId()] = setting.getOutput(handler.getValue(setting.input().getId()));
            });
            this.rsDirty = true;
        }
    }

    @Override
    public void updateInput(byte[] signals, ConnectionPoint cp) {
        if (cp.index() == 0) {
            for (DyeColor dye : DyeColor.values()) {
                signals[dye.getId()] = (byte)Math.max(signals[dye.getId()], this.output[dye.getId()]);
            }
            this.rsDirty = false;
        }
    }

    @Override
    public void writeCustomNBT(CompoundTag nbt, boolean descPacket, HolderLookup.Provider provider) {
        super.writeCustomNBT(nbt, descPacket, provider);
        ListTag settingsTag = new ListTag();
        this.settings.forEach(switchboardSetting -> settingsTag.add((Object)switchboardSetting.writeToNBT()));
        nbt.put("settings", (Tag)settingsTag);
    }

    @Override
    public void readCustomNBT(@Nonnull CompoundTag nbt, boolean descPacket, HolderLookup.Provider provider) {
        super.readCustomNBT(nbt, descPacket, provider);
        ListTag settingsTag = nbt.getList("settings", 10);
        this.settings.clear();
        for (int i = 0; i < settingsTag.size(); ++i) {
            this.settings.add(new SwitchboardSetting(settingsTag.getCompound(i)));
        }
    }

    @Override
    public void receiveMessageFromClient(CompoundTag message) {
        if (message.contains("remove")) {
            this.removeSetting(DyeColor.byId((int)message.getInt("remove")));
        } else {
            this.addSetting(new SwitchboardSetting(message));
        }
    }

    @Override
    public Collection<ConnectionPoint> getConnectionPoints() {
        return ImmutableList.of((Object)new ConnectionPoint(this.worldPosition, 0), (Object)new ConnectionPoint(this.worldPosition, 1));
    }

    @Override
    public Property<Direction> getFacingProperty() {
        return IEProperties.FACING_HORIZONTAL;
    }

    @Override
    public PlacementLimitation getFacingLimitation() {
        return PlacementLimitation.HORIZONTAL_PREFER_SIDE;
    }

    @Override
    public boolean canHammerRotate(Direction side, Vec3 hit, LivingEntity entity) {
        return false;
    }

    @Override
    public Vec3 getConnectionOffset(ConnectionPoint here, ConnectionPoint other, WireType type) {
        boolean right = here.index() == 0;
        double conRadius = type.getRenderDiameter() / 2.0;
        if (this.getFacing() == Direction.NORTH) {
            return new Vec3(right ? 0.6875 - conRadius : 0.3125 + conRadius, 0.875 - conRadius, 0.1875);
        }
        if (this.getFacing() == Direction.SOUTH) {
            return new Vec3(right ? 0.3125 + conRadius : 0.6875 - conRadius, 0.875 - conRadius, 0.8125);
        }
        if (this.getFacing() == Direction.WEST) {
            return new Vec3(0.1875, 0.875 - conRadius, right ? 0.3125 + conRadius : 0.6875 - conRadius);
        }
        if (this.getFacing() == Direction.EAST) {
            return new Vec3(0.8125, 0.875 - conRadius, right ? 0.6875 - conRadius : 0.3125 + conRadius);
        }
        return new Vec3(0.5, 0.5, 0.5);
    }

    @Override
    public boolean canConnectCable(WireType cableType, ConnectionPoint target, Vec3i offset) {
        return "REDSTONE".equals(cableType.getCategory());
    }

    @Override
    @Nullable
    public Component[] getOverlayText(Player player, HitResult mop, boolean hammer) {
        if (!Utils.isScrewdriver(player.getItemInHand(InteractionHand.MAIN_HAND))) {
            return null;
        }
        Vec3 target = mop.getLocation().subtract(Vec3.atLowerCornerOf((Vec3i)this.getPosition()));
        if (target.y <= 0.75) {
            return null;
        }
        Direction facing = this.getFacing();
        double hitPos = facing.getAxis() == Direction.Axis.X ? target.z : 1.0 - target.x;
        if (hitPos < 0.5 == (facing.getAxisDirection() == Direction.AxisDirection.POSITIVE)) {
            return new Component[]{Component.translatable((String)"desc.immersiveengineering.info.blockSide.io.input")};
        }
        return new Component[]{Component.translatable((String)"desc.immersiveengineering.info.blockSide.io.output")};
    }

    @Override
    public ItemInteractionResult screwdriverUseSide(Direction side, Player player, InteractionHand hand, Vec3 hitVec) {
        if (this.level.isClientSide) {
            ImmersiveEngineering.proxy.openTileScreen("redstoneswitchboard", this);
        }
        return ItemInteractionResult.SUCCESS;
    }

    @Override
    @Nonnull
    public VoxelShape getBlockBounds(@Nullable CollisionContext ctx) {
        return this.SHAPES.get(this.getFacing());
    }

    @Override
    @Nullable
    public ConnectionPoint getTargetedPoint(TargetingInfo target, Vec3i offset) {
        ConnectionPoint leftCP = new ConnectionPoint(this.worldPosition, 1);
        ConnectionPoint rightCP = new ConnectionPoint(this.worldPosition, 0);
        boolean leftEmpty = this.getLocalNet(1).getConnections(leftCP).stream().allMatch(Connection::isInternal);
        boolean rightEmpty = this.getLocalNet(0).getConnections(rightCP).stream().allMatch(Connection::isInternal);
        if (leftEmpty && !rightEmpty) {
            return leftCP;
        }
        if (!leftEmpty && rightEmpty) {
            return rightCP;
        }
        Direction facing = this.getFacing();
        double hitPos = facing.getAxis() == Direction.Axis.X ? (double)target.hitZ : (double)(1.0f - target.hitX);
        if (hitPos < 0.5 == (facing.getAxisDirection() == Direction.AxisDirection.POSITIVE)) {
            return leftCP;
        }
        return rightCP;
    }

    public record SwitchboardSetting(DyeColor input, boolean invert, DyeColor output) {
        private SwitchboardSetting(CompoundTag nbt) {
            this(DyeColor.byId((int)nbt.getInt("input")), nbt.getBoolean("invert"), DyeColor.byId((int)nbt.getInt("output")));
        }

        public CompoundTag writeToNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.putInt("input", this.input.getId());
            nbt.putBoolean("invert", this.invert());
            nbt.putInt("output", this.output.getId());
            return nbt;
        }

        public byte getOutput(byte input) {
            if (this.invert()) {
                return (byte)(15 - input);
            }
            return input;
        }
    }
}

