/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class IETrapDoorBlock
extends TrapDoorBlock {
    private boolean lockedByRedstone = false;

    public IETrapDoorBlock(BlockSetType blockSetType, BlockBehaviour.Properties properties) {
        super(blockSetType, properties);
    }

    public IETrapDoorBlock setLockedByRedstone() {
        this.lockedByRedstone = true;
        return this;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState state = super.getStateForPlacement(context);
        if (state == null) {
            return null;
        }
        if (this.lockedByRedstone) {
            return (BlockState)state.setValue((Property)OPEN, (Comparable)Boolean.valueOf(false));
        }
        return state;
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState blockState, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (this.lockedByRedstone && ((Boolean)blockState.getValue((Property)POWERED)).booleanValue()) {
            level.playSound(player, pos, SoundEvents.ZOMBIE_ATTACK_IRON_DOOR, SoundSource.BLOCKS, 0.25f, level.getRandom().nextFloat() * 0.1f + 0.9f);
            return ItemInteractionResult.CONSUME_PARTIAL;
        }
        return super.useItemOn(stack, blockState, level, pos, player, hand, hitResult);
    }

    public void neighborChanged(BlockState blockState, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        if (this.lockedByRedstone) {
            boolean flag = level.hasNeighborSignal(pos);
            if (!this.defaultBlockState().is(block) && flag != (Boolean)blockState.getValue((Property)POWERED)) {
                level.setBlock(pos, (BlockState)blockState.setValue((Property)POWERED, (Comparable)Boolean.valueOf(flag)), 2);
            }
        } else {
            super.neighborChanged(blockState, level, pos, block, fromPos, isMoving);
        }
    }
}

