/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.models.obj.callback.item;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.client.ieobj.ItemCallback;
import blusunrize.immersiveengineering.api.tool.upgrade.UpgradeData;
import blusunrize.immersiveengineering.api.tool.upgrade.UpgradeEffect;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.gui.RevolverContainer;
import blusunrize.immersiveengineering.common.items.RevolverItem;
import blusunrize.immersiveengineering.common.register.IEDataComponents;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Transformation;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class RevolverCallbacks
implements ItemCallback<Key> {
    public static final RevolverCallbacks INSTANCE = new RevolverCallbacks();
    public static HashMap<String, TextureAtlasSprite> revolverIcons = new HashMap();
    public static TextureAtlasSprite revolverDefaultTexture;
    private static final List<List<String>> SPECIAL_GROUPS;
    private static final Transformation MAT_OPEN;
    private static final Transformation MAT_CLOSE;
    private static final Transformation MAT_CYLINDER;
    private static final Transformation MAT_SNUB_SCOPE;
    private static final Transformation MAT_SNUB_ELECTRO;

    public static void retrieveRevolverTextures(TextureAtlas map) {
        revolverDefaultTexture = map.getSprite(RevolverCallbacks.revolverRL("revolver"));
        for (String key : RevolverItem.specialRevolversByTag.keySet()) {
            if (key.isEmpty() || RevolverItem.specialRevolversByTag.get(key).tag().isEmpty()) continue;
            int split = key.lastIndexOf("_");
            if (split < 0) {
                split = key.length();
            }
            revolverIcons.put(key, map.getSprite(RevolverCallbacks.revolverRL("revolver_" + key.substring(0, split).toLowerCase(Locale.US))));
        }
    }

    private static ResourceLocation revolverRL(String revolverName) {
        return ImmersiveEngineering.rl("item/revolvers/" + revolverName);
    }

    @Override
    public Key extractKey(ItemStack stack, LivingEntity owner) {
        UpgradeData upgrades = RevolverItem.getUpgradesStatic(stack);
        return new Key((String)stack.getOrDefault(IEDataComponents.REVOLVER_ELITE, (Object)""), (String)stack.getOrDefault(IEDataComponents.REVOLVER_FLAVOUR, (Object)""), upgrades.get(UpgradeEffect.BULLETS) > 0, upgrades.has(UpgradeEffect.FANCY_ANIMATION), upgrades.get(UpgradeEffect.MELEE).floatValue() > 0.0f, upgrades.has(UpgradeEffect.ELECTRO), upgrades.has(UpgradeEffect.SCOPE), ((RevolverItem.RevolverCooldowns)stack.getOrDefault(IEDataComponents.REVOLVER_COOLDOWN, (Object)RevolverItem.RevolverCooldowns.DEFAULT)).reloadTimer(), upgrades.has(UpgradeEffect.BARREL_SNUB));
    }

    @Override
    public TextureAtlasSprite getTextureReplacement(Key stack, String group, String material) {
        if (!stack.elite().isEmpty()) {
            return revolverIcons.get(stack.elite());
        }
        return revolverDefaultTexture;
    }

    @Override
    public boolean shouldRenderGroup(Key stack, String group, RenderType layer) {
        RevolverItem.SpecialRevolver r;
        if (group.equals("frame") || group.equals("cylinder")) {
            return true;
        }
        HashSet<String> render = new HashSet<String>();
        String tag = stack.elite();
        String flavour = stack.flavor();
        if (!tag.isEmpty() && RevolverItem.specialRevolversByTag.containsKey(tag)) {
            RevolverItem.SpecialRevolver r2 = RevolverItem.specialRevolversByTag.get(tag);
            if (r2 != null && r2.renderAdditions() != null) {
                render.addAll(r2.renderAdditions());
            }
        } else if (!flavour.isEmpty() && RevolverItem.specialRevolversByTag.containsKey(flavour) && (r = RevolverItem.specialRevolversByTag.get(flavour)) != null && r.renderAdditions() != null) {
            render.addAll(r.renderAdditions());
        }
        if (stack.extraBullets() && !render.contains("dev_mag")) {
            render.add("player_mag");
        }
        if (stack.extraMelee() && !render.contains("dev_bayonet")) {
            render.add("bayonet_attachment");
            render.add("player_bayonet");
        }
        if (stack.electro()) {
            render.add("player_electro_0");
            render.add("player_electro_1");
        }
        if (stack.scope()) {
            render.add("dev_scope");
        }
        if (stack.snub()) {
            render.add("barrel_snub");
        } else {
            render.add("barrel");
            render.add("cosmetic_compensator");
        }
        return render.contains(group);
    }

    @Override
    public void handlePerspective(Key key, LivingEntity holder, ItemDisplayContext cameraItemDisplayContext, PoseStack mat) {
        if (holder instanceof Player) {
            Player player = (Player)holder;
            if (cameraItemDisplayContext == ItemDisplayContext.FIRST_PERSON_RIGHT_HAND || cameraItemDisplayContext == ItemDisplayContext.FIRST_PERSON_LEFT_HAND || cameraItemDisplayContext == ItemDisplayContext.THIRD_PERSON_RIGHT_HAND || cameraItemDisplayContext == ItemDisplayContext.THIRD_PERSON_LEFT_HAND) {
                float f;
                boolean left;
                boolean main = (cameraItemDisplayContext == ItemDisplayContext.FIRST_PERSON_RIGHT_HAND || cameraItemDisplayContext == ItemDisplayContext.THIRD_PERSON_RIGHT_HAND) == (holder.getMainArm() == HumanoidArm.RIGHT);
                boolean bl = left = cameraItemDisplayContext == ItemDisplayContext.FIRST_PERSON_LEFT_HAND || cameraItemDisplayContext == ItemDisplayContext.THIRD_PERSON_LEFT_HAND;
                if (key.fancyAnimation() && main && (f = player.getAttackStrengthScale(ClientUtils.mc().getTimer().getGameTimeDeltaTicks())) < 1.0f) {
                    float angle = f * -6.28318f;
                    if (left) {
                        angle *= -1.0f;
                    }
                    mat.translate(0.0, 1.5 - (double)f, 0.0);
                    mat.mulPose(new Quaternionf().rotateXYZ(0.0f, 0.0f, angle));
                }
                if (key.reload() > 0) {
                    f = 3.0f - (float)key.reload / 20.0f;
                    if ((double)f > 0.35 && (double)f < 1.95) {
                        if ((double)f < 0.5) {
                            mat.translate((0.35 - (double)f) * 2.0, 0.0, 0.0);
                            mat.mulPose(new Quaternionf().rotateAxis(2.64f * (f - 0.35f), (Vector3fc)new Vector3f(0.0f, 0.0f, 1.0f)));
                        } else if ((double)f < 0.6) {
                            mat.translate(((double)f - 0.5) * 6.0, (0.5 - (double)f) * 1.0, 0.0);
                            mat.mulPose(new Quaternionf().rotateAxis(0.87266f, (Vector3fc)new Vector3f(0.0f, 0.0f, 1.0f)));
                        } else if ((double)f < 1.7) {
                            mat.translate(0.0, -0.6, 0.0);
                            mat.mulPose(new Quaternionf().rotateAxis(0.87266f, (Vector3fc)new Vector3f(0.0f, 0.0f, 1.0f)));
                        } else if ((double)f < 1.8) {
                            mat.translate((1.8 - (double)f) * 6.0, ((double)f - 1.8) * 1.0, 0.0);
                            mat.mulPose(new Quaternionf().rotateAxis(0.87266f, (Vector3fc)new Vector3f(0.0f, 0.0f, 1.0f)));
                        } else {
                            mat.translate((f - 1.95f) * 2.0f, 0.0f, 0.0f);
                            mat.mulPose(new Quaternionf().rotateAxis(2.64f * (1.95f - f), (Vector3fc)new Vector3f(0.0f, 0.0f, 1.0f)));
                        }
                    }
                } else if (player.containerMenu instanceof RevolverContainer) {
                    mat.translate(left ? 0.4 : -0.4, 0.4, 0.0);
                    mat.mulPose(new Quaternionf().rotateAxis(0.87266f, 0.0f, 0.0f, 1.0f));
                }
            }
        }
    }

    @Override
    public List<List<String>> getSpecialGroups(ItemStack stack, ItemDisplayContext transform, LivingEntity entity) {
        return SPECIAL_GROUPS;
    }

    @Override
    @Nonnull
    public Transformation getTransformForGroups(ItemStack stack, List<String> groups, ItemDisplayContext transform, LivingEntity entity, float partialTicks) {
        String firstGroup = groups.get(0);
        if (RevolverItem.getUpgradesStatic(stack).has(UpgradeEffect.BARREL_SNUB)) {
            if ("dev_scope".equals(firstGroup)) {
                return MAT_SNUB_SCOPE;
            }
            if ("player_electro_0".equals(firstGroup)) {
                return MAT_SNUB_ELECTRO;
            }
        }
        if (entity instanceof Player && (transform == ItemDisplayContext.FIRST_PERSON_RIGHT_HAND || transform == ItemDisplayContext.FIRST_PERSON_LEFT_HAND || transform == ItemDisplayContext.THIRD_PERSON_RIGHT_HAND || transform == ItemDisplayContext.THIRD_PERSON_LEFT_HAND)) {
            boolean main = (transform == ItemDisplayContext.FIRST_PERSON_RIGHT_HAND || transform == ItemDisplayContext.THIRD_PERSON_RIGHT_HAND) == (entity.getMainArm() == HumanoidArm.RIGHT);
            boolean left = transform == ItemDisplayContext.FIRST_PERSON_LEFT_HAND || transform == ItemDisplayContext.THIRD_PERSON_LEFT_HAND;
            stack = main ? entity.getMainHandItem() : entity.getOffhandItem();
            RevolverItem.RevolverCooldowns cooldowns = RevolverItem.getCooldowns(stack);
            if (cooldowns.reloadTimer() > 0) {
                float f = 3.0f - (float)cooldowns.reloadTimer() / 20.0f;
                if ("frame".equals(firstGroup)) {
                    if ((double)f < 0.35 || (double)f > 1.95) {
                        return MAT_CLOSE;
                    }
                    if ((double)f < 0.5) {
                        return new Transformation(new Vector3f(-0.625f, 0.25f, 0.0f), new Quaternionf().rotateXYZ(0.0f, 0.0f, -2.64f * (f - 0.35f)), null, null);
                    }
                    if ((double)f < 1.8) {
                        return MAT_OPEN;
                    }
                    return new Transformation(new Vector3f(-0.625f, 0.25f, 0.0f), new Quaternionf().rotateXYZ(0.0f, 0.0f, -2.64f * (1.95f - f)), null, null);
                }
                if ("cylinder".equals(firstGroup) && (double)f > 2.5 && (double)f < 2.9) {
                    float angle = (float)(left ? -1 : 1) * -15.70795f * (f - 2.5f);
                    return new Transformation(new Vector3f(0.0f, 0.6875f, 0.0f), new Quaternionf().rotateXYZ(angle, 0.0f, 0.0f), null, null);
                }
            } else if ("frame".equals(firstGroup) && ((Player)entity).containerMenu instanceof RevolverContainer) {
                return MAT_OPEN;
            }
        }
        return switch (firstGroup) {
            case "frame" -> MAT_CLOSE;
            case "cylinder" -> MAT_CYLINDER;
            default -> Transformation.identity();
        };
    }

    @Override
    public Key getDefaultKey() {
        return new Key("", "", false, false, false, false, false, 0, false);
    }

    static {
        SPECIAL_GROUPS = List.of(List.of("frame"), List.of("cylinder"), List.of("dev_scope"), List.of("player_electro_0", "player_electro_1"));
        MAT_OPEN = new Transformation(new Vector3f(-0.625f, 0.25f, 0.0f), new Quaternionf().rotateXYZ(0.0f, 0.0f, -0.87266f), null, null);
        MAT_CLOSE = new Transformation(new Vector3f(-0.625f, 0.25f, 0.0f), null, null, null);
        MAT_CYLINDER = new Transformation(new Vector3f(0.0f, 0.6875f, 0.0f), null, null, null);
        MAT_SNUB_SCOPE = new Transformation(new Vector3f(1.375f, 0.0f, 0.0f), null, null, null);
        MAT_SNUB_ELECTRO = new Transformation(new Vector3f(1.4375f, -0.1875f, 0.125f), null, null, null);
    }

    public record Key(String elite, String flavor, boolean extraBullets, boolean fancyAnimation, boolean extraMelee, boolean electro, boolean scope, int reload, boolean snub) {
    }
}

