/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.manual;

import blusunrize.immersiveengineering.api.crafting.MixerRecipe;
import blusunrize.immersiveengineering.api.fluid.FluidUtils;
import blusunrize.immersiveengineering.client.manual.ManualElementIECrafting;
import blusunrize.lib.manual.ManualInstance;
import blusunrize.lib.manual.PositionedItemStack;
import blusunrize.lib.manual.utils.ManualRecipeRef;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;

public class ManualElementMixer
extends ManualElementIECrafting {
    protected final Fluid[] fluids;

    public ManualElementMixer(ManualInstance manual, Fluid ... fluids) {
        super(manual, new ManualRecipeRef[0]);
        this.fluids = fluids;
        this.recalculateCraftingRecipes();
    }

    @Override
    public void recalculateCraftingRecipes() {
        this.recipes.clear();
        this.providedItems.clear();
        for (RecipeHolder<MixerRecipe> holder : MixerRecipe.RECIPES.getRecipes((Level)Minecraft.getInstance().level)) {
            MixerRecipe recipe = (MixerRecipe)holder.value();
            for (int iFluid = 0; iFluid < this.fluids.length; ++iFluid) {
                if (recipe.fluidOutput.getFluid() != this.fluids[iFluid]) continue;
                int h = (int)Math.ceil((float)recipe.itemInputs.size() / 2.0f);
                int middle = (int)((float)h / 2.0f * 18.0f);
                PositionedItemStack[] pIngredients = new PositionedItemStack[recipe.itemInputs.size() + 2];
                List<ItemStack> inputBucket = recipe.fluidInput.getMatchingFluidStacks().stream().map(fluidStack -> fluidStack.getFluid().getBucket().getDefaultInstance()).toList();
                String inputFraction = FluidUtils.getBucketFraction(recipe.fluidInput.getAmount());
                pIngredients[0] = new PositionedItemStack(inputBucket, 8, middle - 9, inputFraction);
                for (int i = 0; i < recipe.itemInputs.size(); ++i) {
                    pIngredients[1 + i] = new PositionedItemStack(recipe.itemInputs.get(i).getMatchingStacks(), 32 + i % 2 * 18, i / 2 * 18);
                }
                ItemStack outputBucket = recipe.fluidOutput.getFluid().getBucket().getDefaultInstance();
                String outputFraction = FluidUtils.getBucketFraction(recipe.fluidOutput.getAmount());
                pIngredients[++i] = new PositionedItemStack(outputBucket, 86, middle - 9, outputFraction);
                this.addProvidedItem(outputBucket);
                this.recipes.add(pIngredients);
                this.arrowPositions.add(new ManualElementIECrafting.ArrowPosition(69, middle - 5));
                if (h * 18 <= this.yOff) continue;
                this.yOff = h * 18;
            }
        }
    }
}

