/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.gui;

import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.api.IEApiDataComponents;
import blusunrize.immersiveengineering.api.crafting.BlueprintCraftingRecipe;
import blusunrize.immersiveengineering.client.gui.ToolModificationScreen;
import blusunrize.immersiveengineering.client.gui.elements.GuiButtonIE;
import blusunrize.immersiveengineering.client.gui.info.BlueprintOutputArea;
import blusunrize.immersiveengineering.client.gui.info.InfoArea;
import blusunrize.immersiveengineering.client.utils.GuiHelper;
import blusunrize.immersiveengineering.common.blocks.wooden.ModWorkbenchBlockEntity;
import blusunrize.immersiveengineering.common.gui.IESlot;
import blusunrize.immersiveengineering.common.gui.ModWorkbenchContainer;
import blusunrize.immersiveengineering.common.items.EngineersBlueprintItem;
import blusunrize.immersiveengineering.common.network.MessageBlockEntitySync;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;

public class ModWorkbenchScreen
extends ToolModificationScreen<ModWorkbenchContainer> {
    private static final ResourceLocation TEXTURE = ModWorkbenchScreen.makeTextureLocation("workbench");
    private static final GuiButtonIE.ButtonTexture PAGE_LEFT = new GuiButtonIE.ButtonTexture(IEApi.ieLoc("mod_workbench/page_left"));
    private static final GuiButtonIE.ButtonTexture PAGE_RIGHT = new GuiButtonIE.ButtonTexture(IEApi.ieLoc("mod_workbench/page_right"));
    private final ModWorkbenchBlockEntity workbench;

    public ModWorkbenchScreen(ModWorkbenchContainer container, Inventory inventoryPlayer, Component title) {
        super(container, inventoryPlayer, title, TEXTURE);
        this.workbench = (ModWorkbenchBlockEntity)container.tile;
        this.imageHeight = 168;
    }

    @Override
    protected void sendMessage(CompoundTag data) {
        PacketDistributor.sendToServer((CustomPacketPayload)new MessageBlockEntitySync(this.workbench.getBlockPos(), data), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public void init() {
        List<RecipeHolder<BlueprintCraftingRecipe>> recipes;
        super.init();
        Slot s = ((ModWorkbenchContainer)this.menu).getSlot(0);
        if (s.hasItem() && s.getItem().getItem() instanceof EngineersBlueprintItem && (recipes = BlueprintCraftingRecipe.findRecipes((Level)Minecraft.getInstance().level, (String)s.getItem().get(IEApiDataComponents.BLUEPRINT_TYPE))) != null && !recipes.isEmpty() && recipes.size() > 9) {
            this.addRenderableWidget((GuiEventListener)new GuiButtonIE(this.leftPos + 118, this.topPos + 9, 18, 12, (Component)Component.empty(), PAGE_LEFT, b -> this.sendButton(1)));
            this.addRenderableWidget((GuiEventListener)new GuiButtonIE(this.leftPos + 154, this.topPos + 9, 18, 12, (Component)Component.empty(), PAGE_RIGHT, b -> this.sendButton(2)));
        }
    }

    private void sendButton(int i) {
        ((ModWorkbenchContainer)this.menu).clickMenuButton((Player)this.minecraft.player, i);
        this.minecraft.gameMode.handleInventoryButtonClick(((ModWorkbenchContainer)this.menu).containerId, i);
    }

    @Override
    @Nonnull
    protected List<InfoArea> makeInfoAreas() {
        ArrayList<InfoArea> areas = new ArrayList<InfoArea>();
        for (int i = 0; i < ((ModWorkbenchContainer)this.menu).ownSlotCount; ++i) {
            Slot s = ((ModWorkbenchContainer)this.menu).getSlot(i);
            if (!(s instanceof IESlot.BlueprintOutput)) continue;
            areas.add(new BlueprintOutputArea((IESlot.BlueprintOutput)s, this.leftPos, this.topPos));
        }
        return areas;
    }

    @Override
    protected void drawContainerBackgroundPre(@Nonnull GuiGraphics graphics, float f, int mx, int my) {
        for (int i = 0; i < ((ModWorkbenchContainer)this.menu).ownSlotCount; ++i) {
            IESlot.BlueprintOutput bo;
            Slot s = ((ModWorkbenchContainer)this.menu).getSlot(i);
            if (s instanceof IESlot.AlwaysEmptySlot || s instanceof IESlot.BlueprintOutput && !(bo = (IESlot.BlueprintOutput)s).isOnPage()) continue;
            GuiHelper.drawSlot(graphics, this.leftPos + s.x, this.topPos + s.y, 16, 16, 0x77222222, 0x77444444, 0x77999999);
        }
    }
}

