/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.tool;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.utils.SetRestrictedField;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageSources;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Blaze;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.event.entity.EntityTeleportEvent;
import net.neoforged.neoforge.fluids.FluidStack;

public class ChemthrowerHandler {
    public static final SetRestrictedField<BiConsumer<Level, BlockPos>> SOLIDIFY_CONCRETE_POWDER = SetRestrictedField.common();
    public static List<Pair<TagKey<Fluid>, ChemthrowerEffect>> effectList = new ArrayList<Pair<TagKey<Fluid>, ChemthrowerEffect>>();
    public static HashSet<TagKey<Fluid>> flammableList = new HashSet();

    public static void registerEffect(TagKey<Fluid> fluidTag, ChemthrowerEffect effect) {
        effectList.add((Pair<TagKey<Fluid>, ChemthrowerEffect>)Pair.of(fluidTag, (Object)effect));
    }

    public static ChemthrowerEffect getEffect(Fluid fluid) {
        if (fluid != null) {
            for (Pair<TagKey<Fluid>, ChemthrowerEffect> entry : effectList) {
                if (!fluid.is((TagKey)entry.getFirst())) continue;
                return (ChemthrowerEffect)entry.getSecond();
            }
        }
        return null;
    }

    public static void registerFlammable(TagKey<Fluid> fluidTag) {
        flammableList.add(fluidTag);
    }

    public static boolean isFlammable(Fluid fluid) {
        if (fluid != null) {
            for (TagKey<Fluid> predicate : flammableList) {
                if (!fluid.is(predicate)) continue;
                return true;
            }
        }
        return false;
    }

    public static abstract class ChemthrowerEffect {
        public void applyToEntity(LivingEntity target, @Nullable Player shooter, ItemStack thrower, FluidStack fluid) {
            this.applyToEntity(target, shooter, thrower, fluid.getFluid());
        }

        public abstract void applyToEntity(LivingEntity var1, @Nullable Player var2, ItemStack var3, Fluid var4);

        public void applyToBlock(Level world, HitResult mop, @Nullable Player shooter, ItemStack thrower, FluidStack fluid) {
            this.applyToBlock(world, mop, shooter, thrower, fluid.getFluid());
        }

        public abstract void applyToBlock(Level var1, HitResult var2, @Nullable Player var3, ItemStack var4, Fluid var5);
    }

    public static class ChemthrowerEffect_RandomTeleport
    extends ChemthrowerEffect_Damage {
        float chance;

        public ChemthrowerEffect_RandomTeleport(DamageSource source, float damage, float chance) {
            super(source, damage);
            this.chance = chance;
        }

        @Override
        public void applyToEntity(LivingEntity target, Player shooter, ItemStack thrower, Fluid fluid) {
            super.applyToEntity(target, shooter, thrower, fluid);
            if (ApiUtils.RANDOM.nextFloat() < this.chance) {
                double x = target.getX() - 8.0 + (double)ApiUtils.RANDOM.nextInt(17);
                double y = target.getY() + (double)ApiUtils.RANDOM.nextInt(8);
                double z = target.getZ() - 8.0 + (double)ApiUtils.RANDOM.nextInt(17);
                if (!target.level().getBlockState(BlockPos.containing((double)x, (double)y, (double)z)).isSolid()) {
                    EntityTeleportEvent.EnderEntity event = new EntityTeleportEvent.EnderEntity(target, x, y, z);
                    if (((EntityTeleportEvent)NeoForge.EVENT_BUS.post((Event)event)).isCanceled()) {
                        return;
                    }
                    target.teleportTo(event.getTargetX(), event.getTargetY(), event.getTargetZ());
                    target.level().playLocalSound(target.getX(), target.getY(), target.getZ(), SoundEvents.ENDERMAN_TELEPORT, SoundSource.PLAYERS, 1.0f, 1.0f, false);
                }
            }
        }
    }

    public static class ChemthrowerEffect_Extinguish
    extends ChemthrowerEffect {
        private static DamageSource getPlayerDrownDamage(Player player, DamageSources sources) {
            DamageSource drownSource = sources.drown();
            if (player == null) {
                return drownSource;
            }
            return new DamageSource(drownSource.typeHolder(), (Entity)player);
        }

        @Override
        public void applyToEntity(LivingEntity target, @Nullable Player shooter, ItemStack thrower, Fluid fluid) {
            if (target.isOnFire()) {
                target.clearFire();
            }
            if ((target instanceof Blaze || target instanceof EnderMan) && target.hurt(ChemthrowerEffect_Extinguish.getPlayerDrownDamage(shooter, target.damageSources()), 3.0f)) {
                target.invulnerableTime = (int)((double)target.invulnerableTime * 0.75);
            }
        }

        @Override
        public void applyToBlock(Level world, HitResult mop, @Nullable Player shooter, ItemStack thrower, Fluid fluid) {
            if (!(mop instanceof BlockHitResult)) {
                return;
            }
            BlockHitResult rtr = (BlockHitResult)mop;
            BlockPos pos = rtr.getBlockPos();
            SOLIDIFY_CONCRETE_POWDER.get().accept(world, pos);
            pos = rtr.getBlockPos().relative(rtr.getDirection());
            Block b = world.getBlockState(pos).getBlock();
            if (b instanceof FireBlock) {
                world.removeBlock(pos, false);
            }
        }
    }

    public static class ChemthrowerEffect_Potion
    extends ChemthrowerEffect_Damage {
        MobEffectInstance[] potionEffects;
        float[] effectChances;

        public ChemthrowerEffect_Potion(DamageSource source, float damage, MobEffectInstance ... effects) {
            super(source, damage);
            this.potionEffects = effects;
            this.effectChances = new float[this.potionEffects.length];
            Arrays.fill(this.effectChances, 1.0f);
        }

        public ChemthrowerEffect_Potion(DamageSource source, float damage, Holder<MobEffect> potion, int duration, int amplifier) {
            this(source, damage, new MobEffectInstance(potion, duration, amplifier));
        }

        public ChemthrowerEffect_Potion setEffectChance(int effectIndex, float chance) {
            if (effectIndex >= 0 && effectIndex < this.effectChances.length) {
                this.effectChances[effectIndex] = chance;
            }
            return this;
        }

        @Override
        public void applyToEntity(LivingEntity target, @Nullable Player shooter, ItemStack thrower, Fluid fluid) {
            super.applyToEntity(target, shooter, thrower, fluid);
            if (this.potionEffects != null && this.potionEffects.length > 0) {
                for (int iEffect = 0; iEffect < this.potionEffects.length; ++iEffect) {
                    if (!(target.getRandom().nextFloat() < this.effectChances[iEffect])) continue;
                    MobEffectInstance e = this.potionEffects[iEffect];
                    MobEffectInstance newEffect = new MobEffectInstance(e.getEffect(), e.getDuration(), e.getAmplifier());
                    target.addEffect(newEffect);
                }
            }
        }
    }

    public static class ChemthrowerEffect_Damage
    extends ChemthrowerEffect {
        DamageSource source;
        float damage;

        public ChemthrowerEffect_Damage(DamageSource source, float damage) {
            this.source = source;
            this.damage = damage;
        }

        @Override
        public void applyToEntity(LivingEntity target, @Nullable Player shooter, ItemStack thrower, Fluid fluid) {
            if (this.source != null && target.hurt(this.source, this.damage)) {
                target.invulnerableTime = (int)((double)target.invulnerableTime * 0.75);
                if (this.source.is(DamageTypeTags.IS_FIRE) && !target.fireImmune()) {
                    target.igniteForSeconds(fluid.is(Tags.Fluids.GASEOUS) ? 2.0f : 5.0f);
                }
            }
        }

        @Override
        public void applyToBlock(Level world, HitResult mop, @Nullable Player shooter, ItemStack thrower, Fluid fluid) {
        }
    }
}

