/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.shader.impl;

import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.api.shader.ShaderCase;
import blusunrize.immersiveengineering.api.shader.ShaderLayer;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.vehicle.AbstractMinecart;

public class ShaderCaseMinecart
extends ShaderCase {
    public static Set<Class<? extends AbstractMinecart>> invalidMinecartClasses = new HashSet<Class<? extends AbstractMinecart>>();
    public boolean[][] renderSides;
    public boolean[] mirrorSideForPass;

    public ShaderCaseMinecart(ShaderLayer ... layers) {
        super(layers);
        this.initBooleans();
    }

    public ShaderCaseMinecart(Collection<ShaderLayer> layers) {
        super(layers);
        this.initBooleans();
    }

    @Override
    public ShaderCase addLayers(ShaderLayer ... addedLayers) {
        ShaderCase sCase = super.addLayers(addedLayers);
        this.initBooleans();
        return sCase;
    }

    private void initBooleans() {
        this.mirrorSideForPass = new boolean[this.getLayers().length];
        this.renderSides = new boolean[this.getLayers().length][7];
        for (int i = 0; i < this.mirrorSideForPass.length; ++i) {
            this.mirrorSideForPass[i] = true;
            for (int j = 0; j < 7; ++j) {
                this.renderSides[i][j] = true;
            }
        }
    }

    @Override
    public ResourceLocation getShaderType() {
        return IEApi.ieLoc("minecart");
    }

    @Override
    public int getLayerInsertionIndex() {
        return this.layers.length - 1;
    }

    @Override
    public boolean stitchIntoSheet() {
        return false;
    }

    @Override
    public boolean shouldRenderGroupForPass(String modelPart, int pass) {
        return this.renderSides[pass][Integer.parseInt(modelPart)];
    }
}

