/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.crafting;

import blusunrize.immersiveengineering.api.crafting.TagOutput;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.List;
import malte0811.dualcodecs.DualCodec;
import malte0811.dualcodecs.DualCodecs;
import malte0811.dualcodecs.DualCompositeCodecs;
import malte0811.dualcodecs.DualMapCodec;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.conditions.ICondition;

public record StackWithChance(TagOutput stack, float chance, List<ICondition> conditions) {
    public static final DualCodec<RegistryFriendlyByteBuf, StackWithChance> CODECS = DualCompositeCodecs.composite((DualMapCodec)TagOutput.CODECS.fieldOf("output"), StackWithChance::stack, (DualMapCodec)DualCodecs.FLOAT.fieldOf("chance"), StackWithChance::chance, (x$0, x$1) -> new StackWithChance((TagOutput)x$0, (float)x$1, new ICondition[0]));
    public static final StreamCodec<RegistryFriendlyByteBuf, List<StackWithChance>> STREAM_LIST = CODECS.streamCodec().apply(ByteBufCodecs.list());

    public StackWithChance {
        Preconditions.checkNotNull((Object)stack);
    }

    public StackWithChance(ItemStack stack, float chance) {
        this(new TagOutput(stack), chance, List.of());
    }

    public StackWithChance(TagOutput stack, float chance, ICondition ... conditions) {
        this(stack, chance, Arrays.asList(conditions));
    }

    public CompoundTag writeToNBT(HolderLookup.Provider provider) {
        CompoundTag compoundNBT = new CompoundTag();
        compoundNBT.put("stack", this.stack.get().save(provider));
        compoundNBT.putFloat("chance", this.chance);
        return compoundNBT;
    }

    public static StackWithChance readFromNBT(HolderLookup.Provider provider, CompoundTag compoundNBT) {
        Preconditions.checkNotNull((Object)compoundNBT);
        Preconditions.checkArgument((boolean)compoundNBT.contains("chance"));
        Preconditions.checkArgument((boolean)compoundNBT.contains("stack"));
        ItemStack stack = (ItemStack)ItemStack.parse((HolderLookup.Provider)provider, (Tag)compoundNBT.getCompound("stack")).orElseThrow();
        float chance = compoundNBT.getFloat("chance");
        return new StackWithChance(stack, chance);
    }

    public StackWithChance recalculate(double totalChance) {
        return new StackWithChance(this.stack, (float)((double)this.chance / totalChance), this.conditions);
    }
}

