/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.platform.recipes.crafting;

import com.google.gson.JsonObject;
import ic2.api.recipes.ingridients.generators.IOutputGenerator;
import ic2.core.platform.recipes.crafting.IC2RecipeSerializer;
import ic2.core.platform.recipes.misc.IngredientRegistry;
import ic2.core.platform.recipes.mods.IRecipeModifier;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;

public abstract class RecipeIC2Base
implements CraftingRecipe {
    protected ResourceLocation id;
    protected ItemStack output;
    protected IRecipeModifier mod;
    public boolean hidden;
    protected boolean consume;
    String group;

    public RecipeIC2Base(ResourceLocation id, ItemStack output, boolean hidden, boolean consume, IRecipeModifier mod) {
        this.id = id;
        this.output = output;
        this.mod = mod;
        this.hidden = hidden;
        this.consume = consume;
        this.group = output.m_41778_();
    }

    public RecipeIC2Base setCustomGroup(String group) {
        this.group = group;
        return this;
    }

    public String m_6076_() {
        return this.group;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public ItemStack m_8043_() {
        if (this.mod != null) {
            return this.mod.applyChanges(this.output, true);
        }
        return this.output.m_41777_();
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return IC2RecipeSerializer.INSTANCE;
    }

    public boolean canBeDrained(ItemStack stack) {
        return !this.consume && stack.hasCraftingRemainingItem();
    }

    public abstract ResourceLocation getMetaSerializer();

    public abstract void serialize(FriendlyByteBuf var1);

    public abstract JsonObject serialize();

    public abstract NonNullList<Ingredient> m_7527_();

    protected static Tuple<ItemStack, IOutputGenerator> generateOutput(JsonObject output) {
        IOutputGenerator generator = IngredientRegistry.INSTANCE.readOutputGenerator(output);
        Tuple result = new Tuple((Object)ItemStack.f_41583_, (Object)generator);
        generator.addItems(arg_0 -> ((Tuple)result).m_145023_(arg_0));
        return result;
    }
}

