/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.reactor.planner;

import ic2.api.reactor.IReactorPlannerComponent;
import ic2.api.reactor.planner.BaseHeatSimulatedStack;
import ic2.api.reactor.planner.ISimulatedReactor;
import ic2.api.reactor.planner.SimulatedStack;
import ic2.core.item.reactor.base.ExchangerProperty;
import ic2.core.item.reactor.planner.SimulatedCoord;
import ic2.core.utils.collection.CollectionUtils;
import ic2.core.utils.math.geometry.Vec2i;
import java.util.List;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;

public class SimulatedHeatBalancer
extends BaseHeatSimulatedStack {
    ExchangerProperty property;

    public SimulatedHeatBalancer(ExchangerProperty property) {
        super(property.getComponentID(), property.getHeatStorage());
        this.property = property;
    }

    @Override
    public ItemStack syncStack(ItemStack original) {
        original.m_41721_(this.heat);
        return original;
    }

    @Override
    public void simulate(ISimulatedReactor reactor, int x, int y, boolean heatTick, boolean damageTick) {
        int side = this.property.getSelf();
        int react = this.property.getReactor();
        int myHeat = 0;
        int storedHeat = this.getStoredHeat(reactor, x, y);
        int maxHeat = this.getMaxStoredHeat(reactor, x, y);
        double med = (double)storedHeat / (double)maxHeat;
        if (side > 0) {
            List<Vec2i> offsets = this.property.getOffsets();
            int m = offsets.size();
            for (int i = 0; i < m; ++i) {
                Vec2i pos = offsets.get(i);
                SimulatedCoord.SimulatedDirCoord coord = this.checkRate(reactor, x + pos.getX(), y + pos.getY());
                int myCurrentHeat = storedHeat + myHeat;
                if (coord == null) continue;
                int add = Mth.m_14045_((int)coord.getTransferRate(reactor, (coord.average() + med) * 0.5), (int)(-side), (int)Math.min(side, myCurrentHeat));
                myHeat -= add;
                myHeat += coord.storeHeat(reactor, add);
            }
        }
        if (react > 0) {
            int myCurrentHeat = storedHeat + myHeat;
            double average = (double)reactor.getHeat() / (double)reactor.getMaxHeat();
            if (average <= 0.25 || average >= 0.75) {
                average = ((average >= 0.75 ? average - 0.75 : average) * 4.0 + med) * 0.5;
                int add = Mth.m_14045_((int)((int)(average * (double)reactor.getMaxHeat() - (double)reactor.getHeat())), (int)(-react), (int)Math.min(react, myCurrentHeat));
                myHeat -= add;
                reactor.setHeat(reactor.getHeat() + add);
            }
        }
        this.storeHeat(reactor, x, y, myHeat);
    }

    private SimulatedCoord.SimulatedDirCoord checkRate(ISimulatedReactor reactor, int x, int y) {
        SimulatedStack comp = reactor.getItem(x, y);
        if (comp != null && comp.canStoreHeat(reactor, x, y)) {
            double max = comp.getMaxStoredHeat(reactor, x, y);
            if (max <= 0.0) {
                return null;
            }
            double average = (double)comp.getStoredHeat(reactor, x, y) / max;
            if (average <= 0.25) {
                return new SimulatedCoord.SimulatedDirCoord(comp, x, y, true, average * 4.0);
            }
            if (average >= 0.75) {
                return new SimulatedCoord.SimulatedDirCoord(comp, x, y, false, (average - 0.75) * 4.0);
            }
        }
        return null;
    }

    @Override
    public List<IReactorPlannerComponent.ReactorStat> getStats() {
        return CollectionUtils.asList(IReactorPlannerComponent.ReactorStat.REACTOR_BALANCING, IReactorPlannerComponent.ReactorStat.PART_BALANCING);
    }

    @Override
    public IReactorPlannerComponent.ReactorType getValidType() {
        return IReactorPlannerComponent.ReactorType.UNIVERSAL;
    }

    @Override
    public IReactorPlannerComponent.ComponentType getComponentType() {
        return IReactorPlannerComponent.ComponentType.HEAT_EXCHANGER;
    }

    @Override
    public NumericTag getStat(IReactorPlannerComponent.ReactorStat stat) {
        if (stat == IReactorPlannerComponent.ReactorStat.REACTOR_BALANCING) {
            return IntTag.m_128679_((int)this.property.getReactor());
        }
        if (stat == IReactorPlannerComponent.ReactorStat.PART_BALANCING) {
            return IntTag.m_128679_((int)this.property.getSelf());
        }
        return NULL_VALUE;
    }
}

