/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.reactor;

import ic2.api.reactor.IReactor;
import ic2.api.reactor.IReactorComponent;
import ic2.api.reactor.IReactorPlannerComponent;
import ic2.api.reactor.planner.SimulatedStack;
import ic2.core.item.base.PropertiesBuilder;
import ic2.core.item.reactor.base.ExchangerProperty;
import ic2.core.item.reactor.base.ItemStackCoord;
import ic2.core.item.reactor.base.ReactorHeatStorageBase;
import ic2.core.item.reactor.planner.SimulatedHeatBalancer;
import ic2.core.utils.collection.CollectionUtils;
import ic2.core.utils.math.geometry.Vec2i;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.util.List;
import java.util.function.BiPredicate;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;

public class ReactorHeatBalancerItem
extends ReactorHeatStorageBase {
    ExchangerProperty prop;

    public ReactorHeatBalancerItem(String name, ExchangerProperty prop) {
        super(name, prop.getTextureFolder(), prop.getTextureName(), new PropertiesBuilder().maxDamage(prop.getHeatStorage()));
        this.prop = prop;
    }

    public ReactorHeatBalancerItem(String name, PropertiesBuilder properties, ExchangerProperty prop) {
        super(name, prop.getTextureFolder(), prop.getTextureName(), (properties == null ? new PropertiesBuilder() : properties).maxDamage(prop.getHeatStorage()));
        this.prop = prop;
    }

    @Override
    public void processChamber(ItemStack stack, IReactor reactor, int x, int y, boolean heatCalculation, boolean damageTick) {
        int side = this.prop.getSelf();
        int react = this.prop.getReactor();
        int myHeat = 0;
        int storedHeat = this.getStoredHeat(stack, reactor, x, y);
        int maxHeat = this.getMaxStoredHeat(stack, reactor, x, y);
        double med = (double)storedHeat / (double)maxHeat;
        if (side > 0) {
            List<Vec2i> offsets = this.prop.getOffsets();
            int m = offsets.size();
            for (int i = 0; i < m; ++i) {
                Vec2i pos = offsets.get(i);
                ItemStackCoord.ItemStackDirCoord coord = this.checkRate(reactor, x + pos.getX(), y + pos.getY());
                int myCurrentHeat = storedHeat + myHeat;
                if (coord == null) continue;
                IReactorComponent heatable = (IReactorComponent)coord.stack.m_41720_();
                int add = Mth.m_14045_((int)coord.getTransferRate(heatable, reactor, (coord.average() + med) * 0.5), (int)(-side), (int)Math.min(side, myCurrentHeat));
                myHeat -= add;
                myHeat += coord.storeHeat(heatable, reactor, add);
            }
        }
        if (react > 0) {
            int myCurrentHeat = storedHeat + myHeat;
            double average = (double)reactor.getHeat() / (double)reactor.getMaxHeat();
            if (average <= 0.25 || average >= 0.75) {
                average = ((average >= 0.75 ? average - 0.75 : average) * 4.0 + med) * 0.5;
                int add = Mth.m_14045_((int)((int)(average * (double)reactor.getMaxHeat() - (double)reactor.getHeat())), (int)(-react), (int)Math.min(react, myCurrentHeat));
                myHeat -= add;
                reactor.setHeat(reactor.getHeat() + add);
            }
        }
        this.storeHeat(stack, reactor, x, y, myHeat);
    }

    private ItemStackCoord.ItemStackDirCoord checkRate(IReactor reactor, int x, int y) {
        IReactorComponent comp;
        ItemStack thing = reactor.getStackInReactor(x, y);
        if (thing.m_41720_() instanceof IReactorComponent && (comp = (IReactorComponent)thing.m_41720_()).canStoreHeat(thing, reactor, x, y)) {
            double max = comp.getMaxStoredHeat(thing, reactor, x, y);
            if (max <= 0.0) {
                return null;
            }
            double average = (double)comp.getStoredHeat(thing, reactor, x, y) / max;
            if (average <= 0.25) {
                return new ItemStackCoord.ItemStackDirCoord(thing, x, y, true, average * 4.0);
            }
            if (average >= 0.75) {
                return new ItemStackCoord.ItemStackDirCoord(thing, x, y, false, (average - 0.75) * 4.0);
            }
        }
        return null;
    }

    @Override
    public void addAffectedSlots(int x, int y, BiPredicate<Integer, Integer> slots) {
        slots.test(x, y);
        if (this.prop.getSelf() > 0) {
            slots.test(x + 1, y);
            slots.test(x - 1, y);
            slots.test(x, y + 1);
            slots.test(x, y - 1);
        }
    }

    @Override
    public SimulatedStack createSimulationComponent(ItemStack self) {
        return new SimulatedHeatBalancer(this.prop);
    }

    @Override
    public short getComponentID(ItemStack stack) {
        return this.prop.getComponentID();
    }

    @Override
    public IReactorPlannerComponent.ReactorType getSupportedReactor(ItemStack stack) {
        return IReactorPlannerComponent.ReactorType.UNIVERSAL;
    }

    @Override
    public IReactorPlannerComponent.ComponentType getType(ItemStack stack) {
        return IReactorPlannerComponent.ComponentType.HEAT_EXCHANGER;
    }

    @Override
    public List<IReactorPlannerComponent.ReactorStat> getStats(ItemStack stack) {
        ObjectList list = CollectionUtils.createList();
        list.add((IReactorPlannerComponent.ReactorStat)IReactorPlannerComponent.ReactorStat.REACTOR_BALANCING);
        list.add((IReactorPlannerComponent.ReactorStat)IReactorPlannerComponent.ReactorStat.PART_BALANCING);
        return list;
    }

    @Override
    public NumericTag getReactorStat(IReactorPlannerComponent.ReactorStat stat, ItemStack stack) {
        if (stat == IReactorPlannerComponent.ReactorStat.REACTOR_BALANCING) {
            return IntTag.m_128679_((int)this.prop.getReactor());
        }
        if (stat == IReactorPlannerComponent.ReactorStat.PART_BALANCING) {
            return IntTag.m_128679_((int)this.prop.getSelf());
        }
        return NULL_VALUE;
    }
}

