/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.menu;

import info.u_team.u_team_core.api.block.MenuSyncedBlockEntity;
import info.u_team.u_team_core.menu.UContainerMenu;
import info.u_team.u_team_core.util.CastUtil;
import io.netty.buffer.Unpooled;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.LogicalSide;

public abstract class UBlockEntityContainerMenu<T extends BlockEntity>
extends UContainerMenu {
    protected final Inventory playerInventory;
    protected final T blockEntity;

    public UBlockEntityContainerMenu(MenuType<?> menuType, int containerId, Inventory playerInventory, T blockEntity) {
        this(menuType, containerId, playerInventory, blockEntity, true);
    }

    public UBlockEntityContainerMenu(MenuType<?> menuType, int containerId, Inventory playerInventory, T blockEntity, boolean callInit) {
        super(menuType, containerId);
        this.playerInventory = playerInventory;
        this.blockEntity = blockEntity;
        if (callInit) {
            this.init(LogicalSide.SERVER);
        }
    }

    public UBlockEntityContainerMenu(MenuType<?> menuType, int containerId, Inventory playerInventory, FriendlyByteBuf byteBuf) {
        this(menuType, containerId, playerInventory, byteBuf, true);
    }

    public UBlockEntityContainerMenu(MenuType<?> menuType, int containerId, Inventory playerInventory, FriendlyByteBuf byteBuf, boolean callInit) {
        super(menuType, containerId);
        this.playerInventory = playerInventory;
        T t = this.blockEntity = this.getClientTileEntity(byteBuf);
        if (t instanceof MenuSyncedBlockEntity) {
            MenuSyncedBlockEntity syncedBlockEntity = (MenuSyncedBlockEntity)t;
            FriendlyByteBuf data = new FriendlyByteBuf(Unpooled.wrappedBuffer((byte[])byteBuf.m_130101_(32592)));
            syncedBlockEntity.handleInitialMenuDataFromServer(data);
            data.release();
        }
        if (callInit) {
            this.init(LogicalSide.CLIENT);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private T getClientTileEntity(FriendlyByteBuf byteBuf) {
        BlockPos pos = byteBuf.m_130135_();
        BlockEntity blockEntity = Minecraft.m_91087_().f_91073_.m_7702_(pos);
        if (blockEntity == null) {
            throw new IllegalStateException("The client block entity at (" + pos.m_123344_() + ") does not exists.");
        }
        return (T)((BlockEntity)CastUtil.uncheckedCast(blockEntity));
    }

    protected abstract void init(LogicalSide var1);

    public T getBlockEntity() {
        return this.blockEntity;
    }
}

