/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.gui.elements;

import com.mojang.blaze3d.vertex.PoseStack;
import info.u_team.u_team_core.gui.elements.UButton;
import info.u_team.u_team_core.util.RenderUtil;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;

public class CheckboxButton
extends UButton {
    protected static final ResourceLocation TEXTURE = new ResourceLocation("textures/gui/checkbox.png");
    protected boolean checked;
    protected boolean drawText;
    protected boolean leftSideText;
    protected boolean dropShadow;

    public CheckboxButton(int x, int y, int width, int height, Component text, boolean checked, boolean drawText) {
        this(x, y, width, height, text, checked, drawText, EMTPY_PRESSABLE);
    }

    public CheckboxButton(int x, int y, int width, int height, Component text, boolean checked, boolean drawText, Button.OnPress pessable) {
        this(x, y, width, height, text, checked, drawText, pessable, EMPTY_TOOLTIP);
    }

    public CheckboxButton(int x, int y, int width, int height, Component text, boolean checked, boolean drawText, Button.OnTooltip tooltip) {
        this(x, y, width, height, text, checked, drawText, EMTPY_PRESSABLE, tooltip);
    }

    public CheckboxButton(int x, int y, int width, int height, Component text, boolean checked, boolean drawText, Button.OnPress pessable, Button.OnTooltip tooltip) {
        super(x, y, width, height, text, pessable, tooltip);
        this.checked = checked;
        this.drawText = drawText;
        this.leftSideText = false;
        this.dropShadow = false;
    }

    public boolean isChecked() {
        return this.checked;
    }

    public void setChecked(boolean checked) {
        this.checked = checked;
    }

    public boolean isDrawText() {
        return this.drawText;
    }

    public void setDrawText(boolean drawText) {
        this.drawText = drawText;
    }

    public boolean isLeftSideText() {
        return this.leftSideText;
    }

    public void setLeftSideText(boolean leftSideText) {
        this.leftSideText = leftSideText;
    }

    public void toggle() {
        this.checked = !this.checked;
    }

    public void m_5691_() {
        this.toggle();
        super.m_5691_();
    }

    @Override
    public void m_6303_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        RenderUtil.drawTexturedQuad(poseStack, this.f_93620_, this.f_93621_, this.f_93618_, this.f_93619_, 20, 20, this.m_198029_() ? 20.0f : 0.0f, this.checked ? 20.0f : 0.0f, 64, 64, 0.0f, TEXTURE, this.getCurrentBackgroundColor(poseStack, mouseX, mouseY, partialTicks));
        this.renderBackground(poseStack, mouseX, mouseY, partialTicks);
        this.renderForeground(poseStack, mouseX, mouseY, partialTicks);
    }

    @Override
    public void renderForeground(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        if (this.drawText) {
            Font font = this.getCurrentTextFont();
            Component message = this.getCurrentText();
            if (message != CommonComponents.f_237098_) {
                float yStart = this.f_93621_ + (this.f_93619_ - 8) / 2;
                float xStart = this.leftSideText ? (float)(this.f_93620_ - (font.m_92852_((FormattedText)message) + 4)) : (float)(this.f_93620_ + this.f_93618_ + 4);
                int color = this.getCurrentTextColor(poseStack, mouseX, mouseY, partialTicks).getColorARGB();
                if (this.dropShadow) {
                    font.m_92763_(poseStack, this.getCurrentText(), xStart, yStart, color);
                } else {
                    font.m_92889_(poseStack, this.getCurrentText(), xStart, yStart, color);
                }
            }
        }
    }
}

