/*
 * Decompiled with CFR 0.152.
 */
package com.chirptheboy.disenchanting.block.disenchant;

import com.chirptheboy.disenchanting.block.disenchant.DisenchantOutputSlot;
import com.chirptheboy.disenchanting.block.disenchant.TileDisenchant;
import com.chirptheboy.disenchanting.data.DataTags;
import com.chirptheboy.disenchanting.gui.ContainerBase;
import com.chirptheboy.disenchanting.registry.BlockRegistry;
import com.chirptheboy.disenchanting.registry.MenuRegistry;
import com.google.common.collect.ImmutableMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.tags.ITagManager;

public class ContainerDisenchant
extends ContainerBase {
    protected TileDisenchant tile;
    public static double RARITY_MULTIPLIER = 0.03f;
    public static double RARITY_OFFSET = 1.8f;

    public ContainerDisenchant(int windowId, Level world, BlockPos pos, Inventory playerInventory, Player player) {
        super((MenuType)MenuRegistry.DISENCHANTER.get(), windowId);
        this.tile = (TileDisenchant)world.m_7702_(pos);
        this.playerEntity = player;
        this.playerInventory = playerInventory;
        this.trackAllIntFields(this.tile, TileDisenchant.Fields.values().length);
        ItemStackHandler inputSlots = this.tile.inputSlots;
        ItemStackHandler outputSlots = this.tile.outputSlots;
        this.endInv = inputSlots.getSlots() + outputSlots.getSlots();
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)inputSlots, 0, 29, 25){

            public void m_6654_() {
                ContainerDisenchant.this.createOutputItem();
                ContainerDisenchant.this.tile.m_6596_();
            }
        });
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)inputSlots, 1, 83, 25){

            public void m_6654_() {
                ContainerDisenchant.this.createOutputItem();
                ContainerDisenchant.this.tile.m_6596_();
            }
        });
        this.m_38897_((Slot)new DisenchantOutputSlot((IItemHandler)outputSlots, 0, 137, 25){

            public void m_142406_(Player player, ItemStack itemStack) {
                ContainerDisenchant.this.disenchantItem(player, itemStack);
                ContainerDisenchant.this.tile.m_6596_();
                ContainerDisenchant.this.createOutputItem();
            }

            public void m_6654_() {
                ContainerDisenchant.this.tile.m_6596_();
            }
        });
        this.layoutPlayerInventorySlots(11, 71);
        this.trackAllIntFields(this.tile, TileDisenchant.Fields.values().length);
    }

    public void disenchantItem(Player player, ItemStack itemEnchantedBook) {
        ItemStack inputEnchantedItem = this.tile.inputSlots.getStackInSlot(0);
        if (((Boolean)TileDisenchant.REQUIRES_EXPERIENCE.get()).booleanValue() && !player.m_7500_()) {
            player.m_6749_(-this.tile.getCost());
        }
        Enchantment enchantmentToRemove = this.getEnchantmentFromItem(itemEnchantedBook);
        Map enchantmentMap = EnchantmentHelper.m_44831_((ItemStack)this.tile.inputSlots.getStackInSlot(0));
        enchantmentMap.remove(enchantmentToRemove);
        ItemStack outputItem = (Boolean)TileDisenchant.RESET_ANVIL_COST.get() != false ? new ItemStack((ItemLike)inputEnchantedItem.m_41720_()) : inputEnchantedItem.m_41777_();
        EnchantmentHelper.m_44865_((Map)enchantmentMap, (ItemStack)outputItem);
        if (outputItem.m_150930_(Items.f_42690_)) {
            if (enchantmentMap.size() == 0) {
                outputItem = new ItemStack((ItemLike)Items.f_42517_);
            } else {
                outputItem = new ItemStack((ItemLike)Items.f_42690_);
                EnchantmentHelper.m_44865_((Map)enchantmentMap, (ItemStack)outputItem);
            }
        }
        BlockPos p = this.tile.m_58899_();
        this.tile.m_58904_().m_7785_((double)p.m_123341_(), (double)p.m_123342_(), (double)p.m_123343_(), SoundEvents.f_11887_, SoundSource.BLOCKS, 1.0f, 1.25f, false);
        this.tile.inputSlots.setStackInSlot(0, outputItem);
        this.tile.inputSlots.extractItem(1, 1, false);
    }

    public void createOutputItem() {
        if (!this.playerEntity.f_19853_.m_5776_()) {
            ItemStack input = this.tile.inputSlots.getStackInSlot(0);
            ItemStack books = this.tile.inputSlots.getStackInSlot(1);
            ItemStack output = this.tile.outputSlots.getStackInSlot(0);
            if (this.isItemEnchanted(input).booleanValue() && books.m_150930_(Items.f_42517_)) {
                if (output.m_150930_(Items.f_41852_)) {
                    int selectedEnchantmentLevel = 0;
                    int cost = 0;
                    boolean hasEnoughXP = false;
                    Enchantment selectedEnchantment = this.getEnchantmentFromItem(input);
                    selectedEnchantmentLevel = this.getEnchantmentLevelFromItem(selectedEnchantment, input);
                    ITagManager tags = ForgeRegistries.ENCHANTMENTS.tags();
                    if (!tags.getTag(DataTags.BLACKLIST).contains((Object)selectedEnchantment)) {
                        this.tile.setField(TileDisenchant.Fields.BLACKLIST.ordinal(), 0);
                        if (((Boolean)TileDisenchant.REQUIRES_EXPERIENCE.get()).booleanValue() && !this.playerEntity.m_7500_()) {
                            int maxLevel;
                            int rarity = selectedEnchantment.m_44699_().m_44716_();
                            cost = (int)((RARITY_OFFSET - (double)rarity * RARITY_MULTIPLIER * (double)(selectedEnchantmentLevel / (maxLevel = selectedEnchantment.m_6586_()))) * (double)((Integer)TileDisenchant.COST_SLIDER.get()).intValue());
                            hasEnoughXP = this.playerEntity.f_36078_ >= cost;
                            this.tile.setField(TileDisenchant.Fields.COST.ordinal(), cost);
                            this.tile.setField(TileDisenchant.Fields.SHOWCOST.ordinal(), 1);
                        } else {
                            this.tile.setField(TileDisenchant.Fields.SHOWCOST.ordinal(), 0);
                        }
                        if (!((Boolean)TileDisenchant.REQUIRES_EXPERIENCE.get()).booleanValue() || ((Boolean)TileDisenchant.REQUIRES_EXPERIENCE.get()).booleanValue() && hasEnoughXP || this.playerEntity.m_7500_()) {
                            ItemStack enchantedBook = new ItemStack((ItemLike)Items.f_42690_);
                            EnchantmentHelper.m_44865_((Map)ImmutableMap.of((Object)selectedEnchantment, (Object)selectedEnchantmentLevel), (ItemStack)enchantedBook);
                            this.tile.outputSlots.setStackInSlot(0, enchantedBook);
                        }
                    } else {
                        this.tile.setField(TileDisenchant.Fields.BLACKLIST.ordinal(), 1);
                    }
                }
            } else {
                this.tile.outputSlots.setStackInSlot(0, ItemStack.f_41583_);
                this.tile.setField(TileDisenchant.Fields.BLACKLIST.ordinal(), 0);
                this.tile.setField(TileDisenchant.Fields.SHOWCOST.ordinal(), 0);
                this.tile.setField(TileDisenchant.Fields.COST.ordinal(), 0);
            }
        }
    }

    public Boolean isItemEnchanted(ItemStack itemStack) {
        Map enchants = EnchantmentHelper.m_44831_((ItemStack)itemStack);
        return enchants.size() > 0;
    }

    public int getEnchantmentLevelFromItem(Enchantment enchantment, ItemStack enchantedItem) {
        int selectedEnchantmentLevel = 0;
        Map enchantmentMap = EnchantmentHelper.m_44831_((ItemStack)enchantedItem);
        Iterator enchantmentIterator = enchantmentMap.entrySet().iterator();
        for (int loopCounter = 0; loopCounter < enchantmentMap.size(); ++loopCounter) {
            Map.Entry entry = enchantmentIterator.next();
            if (entry.getKey() != enchantment) continue;
            selectedEnchantmentLevel = (Integer)entry.getValue();
            break;
        }
        return selectedEnchantmentLevel;
    }

    public Enchantment getEnchantmentFromItem(ItemStack enchantedItem) {
        Enchantment selectedEnchantment = null;
        Map enchantmentMap = EnchantmentHelper.m_44831_((ItemStack)enchantedItem);
        int enchantmentNumber = (Boolean)TileDisenchant.RANDOM_ENCHANTMENT.get() != false ? ThreadLocalRandom.current().nextInt(0, enchantmentMap.size()) : 0;
        Iterator enchantmentIterator = enchantmentMap.entrySet().iterator();
        for (int loopCounter = 0; loopCounter <= enchantmentNumber; ++loopCounter) {
            Map.Entry entry = enchantmentIterator.next();
            if (loopCounter != enchantmentNumber) continue;
            selectedEnchantment = (Enchantment)entry.getKey();
            break;
        }
        return selectedEnchantment;
    }

    public boolean m_6875_(Player playerIn) {
        return ContainerDisenchant.m_38889_((ContainerLevelAccess)ContainerLevelAccess.m_39289_((Level)this.tile.m_58904_(), (BlockPos)this.tile.m_58899_()), (Player)this.playerEntity, (Block)((Block)BlockRegistry.DISENCHANTER.get()));
    }

    public ItemStack m_7648_(Player playerIn, int index) {
        try {
            ItemStack extractedItem = ((Slot)this.f_38839_.get(index)).m_7993_().m_41777_();
            int playerStart = this.endInv;
            int playerEnd = this.endInv + 36;
            ItemStack itemstack = ItemStack.f_41583_;
            Slot slot = (Slot)this.f_38839_.get(index);
            if (slot != null && slot.m_6657_()) {
                ItemStack stack = slot.m_7993_();
                itemstack = stack.m_41777_();
                if (index < this.endInv ? !this.m_38903_(stack, playerStart, playerEnd, false) : index <= playerEnd && !this.m_38903_(stack, this.startInv, this.endInv, false)) {
                    return ItemStack.f_41583_;
                }
                if (stack.m_41619_()) {
                    slot.m_5852_(ItemStack.f_41583_);
                    if (index == 2) {
                        this.disenchantItem(playerIn, extractedItem);
                    }
                } else {
                    slot.m_6654_();
                }
                if (stack.m_41613_() == itemstack.m_41613_()) {
                    return ItemStack.f_41583_;
                }
                slot.m_142406_(playerIn, stack);
            }
            return itemstack;
        }
        catch (Exception e) {
            return ItemStack.f_41583_;
        }
    }

    public void m_182410_(int someInt, List<ItemStack> itemStackList, ItemStack itemStack) {
        super.m_182410_(someInt, itemStackList, itemStack);
        this.createOutputItem();
    }
}

