/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class ForgeConfigFile {
    private File cfg;
    private HashMap<String, String> settings = new HashMap();
    public static final String ALLOWED_CHARS = "._-:";

    public ForgeConfigFile(File cfgfile) {
        this.cfg = cfgfile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean load() {
        this.settings.clear();
        FileInputStream fis = null;
        BufferedReader rdr = null;
        boolean rslt = true;
        try {
            String line;
            fis = new FileInputStream(this.cfg);
            rdr = new BufferedReader(new InputStreamReader((InputStream)fis, "UTF-8"));
            ArrayList<String> section = new ArrayList<String>();
            String tok = "";
            while ((line = rdr.readLine()) != null) {
                boolean skip = false;
                boolean instr = false;
                boolean intok = false;
                tok = "";
                int last_c = 32;
                int off = line.indexOf(": ");
                if (off > 0) {
                    line = line.substring(0, off).replace(' ', '_') + "=" + line.substring(off + 1);
                }
                for (int i = 0; i < line.length() && !skip; ++i) {
                    char c = line.charAt(i);
                    if (instr) {
                        if (c != '\"') {
                            tok = tok + c;
                        } else if (last_c != 34) {
                            instr = false;
                            intok = false;
                        }
                    } else if (c == '\"') {
                        if (last_c != 34) {
                            instr = true;
                            intok = true;
                        }
                    } else if (Character.isLetterOrDigit(c) || ALLOWED_CHARS.indexOf(c) != -1) {
                        if (intok) {
                            tok = tok + c;
                        } else {
                            tok = "" + c;
                            intok = true;
                        }
                    } else if (Character.isWhitespace(c)) {
                        if (!instr && intok) {
                            intok = false;
                        }
                    } else {
                        switch (line.charAt(i)) {
                            case '#': {
                                skip = true;
                                intok = false;
                                instr = false;
                                break;
                            }
                            case '{': {
                                if (tok.equals("")) break;
                                section.add(tok);
                                tok = "";
                                intok = false;
                                instr = false;
                                break;
                            }
                            case '}': {
                                if (section.size() <= 0) break;
                                section.remove(section.size() - 1);
                                break;
                            }
                            case '=': {
                                instr = false;
                                intok = false;
                                String propertyName = tok;
                                tok = "";
                                off = propertyName.indexOf(58);
                                if (off >= 0) {
                                    propertyName = propertyName.substring(off + 1);
                                }
                                for (int j = section.size() - 1; j >= 0; --j) {
                                    propertyName = (String)section.get(j) + "/" + propertyName;
                                }
                                propertyName = propertyName.replace(' ', '_');
                                this.settings.put(propertyName, line.substring(i + 1).trim());
                                skip = true;
                            }
                        }
                    }
                    last_c = c;
                }
            }
        }
        catch (IOException iox) {
            rslt = false;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
                fis = null;
            }
        }
        return rslt;
    }

    public int getBlockID(String id) {
        int idval = -1;
        String val = this.settings.get(id);
        if (val == null) {
            val = this.settings.get("block/" + id);
        }
        if (val != null && (val = val.trim()).length() > 0 && Character.isDigit(val.charAt(0))) {
            try {
                idval = (int)Double.parseDouble(val);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return idval;
    }

    public void addBlockIDs(Map<String, Integer> map) {
        for (String k : this.settings.keySet()) {
            if (k.startsWith("block/")) {
                map.put(k.substring("block/".length()), this.getBlockID(k));
                continue;
            }
            if (k.startsWith("blocks/")) {
                map.put(k.substring("blocks/".length()), this.getBlockID(k));
                continue;
            }
            if (k.startsWith("item/")) {
                map.put("item_" + k.substring("item/".length()), this.getBlockID(k));
                continue;
            }
            if (k.startsWith("walls/")) {
                map.put(k, this.getBlockID(k));
                continue;
            }
            if (k.startsWith("world/blocks/")) {
                map.put(k.substring("world/".length()), this.getBlockID(k));
                continue;
            }
            map.put(k, this.getBlockID(k));
        }
    }
}

