/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.hdmap;

import java.io.IOException;
import java.util.BitSet;
import java.util.List;
import org.dynmap.Color;
import org.dynmap.ConfigurationNode;
import org.dynmap.DynmapCore;
import org.dynmap.JSONUtils;
import org.dynmap.MapManager;
import org.dynmap.common.DynmapCommandSender;
import org.dynmap.exporter.OBJExport;
import org.dynmap.hdmap.HDLighting;
import org.dynmap.hdmap.HDMap;
import org.dynmap.hdmap.HDPerspectiveState;
import org.dynmap.hdmap.HDShader;
import org.dynmap.hdmap.HDShaderState;
import org.dynmap.json.simple.JSONObject;
import org.dynmap.renderer.DynmapBlockState;
import org.dynmap.utils.BlockStep;
import org.dynmap.utils.DynLongHashMap;
import org.dynmap.utils.MapChunkCache;
import org.dynmap.utils.MapIterator;

public class CaveHDShader
implements HDShader {
    private String name;
    private boolean iflit;
    private Color startColor;
    private Color endColor;
    private BitSet hiddenids = new BitSet();
    private static final String[] nulllist = new String[0];

    private void setHidden(DynmapBlockState blk) {
        this.hiddenids.set(blk.globalStateIndex);
    }

    private void setHidden(String blkname) {
        DynmapBlockState bbs = DynmapBlockState.getBaseStateByName(blkname);
        if (bbs.isNotAir()) {
            for (int i = 0; i < bbs.getStateCount(); ++i) {
                this.setHidden(bbs.getState(i));
            }
        }
    }

    private boolean isHidden(DynmapBlockState blk) {
        return this.hiddenids.get(blk.globalStateIndex);
    }

    public CaveHDShader(DynmapCore core, ConfigurationNode configuration) {
        this.name = (String)configuration.get("name");
        this.iflit = configuration.getBoolean("onlyiflit", false);
        this.startColor = configuration.getColor("startColor", null);
        this.endColor = configuration.getColor("endColor", null);
        for (int i = 0; i < DynmapBlockState.getGlobalIndexMax(); ++i) {
            DynmapBlockState bs = DynmapBlockState.getStateByGlobalIndex(i);
            if (!bs.isAir() && !bs.isWater()) continue;
            this.setHidden(bs);
        }
        List hidden = configuration.getList("hiddennames");
        if (hidden != null) {
            for (Object o : hidden) {
                if (!(o instanceof String)) continue;
                this.setHidden((String)o);
            }
        } else {
            this.setHidden(DynmapBlockState.LOG_BLOCK);
            this.setHidden(DynmapBlockState.LEAVES_BLOCK);
            this.setHidden(DynmapBlockState.GLASS_BLOCK);
            this.setHidden(DynmapBlockState.WOODEN_DOOR_BLOCK);
            this.setHidden(DynmapBlockState.IRON_DOOR_BLOCK);
            this.setHidden(DynmapBlockState.SNOW_BLOCK);
            this.setHidden(DynmapBlockState.ICE_BLOCK);
            this.setHidden(DynmapBlockState.SNOW_LAYER_BLOCK);
            for (int i = 0; i < DynmapBlockState.getGlobalIndexMax(); ++i) {
                DynmapBlockState bs = DynmapBlockState.getStateByGlobalIndex(i);
                if (!bs.isLeaves() && !bs.isSnow() && !bs.isLog()) continue;
                this.setHidden(bs);
            }
        }
    }

    @Override
    public boolean isBiomeDataNeeded() {
        return false;
    }

    @Override
    public boolean isRawBiomeDataNeeded() {
        return false;
    }

    @Override
    public boolean isHightestBlockYDataNeeded() {
        return false;
    }

    @Override
    public boolean isBlockTypeDataNeeded() {
        return true;
    }

    @Override
    public boolean isSkyLightLevelNeeded() {
        return false;
    }

    @Override
    public boolean isEmittedLightLevelNeeded() {
        return this.iflit;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public HDShaderState getStateInstance(HDMap map, MapChunkCache cache, MapIterator mapiter, int scale) {
        return new OurShaderState(mapiter, map, cache);
    }

    @Override
    public void addClientConfiguration(JSONObject mapObject) {
        JSONUtils.s(mapObject, "shader", this.name);
    }

    @Override
    public void exportAsMaterialLibrary(DynmapCommandSender sender, OBJExport out) throws IOException {
        throw new IOException("Export unsupported");
    }

    @Override
    public String[] getCurrentBlockMaterials(DynmapBlockState blk, MapIterator mapiter, int[] txtidx, BlockStep[] steps) {
        return nulllist;
    }

    private class OurShaderState
    implements HDShaderState {
        private Color color;
        protected MapIterator mapiter;
        protected HDMap map;
        private boolean air;
        private final int sealevel;
        private final int ymax;
        private final int ymin;
        final int[] lightingTable;

        private OurShaderState(MapIterator mapiter, HDMap map, MapChunkCache cache) {
            this.mapiter = mapiter;
            this.map = map;
            this.color = new Color();
            this.ymax = mapiter.getWorldHeight() - 1;
            this.ymin = mapiter.getWorldYMin();
            this.sealevel = mapiter.getWorldSeaLevel();
            this.lightingTable = (int[])(MapManager.mapman.useBrightnessTable() ? cache.getWorld().getBrightnessTable() : null);
        }

        @Override
        public HDShader getShader() {
            return CaveHDShader.this;
        }

        @Override
        public HDMap getMap() {
            return this.map;
        }

        @Override
        public HDLighting getLighting() {
            return this.map.getLighting();
        }

        @Override
        public void reset(HDPerspectiveState ps) {
            this.color.setTransparent();
            this.air = true;
        }

        @Override
        public boolean processBlock(HDPerspectiveState ps) {
            DynmapBlockState blocktype = ps.getBlockState();
            if (CaveHDShader.this.isHidden(blocktype)) {
                blocktype = DynmapBlockState.AIR;
            } else if (blocktype.isNotAir()) {
                this.air = false;
                return false;
            }
            if (blocktype.isAir() && !this.air) {
                int mult;
                int cb;
                int cg;
                int cr;
                if (CaveHDShader.this.iflit && ps.getMapIterator().getBlockEmittedLight() == 0) {
                    return false;
                }
                int y = this.mapiter.getY();
                if (CaveHDShader.this.startColor != null && CaveHDShader.this.endColor != null) {
                    double interp = (double)(y - this.ymin) / (double)(this.ymax - this.ymin);
                    cr = (int)((1.0 - interp) * (double)CaveHDShader.this.startColor.getRed() + interp * (double)CaveHDShader.this.endColor.getRed());
                    cg = (int)((1.0 - interp) * (double)CaveHDShader.this.startColor.getGreen() + interp * (double)CaveHDShader.this.endColor.getGreen());
                    cb = (int)((1.0 - interp) * (double)CaveHDShader.this.startColor.getBlue() + interp * (double)CaveHDShader.this.endColor.getBlue());
                } else if (y < this.sealevel) {
                    cr = 0;
                    cg = 64 + 192 * (y - this.ymin) / (this.sealevel - this.ymin);
                    cb = 255 - 255 * (y - this.ymin) / (this.sealevel - this.ymin);
                } else {
                    cr = 255 * (y - this.sealevel) / (this.ymax - this.sealevel);
                    cg = 255;
                    cb = 0;
                }
                switch (ps.getLastBlockStep()) {
                    case X_PLUS: 
                    case X_MINUS: {
                        mult = 224;
                        break;
                    }
                    case Z_PLUS: 
                    case Z_MINUS: {
                        mult = 256;
                        break;
                    }
                    default: {
                        mult = 160;
                    }
                }
                cr = cr * mult / 256;
                cg = cg * mult / 256;
                cb = cb * mult / 256;
                this.color.setRGBA(cr, cg, cb, 255);
                return true;
            }
            return false;
        }

        @Override
        public void rayFinished(HDPerspectiveState ps) {
        }

        @Override
        public void getRayColor(Color c, int index) {
            c.setColor(this.color);
        }

        @Override
        public void cleanup() {
        }

        @Override
        public DynLongHashMap getCTMTextureCache() {
            return null;
        }

        @Override
        public int[] getLightingTable() {
            return this.lightingTable;
        }

        @Override
        public void setLastBlockState(DynmapBlockState new_lastbs) {
        }
    }
}

