/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.useful_backpacks.menu;

import info.u_team.u_team_core.api.sync.DataHolder;
import info.u_team.u_team_core.api.sync.MessageHolder;
import info.u_team.u_team_core.menu.UContainerMenu;
import info.u_team.useful_backpacks.init.UsefulBackpacksMenuTypes;
import info.u_team.useful_backpacks.menu.slot.ItemFilterSlot;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class ItemFilterMenu
extends UContainerMenu {
    private final ItemStack filterStack;
    private final int selectedSlot;
    private boolean isStrict;
    private final Container filterItemSlotInventory = new SimpleContainer(1);
    private final MessageHolder strictMessage;

    public ItemFilterMenu(int id, Inventory playerInventory, FriendlyByteBuf buffer) {
        this(id, playerInventory, ItemStack.f_41583_, buffer.m_130242_(), buffer.readBoolean());
    }

    public ItemFilterMenu(int id, Inventory playerInventory, ItemStack filterStack, int selectedSlot, boolean isStrict) {
        super((MenuType)UsefulBackpacksMenuTypes.ITEM_FILTER.get(), id);
        this.filterStack = filterStack;
        this.selectedSlot = selectedSlot;
        this.isStrict = isStrict;
        CompoundTag compound = filterStack.m_41737_("stack");
        if (compound != null) {
            this.filterItemSlotInventory.m_6836_(0, ItemStack.m_41712_((CompoundTag)compound));
        }
        this.addSlots(this.filterItemSlotInventory, ItemFilterSlot::new, 1, 1, 17, 17);
        this.addPlayerInventory(playerInventory, 8, 48);
        this.strictMessage = (MessageHolder)this.addDataHolderToServer((DataHolder)new MessageHolder(buffer -> {
            boolean newIsStrict = buffer.readBoolean();
            if (!filterStack.m_41619_()) {
                if (!newIsStrict) {
                    filterStack.m_41749_("strict");
                } else {
                    filterStack.m_41784_().m_128379_("strict", newIsStrict);
                }
            }
        }));
    }

    public boolean m_6875_(Player player) {
        return true;
    }

    public void m_38946_() {
        if (!this.filterStack.m_41619_()) {
            ItemStack stackToFilter = this.filterItemSlotInventory.m_8020_(0);
            if (stackToFilter.m_41619_()) {
                this.filterStack.m_41749_("stack");
            } else {
                stackToFilter.m_41739_(this.filterStack.m_41698_("stack"));
            }
        }
        super.m_38946_();
    }

    public void m_150399_(int slotId, int dragType, ClickType clickType, Player player) {
        if (slotId == 0) {
            this.filterSlotClick(dragType, clickType, player);
            return;
        }
        Slot tmpSlot = slotId >= 0 && slotId < this.f_38839_.size() ? (Slot)this.f_38839_.get(slotId) : null;
        if (tmpSlot != null && tmpSlot.f_40218_ == player.m_150109_() && tmpSlot.getSlotIndex() == this.selectedSlot) {
            return;
        }
        if (clickType == ClickType.SWAP) {
            ItemStack currentItem;
            ItemStack stack = player.m_150109_().m_8020_(dragType);
            ItemStack itemStack = Inventory.m_36045_((int)this.selectedSlot) ? (ItemStack)player.m_150109_().f_35974_.get(this.selectedSlot) : (currentItem = this.selectedSlot == -1 ? (ItemStack)player.m_150109_().f_35976_.get(0) : ItemStack.f_41583_);
            if (!currentItem.m_41619_() && stack == currentItem) {
                return;
            }
        }
        super.m_150399_(slotId, dragType, clickType, player);
    }

    private ItemStack filterSlotClick(int dragType, ClickType clickType, Player player) {
        ItemStack stack;
        if (clickType == ClickType.THROW) {
            this.filterItemSlotInventory.m_6836_(0, ItemStack.f_41583_);
            stack = ItemStack.f_41583_;
        } else if (clickType == ClickType.PICKUP || clickType == ClickType.CLONE) {
            stack = this.m_142621_().m_41777_();
            stack.m_41764_(1);
            this.filterItemSlotInventory.m_6836_(0, stack);
        } else if (clickType == ClickType.SWAP) {
            stack = player.m_150109_().m_8020_(dragType).m_41777_();
            stack.m_41764_(1);
            this.filterItemSlotInventory.m_6836_(0, stack);
        } else {
            stack = ItemStack.f_41583_;
        }
        return stack;
    }

    public boolean isStrict() {
        return this.isStrict;
    }

    public void setStrict(boolean isStrict) {
        this.isStrict = isStrict;
    }

    public MessageHolder getStrictMessage() {
        return this.strictMessage;
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            if (index < 1) {
                return ItemStack.f_41583_;
            }
            ItemStack stack = itemstack1.m_41777_();
            stack.m_41764_(1);
            this.filterItemSlotInventory.m_6836_(0, stack);
            return ItemStack.f_41583_;
        }
        return itemstack;
    }
}

