/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.useful_backpacks.event;

import info.u_team.useful_backpacks.api.Backpack;
import info.u_team.useful_backpacks.config.CommonConfig;
import info.u_team.useful_backpacks.inventory.BackpackInventory;
import info.u_team.useful_backpacks.item.BackpackItem;
import info.u_team.useful_backpacks.menu.BackpackMenu;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.InvWrapper;

public class ItemPickupEventHandler {
    public static final List<Function<ServerPlayer, ItemStack>> INTEGRATION_BACKPACKS = new ArrayList<Function<ServerPlayer, ItemStack>>();

    private static void onEntityItemPickup(EntityItemPickupEvent event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ItemStack stackToPickup = event.getItem().m_32055_();
        if (stackToPickup.m_41720_() instanceof Backpack && !((Boolean)CommonConfig.getInstance().allowStackingBackpacks.get()).booleanValue()) {
            return;
        }
        ItemStack resultStack = ItemPickupEventHandler.insertInBackpacks((ServerPlayer)player, stackToPickup);
        stackToPickup.m_41764_(resultStack.m_41613_());
        if (resultStack.m_41619_()) {
            event.setResult(Event.Result.ALLOW);
        }
    }

    private static ItemStack insertInBackpacks(ServerPlayer player, ItemStack stackToPickup) {
        BackpackItem backpack;
        Object inventory;
        Item item;
        BackpackMenu menu;
        Container container;
        AbstractContainerMenu abstractContainerMenu = player.f_36096_;
        if (abstractContainerMenu instanceof BackpackMenu && (container = (menu = (BackpackMenu)abstractContainerMenu).getBackpackInventory()) instanceof BackpackInventory && (item = ((BackpackInventory)((Object)(inventory = (BackpackInventory)container))).getStack().m_41720_()) instanceof BackpackItem && (backpack = (BackpackItem)item).canAutoPickup(stackToPickup, ((BackpackInventory)((Object)inventory)).getStack())) {
            InvWrapper itemHandler = new InvWrapper((Container)inventory);
            ItemStack result = ItemHandlerHelper.insertItemStacked((IItemHandler)itemHandler, (ItemStack)stackToPickup, (boolean)false);
            if (result.m_41613_() != stackToPickup.m_41613_()) {
                ((BackpackInventory)((Object)inventory)).writeItemStack();
            }
            if ((stackToPickup = result).m_41619_()) {
                return stackToPickup;
            }
        }
        Inventory playerInventory = player.m_150109_();
        for (Function<ServerPlayer, ItemStack> function : INTEGRATION_BACKPACKS) {
            ItemStack stack = function.apply(player);
            if (stack.m_41619_() || !(stackToPickup = ItemPickupEventHandler.insertInBackpack(player, stack, stackToPickup)).m_41619_()) continue;
            return stackToPickup;
        }
        for (int index = 0; index < playerInventory.m_6643_(); ++index) {
            ItemStack stack = playerInventory.m_8020_(index);
            stackToPickup = ItemPickupEventHandler.insertInBackpack(player, stack, stackToPickup);
            if (!stackToPickup.m_41619_()) continue;
            return stackToPickup;
        }
        return stackToPickup;
    }

    private static ItemStack insertInBackpack(ServerPlayer player, ItemStack stack, ItemStack stackToPickup) {
        Backpack backpack;
        Item item = stack.m_41720_();
        if (item instanceof Backpack && (backpack = (Backpack)item).canAutoPickup(stackToPickup, stack)) {
            Container inventory = backpack.getInventory(player, stack);
            InvWrapper itemHandler = new InvWrapper(inventory);
            ItemStack result = ItemHandlerHelper.insertItemStacked((IItemHandler)itemHandler, (ItemStack)stackToPickup, (boolean)false);
            if (result.m_41613_() != stackToPickup.m_41613_()) {
                backpack.saveInventory(inventory, stack);
            }
            stackToPickup = result;
        }
        return stackToPickup;
    }

    public static void registerForge(IEventBus bus) {
        bus.addListener(EventPriority.HIGHEST, ItemPickupEventHandler::onEntityItemPickup);
    }
}

