/*
 * Decompiled with CFR 0.152.
 */
package com.chirptheboy.disenchanting.block.disenchant;

import com.chirptheboy.disenchanting.block.TileBlockEntityDisenchanting;
import com.chirptheboy.disenchanting.block.disenchant.ContainerDisenchant;
import com.chirptheboy.disenchanting.capabilities.ItemStackHandlerWrapper;
import com.chirptheboy.disenchanting.data.DataTags;
import com.chirptheboy.disenchanting.registry.TileRegistry;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class TileDisenchant
extends TileBlockEntityDisenchanting
implements MenuProvider {
    public static final int SLOT_INPUT = 0;
    public static final int SLOT_BOOK = 1;
    ItemStackHandler inputSlots = new ItemStackHandler(2){

        public boolean isItemValid(int slot, ItemStack stack) {
            if (slot == 1) {
                return stack.m_41720_() == Items.f_42517_;
            }
            if (slot == 0) {
                Map enchants = EnchantmentHelper.m_44831_((ItemStack)stack);
                return enchants != null && enchants.size() > 0 && !stack.m_204117_(DataTags.DISENCHANTER_IMMUNE);
            }
            return stack.m_41720_() == Items.f_42690_;
        }
    };
    ItemStackHandler outputSlots = new ItemStackHandler(1){

        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (amount == 0) {
                return ItemStack.f_41583_;
            }
            this.validateSlotIndex(slot);
            ItemStack existing = (ItemStack)this.stacks.get(slot);
            if (existing.m_41619_()) {
                return ItemStack.f_41583_;
            }
            int toExtract = Math.min(amount, existing.m_41741_());
            if (existing.m_41613_() <= toExtract) {
                if (!simulate) {
                    this.stacks.set(slot, (Object)ItemStack.f_41583_);
                    this.onContentsChanged(slot);
                    return existing;
                }
                return existing.m_41777_();
            }
            if (!simulate) {
                this.stacks.set(slot, (Object)ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)(existing.m_41613_() - toExtract)));
                this.onContentsChanged(slot);
            }
            return ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)toExtract);
        }
    };
    private ItemStackHandlerWrapper inventory = new ItemStackHandlerWrapper(this.inputSlots, this.outputSlots);
    private final LazyOptional<IItemHandler> inventoryCap = LazyOptional.of(() -> this.inventory);
    public static ForgeConfigSpec.BooleanValue REQUIRES_EXPERIENCE;
    public static ForgeConfigSpec.BooleanValue RANDOM_ENCHANTMENT;
    public static ForgeConfigSpec.BooleanValue RESET_ANVIL_COST;
    public static ForgeConfigSpec.IntValue COST_SLIDER;

    public TileDisenchant(BlockPos pos, BlockState state) {
        super((BlockEntityType)TileRegistry.DISENCHANTER.get(), pos, state);
    }

    public Component m_5446_() {
        return Component.m_237113_((String)"disenchanter");
    }

    public AbstractContainerMenu m_7208_(int i, Inventory playerInventory, Player playerEntity) {
        return new ContainerDisenchant(i, this.f_58857_, this.f_58858_, playerInventory, playerEntity);
    }

    public void invalidateCaps() {
        this.inventoryCap.invalidate();
        super.invalidateCaps();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.inventoryCap.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        this.inventory.deserializeNBT(tag.m_128469_("inv"));
        super.m_142466_(tag);
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        tag.m_128365_("inv", (Tag)this.inventory.serializeNBT());
        CompoundTag fluid = new CompoundTag();
        tag.m_128365_("fluid", (Tag)fluid);
        super.m_183515_(tag);
    }

    @Override
    public void setField(int field, int value) {
        switch (Fields.values()[field]) {
            case BLACKLIST: {
                this.isBlacklisted = value;
            }
            case COST: {
                this.cost = value;
            }
            case SHOWCOST: {
                this.showCost = value;
            }
        }
    }

    @Override
    public int getField(int field) {
        return switch (Fields.values()[field]) {
            case Fields.BLACKLIST -> this.isBlacklisted;
            case Fields.COST -> this.cost;
            case Fields.SHOWCOST -> this.showCost;
            default -> 0;
        };
    }

    static enum Fields {
        BLACKLIST,
        COST,
        SHOWCOST;

    }
}

