/*
 * Decompiled with CFR 0.152.
 */
package com.chirptheboy.disenchanting.block;

import java.lang.ref.WeakReference;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.network.protocol.game.ServerboundPlayerActionPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.FakePlayer;

public abstract class TileBlockEntityDisenchanting
extends BlockEntity
implements Container {
    public static final String NBTINV = "inv";
    public static final String NBTFLUID = "fluid";
    protected int isBlacklisted = 0;
    protected int cost = 0;
    protected int showCost = 1;

    public TileBlockEntityDisenchanting(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
    }

    public Boolean showCost() {
        return this.showCost == 1;
    }

    public Boolean isBlacklisted() {
        return this.isBlacklisted == 1;
    }

    public int getCost() {
        return this.cost;
    }

    protected Player getLookingPlayer(int maxRange, boolean mustCrouch) {
        List players = this.f_58857_.m_45976_(Player.class, new AABB((double)(this.f_58858_.m_123341_() - maxRange), (double)(this.f_58858_.m_123342_() - maxRange), (double)(this.f_58858_.m_123343_() - maxRange), (double)(this.f_58858_.m_123341_() + maxRange), (double)(this.f_58858_.m_123342_() + maxRange), (double)(this.f_58858_.m_123343_() + maxRange)));
        for (Player player : players) {
            if (mustCrouch && !player.m_6047_()) continue;
            Vec3 positionEyes = player.m_20299_(1.0f);
            Vec3 look = player.m_20252_(1.0f);
            Vec3 visionWithLength = positionEyes.m_82520_(look.f_82479_ * (double)maxRange, look.f_82480_ * (double)maxRange, look.f_82481_ * (double)maxRange);
            BlockHitResult rayTrace = this.f_58857_.m_45547_(new ClipContext(positionEyes, visionWithLength, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player));
            if (!this.f_58858_.equals((Object)rayTrace.m_82425_())) continue;
            return player;
        }
        return null;
    }

    public static InteractionResult interactUseOnBlock(WeakReference<FakePlayer> fakePlayer, Level world, BlockPos targetPos, InteractionHand hand, Direction facing) throws Exception {
        if (fakePlayer == null) {
            return InteractionResult.FAIL;
        }
        Direction placementOn = facing == null ? ((FakePlayer)fakePlayer.get()).m_6374_() : facing;
        BlockHitResult blockraytraceresult = new BlockHitResult(((FakePlayer)fakePlayer.get()).m_20154_(), placementOn, targetPos, true);
        ItemStack itemInHand = ((FakePlayer)fakePlayer.get()).m_21120_(hand);
        InteractionResult result = ((FakePlayer)fakePlayer.get()).f_8941_.m_7179_((ServerPlayer)fakePlayer.get(), world, itemInHand, hand, blockraytraceresult);
        return result;
    }

    public static InteractionResult playerAttackBreakBlock(WeakReference<FakePlayer> fakePlayer, Level world, BlockPos targetPos, InteractionHand hand, Direction facing) throws Exception {
        if (fakePlayer == null) {
            return InteractionResult.FAIL;
        }
        try {
            ((FakePlayer)fakePlayer.get()).f_8941_.m_214168_(targetPos, ServerboundPlayerActionPacket.Action.START_DESTROY_BLOCK, facing, world.m_151558_(), 2);
            return InteractionResult.SUCCESS;
        }
        catch (Exception e) {
            return InteractionResult.FAIL;
        }
    }

    public static boolean tryHarvestBlock(WeakReference<FakePlayer> fakePlayer, Level world, BlockPos targetPos) {
        if (fakePlayer == null) {
            return false;
        }
        return ((FakePlayer)fakePlayer.get()).f_8941_.m_9280_(targetPos);
    }

    public Direction getCurrentFacing() {
        if (this.m_58900_().m_61138_((Property)BlockStateProperties.f_61372_)) {
            return (Direction)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61372_);
        }
        if (this.m_58900_().m_61138_((Property)BlockStateProperties.f_61374_)) {
            return (Direction)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61374_);
        }
        return null;
    }

    protected BlockPos getCurrentFacingPos(int distance) {
        Direction f = this.getCurrentFacing();
        if (f != null) {
            return this.f_58858_.m_5484_(f, distance);
        }
        return this.f_58858_;
    }

    protected BlockPos getCurrentFacingPos() {
        return this.getCurrentFacingPos(1);
    }

    public CompoundTag m_5995_() {
        CompoundTag syncData = super.m_5995_();
        this.m_183515_(syncData);
        return syncData;
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.m_142466_(pkt.m_131708_());
        super.onDataPacket(net, pkt);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void m_142466_(CompoundTag tag) {
        this.isBlacklisted = tag.m_128451_("isBlacklisted");
        this.cost = tag.m_128451_("cost");
        this.showCost = tag.m_128451_("showCost");
        super.m_142466_(tag);
    }

    public void m_183515_(CompoundTag tag) {
        tag.m_128405_("isBlacklisted", this.isBlacklisted);
        tag.m_128405_("cost", this.cost);
        tag.m_128405_("showCost", this.showCost);
        super.m_183515_(tag);
    }

    public abstract void setField(int var1, int var2);

    public abstract int getField(int var1);

    public void setIsBlacklisted(int value) {
        this.isBlacklisted = value;
    }

    @Deprecated
    public int m_6643_() {
        return 0;
    }

    @Deprecated
    public boolean m_7983_() {
        return true;
    }

    @Deprecated
    public ItemStack m_8020_(int index) {
        return ItemStack.f_41583_;
    }

    @Deprecated
    public ItemStack m_7407_(int index, int count) {
        return ItemStack.f_41583_;
    }

    @Deprecated
    public ItemStack m_8016_(int index) {
        return ItemStack.f_41583_;
    }

    @Deprecated
    public void m_6836_(int index, ItemStack stack) {
    }

    @Deprecated
    public boolean m_6542_(Player player) {
        return false;
    }

    @Deprecated
    public void m_6211_() {
    }

    public void setFieldString(int field, String value) {
    }

    public String getFieldString(int field) {
        return null;
    }
}

