/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import info.u_team.u_team_core.gui.renderer.FluidInventoryRenderer;
import info.u_team.u_team_core.intern.init.UCoreNetwork;
import info.u_team.u_team_core.intern.network.FluidClickContainerMessage;
import info.u_team.u_team_core.menu.FluidContainerMenu;
import info.u_team.u_team_core.menu.FluidSlot;
import info.u_team.u_team_core.util.RGBA;
import info.u_team.u_team_core.util.RenderUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;

public abstract class FluidContainerMenuScreen<T extends AbstractContainerMenu>
extends AbstractContainerScreen<T> {
    protected FluidInventoryRenderer fluidRenderer = FluidInventoryRenderer.DEFAULT_INSTANCE;
    protected FluidSlot hoveredFluidSlot;

    protected FluidContainerMenuScreen(T container, Inventory playerInventory, Component title) {
        super(container, playerInventory, title);
    }

    protected void setFluidRenderer(FluidInventoryRenderer fluidRenderer) {
        this.fluidRenderer = fluidRenderer;
    }

    protected void m_7027_(PoseStack poseStack, int mouseX, int mouseY) {
        AbstractContainerMenu abstractContainerMenu = this.f_97732_;
        if (abstractContainerMenu instanceof FluidContainerMenu) {
            FluidContainerMenu fluidMenu = (FluidContainerMenu)abstractContainerMenu;
            this.hoveredFluidSlot = null;
            for (int slot = 0; slot < fluidMenu.fluidSlots.size(); ++slot) {
                FluidSlot fluidSlot = fluidMenu.fluidSlots.get(slot);
                if (!fluidSlot.isActive()) continue;
                this.renderFluidSlot(poseStack, fluidSlot);
                if (!this.isHovering(fluidSlot, mouseX, mouseY)) continue;
                this.hoveredFluidSlot = fluidSlot;
                RenderUtil.setShaderColor(RGBA.WHITE);
                FluidContainerMenuScreen.renderSlotHighlight((PoseStack)poseStack, (int)fluidSlot.getX(), (int)fluidSlot.getY(), (int)this.m_93252_(), (int)this.getFluidSlotColor(slot));
            }
        }
    }

    protected void renderFluidSlot(PoseStack poseStack, FluidSlot fluidSlot) {
        Pair<ResourceLocation, ResourceLocation> pair;
        int blitOffset = 100;
        this.m_93250_(100);
        int x = fluidSlot.getX();
        int y = fluidSlot.getY();
        if (!fluidSlot.hasFluid() && fluidSlot.isActive() && (pair = fluidSlot.getNoItemIcon()) != null) {
            TextureAtlasSprite sprite = (TextureAtlasSprite)this.f_96541_.m_91258_((ResourceLocation)pair.getFirst()).apply((ResourceLocation)pair.getSecond());
            RenderUtil.drawTexturedQuad(poseStack, x, y, 16, 16, 100.0f, sprite, RGBA.WHITE);
        }
        this.fluidRenderer.drawFluidInSlot(poseStack, x, y, 100.0f, fluidSlot.getFluid());
        this.m_93250_(0);
    }

    protected void m_7025_(PoseStack poseStack, int mouseX, int mouseY) {
        super.m_7025_(poseStack, mouseX, mouseY);
        if (this.f_97732_.m_142621_().m_41619_() && this.hoveredFluidSlot != null && this.hoveredFluidSlot.hasFluid()) {
            this.m_96597_(poseStack, this.getTooltipFromFluid(this.hoveredFluidSlot), mouseX, mouseY);
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        FluidSlot fluidSlot;
        if (button == 0 && (fluidSlot = this.findFluidSlot(mouseX, mouseY)) != null) {
            if (!this.f_97732_.m_142621_().m_41619_()) {
                UCoreNetwork.NETWORK.sendToServer((Object)new FluidClickContainerMessage(this.f_97732_.f_38840_, fluidSlot.index, FluidContainerMenuScreen.m_96638_(), this.f_97732_.m_142621_()));
            }
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    protected FluidSlot findFluidSlot(double mouseX, double mouseY) {
        AbstractContainerMenu abstractContainerMenu = this.f_97732_;
        if (abstractContainerMenu instanceof FluidContainerMenu) {
            FluidContainerMenu fluidMenu = (FluidContainerMenu)abstractContainerMenu;
            for (FluidSlot fluidSlot : fluidMenu.fluidSlots) {
                if (!this.isHovering(fluidSlot, mouseX, mouseY) || !fluidSlot.isActive()) continue;
                return fluidSlot;
            }
        }
        return null;
    }

    protected boolean isHovering(FluidSlot fluidSlot, double mouseX, double mouseY) {
        return this.m_6774_(fluidSlot.getX(), fluidSlot.getY(), 16, 16, mouseX, mouseY);
    }

    protected int getFluidSlotColor(int index) {
        return super.getSlotColor(index);
    }

    public List<Component> getTooltipFromFluid(FluidSlot fluidSlot) {
        FluidStack stack = fluidSlot.getFluid();
        ArrayList<Component> list = new ArrayList<Component>();
        list.add(stack.getDisplayName());
        list.add((Component)Component.m_237113_((String)(stack.getAmount() + " mb/" + fluidSlot.getSlotCapacity() + " mb")).m_130940_(ChatFormatting.GRAY));
        if (this.f_96541_.f_91066_.f_92125_) {
            list.add((Component)Component.m_237113_((String)ForgeRegistries.FLUIDS.getKey((Object)stack.getFluid()).toString()).m_130940_(ChatFormatting.DARK_GRAY));
        }
        return list;
    }
}

