/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.gui.elements;

import info.u_team.u_team_core.gui.elements.UButton;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class AbstractSliderLogic
extends UButton {
    protected static final OnSliderChange EMPTY_SLIDER = slider -> {};
    protected final Component prefix;
    protected final Component suffix;
    protected final double minValue;
    protected final double maxValue;
    protected double value;
    protected final boolean decimalPrecision;
    protected int precision = 1;
    protected final boolean drawDescription;
    protected OnSliderChange slider;
    public boolean dragging = false;

    protected AbstractSliderLogic(int x, int y, int width, int height, Component prefix, Component suffix, double minValue, double maxValue, double currentValue, boolean decimalPrecision, boolean drawDescription, OnSliderChange slider, Button.OnTooltip tooltip) {
        super(x, y, width, height, prefix, EMTPY_PRESSABLE, tooltip);
        this.prefix = prefix;
        this.suffix = suffix;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.value = (currentValue - minValue) / (maxValue - minValue);
        this.decimalPrecision = decimalPrecision;
        this.drawDescription = drawDescription;
        if (drawDescription) {
            String displayValue;
            if (decimalPrecision) {
                displayValue = Double.toString(this.value * (maxValue - minValue) + minValue);
                this.precision = Math.min(displayValue.substring(displayValue.indexOf(".") + 1).length(), 4);
            } else {
                displayValue = Integer.toString((int)Math.round(this.value * (maxValue - minValue) + minValue));
                this.precision = 0;
            }
            this.m_93666_((Component)Component.m_237119_().m_7220_(prefix).m_130946_(displayValue).m_7220_(suffix));
        } else {
            this.m_93666_((Component)Component.m_237119_());
        }
        this.slider = slider;
    }

    public void setSlider(OnSliderChange slider) {
        this.slider = slider;
    }

    public void setSlider(Runnable runnable) {
        this.slider = slider -> runnable.run();
    }

    public void updateSlider() {
        this.updateSliderText();
        this.slider.onChange(this);
    }

    public void updateSliderText() {
        Object displayValue;
        this.value = Mth.m_14008_((double)this.value, (double)0.0, (double)1.0);
        if (this.decimalPrecision) {
            displayValue = Double.toString(this.value * (this.maxValue - this.minValue) + this.minValue);
            if (((String)displayValue).substring(((String)displayValue).indexOf(".") + 1).length() > this.precision) {
                if (((String)(displayValue = ((String)displayValue).substring(0, ((String)displayValue).indexOf(".") + this.precision + 1))).endsWith(".")) {
                    displayValue = ((String)displayValue).substring(0, ((String)displayValue).indexOf(".") + this.precision);
                }
            } else {
                while (((String)displayValue).substring(((String)displayValue).indexOf(".") + 1).length() < this.precision) {
                    displayValue = (String)displayValue + "0";
                }
            }
        } else {
            displayValue = Integer.toString((int)Math.round(this.value * (this.maxValue - this.minValue) + this.minValue));
        }
        if (this.drawDescription) {
            this.m_93666_((Component)Component.m_237119_().m_7220_(this.prefix).m_130946_((String)displayValue).m_7220_(this.suffix));
        }
    }

    public int getValueInt() {
        return (int)Math.round(this.value * (this.maxValue - this.minValue) + this.minValue);
    }

    public double getValue() {
        return this.value * (this.maxValue - this.minValue) + this.minValue;
    }

    public void setValue(double value) {
        this.value = (value - this.minValue) / (this.maxValue - this.minValue);
        this.updateSliderText();
    }

    public static interface OnSliderChange {
        public void onChange(AbstractSliderLogic var1);
    }
}

