/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import info.u_team.u_team_core.data.CommonDataProvider;
import info.u_team.u_team_core.data.GenerationData;
import java.io.IOException;
import java.util.List;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.loot.IGlobalLootModifier;

public abstract class CommonGlobalLootModifierProvider
implements DataProvider,
CommonDataProvider<BiConsumer<String, ? super IGlobalLootModifier>> {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final GenerationData generationData;
    private final DataGenerator.PathProvider pathProvider;
    protected boolean replace;

    public CommonGlobalLootModifierProvider(GenerationData generationData) {
        this.generationData = generationData;
        this.pathProvider = generationData.generator().m_236036_(DataGenerator.Target.DATA_PACK, "loot_modifiers");
    }

    @Override
    public GenerationData getGenerationData() {
        return this.generationData;
    }

    public void m_213708_(CachedOutput cache) throws IOException {
        TreeMap serializers = new TreeMap();
        this.register((modifier, instance) -> {
            JsonElement json = (JsonElement)IGlobalLootModifier.DIRECT_CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, instance).getOrThrow(false, error -> {});
            serializers.put(modifier, json);
        });
        List entries = serializers.entrySet().stream().map(entry -> {
            String name = (String)entry.getKey();
            JsonElement json = (JsonElement)entry.getValue();
            ResourceLocation location = new ResourceLocation(this.modid(), name);
            CommonDataProvider.saveData(cache, json, this.pathProvider.m_236048_(location), "Cannot save global loot modifier");
            return location;
        }).map(ResourceLocation::toString).collect(Collectors.toList());
        JsonObject json = new JsonObject();
        json.addProperty("replace", Boolean.valueOf(this.replace));
        json.add("entries", GSON.toJsonTree(entries));
        CommonDataProvider.saveData(cache, (JsonElement)json, this.pathProvider.m_236048_(new ResourceLocation("forge", "global_loot_modifiers")), "Cannot save global loot modifiers list");
    }

    protected void replacing() {
        this.replace = true;
    }

    public String m_6055_() {
        return "Global-Loot-Modifier";
    }
}

