/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.api.sync;

import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import java.util.function.LongConsumer;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;

public abstract class DataHolder {
    private FriendlyByteBuf lastKnownValue;

    public abstract FriendlyByteBuf get();

    public abstract void set(FriendlyByteBuf var1);

    public boolean checkAndClearUpdateFlag() {
        FriendlyByteBuf buffer = this.get();
        boolean changed = !buffer.equals((Object)this.lastKnownValue);
        this.lastKnownValue = buffer;
        return changed;
    }

    public static final DataHolder createHolder(final Supplier<FriendlyByteBuf> supplier, final Consumer<FriendlyByteBuf> consumer) {
        return new DataHolder(){

            @Override
            public FriendlyByteBuf get() {
                return new FriendlyByteBuf(((FriendlyByteBuf)supplier.get()).copy());
            }

            @Override
            public void set(FriendlyByteBuf buffer) {
                consumer.accept(buffer);
            }
        };
    }

    public static final DataHolder createByteHolder(final Supplier<Byte> supplier, final Consumer<Byte> consumer) {
        return new DataHolder(){
            private byte lastKnownValue;

            @Override
            public FriendlyByteBuf get() {
                return new FriendlyByteBuf(Unpooled.buffer((int)1).writeByte((int)((Byte)supplier.get()).byteValue()));
            }

            @Override
            public void set(FriendlyByteBuf buffer) {
                consumer.accept(buffer.readByte());
            }

            @Override
            public boolean checkAndClearUpdateFlag() {
                byte value = (Byte)supplier.get();
                boolean changed = value != this.lastKnownValue;
                this.lastKnownValue = value;
                return changed;
            }
        };
    }

    public static final DataHolder createShortHolder(final Supplier<Short> supplier, final Consumer<Short> consumer) {
        return new DataHolder(){
            private short lastKnownValue;

            @Override
            public FriendlyByteBuf get() {
                return new FriendlyByteBuf(Unpooled.copyShort((int)((Short)supplier.get()).shortValue()));
            }

            @Override
            public void set(FriendlyByteBuf buffer) {
                consumer.accept(buffer.readShort());
            }

            @Override
            public boolean checkAndClearUpdateFlag() {
                short value = (Short)supplier.get();
                boolean changed = value != this.lastKnownValue;
                this.lastKnownValue = value;
                return changed;
            }
        };
    }

    public static final DataHolder createIntHolder(final IntSupplier supplier, final IntConsumer consumer) {
        return new DataHolder(){
            private int lastKnownValue;

            @Override
            public FriendlyByteBuf get() {
                return new FriendlyByteBuf(Unpooled.copyInt((int)supplier.getAsInt()));
            }

            @Override
            public void set(FriendlyByteBuf buffer) {
                consumer.accept(buffer.readInt());
            }

            @Override
            public boolean checkAndClearUpdateFlag() {
                int value = supplier.getAsInt();
                boolean changed = value != this.lastKnownValue;
                this.lastKnownValue = value;
                return changed;
            }
        };
    }

    public static final DataHolder createLongHolder(final LongSupplier supplier, final LongConsumer consumer) {
        return new DataHolder(){
            private long lastKnownValue;

            @Override
            public FriendlyByteBuf get() {
                return new FriendlyByteBuf(Unpooled.copyLong((long)supplier.getAsLong()));
            }

            @Override
            public void set(FriendlyByteBuf buffer) {
                consumer.accept(buffer.readLong());
            }

            @Override
            public boolean checkAndClearUpdateFlag() {
                long value = supplier.getAsLong();
                boolean changed = value != this.lastKnownValue;
                this.lastKnownValue = value;
                return changed;
            }
        };
    }

    public static final DataHolder createFloatHolder(final Supplier<Float> supplier, final Consumer<Float> consumer) {
        return new DataHolder(){
            private float lastKnownValue;

            @Override
            public FriendlyByteBuf get() {
                return new FriendlyByteBuf(Unpooled.copyFloat((float)((Float)supplier.get()).floatValue()));
            }

            @Override
            public void set(FriendlyByteBuf buffer) {
                consumer.accept(Float.valueOf(buffer.readFloat()));
            }

            @Override
            public boolean checkAndClearUpdateFlag() {
                float value = ((Float)supplier.get()).floatValue();
                boolean changed = value != this.lastKnownValue;
                this.lastKnownValue = value;
                return changed;
            }
        };
    }

    public static final DataHolder createDoubleHolder(final Supplier<Double> supplier, final Consumer<Double> consumer) {
        return new DataHolder(){
            private double lastKnownValue;

            @Override
            public FriendlyByteBuf get() {
                return new FriendlyByteBuf(Unpooled.copyDouble((double)((Double)supplier.get())));
            }

            @Override
            public void set(FriendlyByteBuf buffer) {
                consumer.accept(buffer.readDouble());
            }

            @Override
            public boolean checkAndClearUpdateFlag() {
                double value = (Double)supplier.get();
                boolean changed = value != this.lastKnownValue;
                this.lastKnownValue = value;
                return changed;
            }
        };
    }

    public static final DataHolder createBooleanHolder(final BooleanSupplier supplier, final BooleanConsumer consumer) {
        return new DataHolder(){
            private boolean lastKnownValue;

            @Override
            public FriendlyByteBuf get() {
                return new FriendlyByteBuf(Unpooled.copyBoolean((boolean)supplier.getAsBoolean()));
            }

            @Override
            public void set(FriendlyByteBuf buffer) {
                consumer.accept(buffer.readBoolean());
            }

            @Override
            public boolean checkAndClearUpdateFlag() {
                boolean value = supplier.getAsBoolean();
                boolean changed = value != this.lastKnownValue;
                this.lastKnownValue = value;
                return changed;
            }
        };
    }
}

