/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.common.multiblock;

import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ColorResolver;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.Nullable;
import vazkii.patchouli.api.IMultiblock;
import vazkii.patchouli.api.TriPredicate;
import vazkii.patchouli.common.util.RotationUtil;

public abstract class AbstractMultiblock
implements IMultiblock,
BlockAndTintGetter {
    public ResourceLocation id;
    protected int offX;
    protected int offY;
    protected int offZ;
    protected int viewOffX;
    protected int viewOffY;
    protected int viewOffZ;
    private boolean symmetrical;
    Level world;
    private final transient Map<BlockPos, BlockEntity> teCache = new HashMap<BlockPos, BlockEntity>();

    @Override
    public IMultiblock offset(int x, int y, int z) {
        return this.setOffset(this.offX + x, this.offY + y, this.offZ + z);
    }

    public IMultiblock setOffset(int x, int y, int z) {
        this.offX = x;
        this.offY = y;
        this.offZ = z;
        return this.setViewOffset(x, y, z);
    }

    void setViewOffset() {
        this.setViewOffset(this.offX, this.offY, this.offZ);
    }

    @Override
    public IMultiblock offsetView(int x, int y, int z) {
        return this.setViewOffset(this.viewOffX + x, this.viewOffY + y, this.viewOffZ + z);
    }

    public IMultiblock setViewOffset(int x, int y, int z) {
        this.viewOffX = x;
        this.viewOffY = y;
        this.viewOffZ = z;
        return this;
    }

    @Override
    public IMultiblock setSymmetrical(boolean symmetrical) {
        this.symmetrical = symmetrical;
        return this;
    }

    @Override
    public ResourceLocation getID() {
        return this.id;
    }

    @Override
    public IMultiblock setId(ResourceLocation res) {
        this.id = res;
        return this;
    }

    @Override
    public void place(Level world, BlockPos pos, Rotation rotation) {
        this.setWorld(world);
        ((Collection)this.simulate(world, pos, rotation, false).getSecond()).forEach(r -> {
            BlockPos placePos = r.getWorldPosition();
            BlockState targetState = r.getStateMatcher().getDisplayedState(world.m_46467_()).m_60717_(rotation);
            if (!targetState.m_60795_() && targetState.m_60710_((LevelReader)world, placePos) && world.m_8055_(placePos).m_60767_().m_76336_()) {
                world.m_46597_(placePos, targetState);
            }
        });
    }

    @Override
    public Rotation validate(Level world, BlockPos pos) {
        if (this.isSymmetrical() && this.validate(world, pos, Rotation.NONE)) {
            return Rotation.NONE;
        }
        for (Rotation rot : Rotation.values()) {
            if (!this.validate(world, pos, rot)) continue;
            return rot;
        }
        return null;
    }

    @Override
    public boolean validate(Level world, BlockPos pos, Rotation rotation) {
        this.setWorld(world);
        Pair<BlockPos, Collection<IMultiblock.SimulateResult>> sim = this.simulate(world, pos, rotation, false);
        return ((Collection)sim.getSecond()).stream().allMatch(r -> {
            BlockPos checkPos = r.getWorldPosition();
            TriPredicate<BlockGetter, BlockPos, BlockState> pred = r.getStateMatcher().getStatePredicate();
            BlockState state = world.m_8055_(checkPos).m_60717_(RotationUtil.fixHorizontal(rotation));
            return pred.test((BlockGetter)world, checkPos, state);
        });
    }

    @Override
    public boolean isSymmetrical() {
        return this.symmetrical;
    }

    public void setWorld(Level world) {
        this.world = world;
    }

    @Nullable
    public BlockEntity m_7702_(BlockPos pos) {
        BlockState state = this.m_8055_(pos);
        if (state.m_60734_() instanceof EntityBlock) {
            return this.teCache.computeIfAbsent(pos.m_7949_(), p -> ((EntityBlock)state.m_60734_()).m_142194_(pos, state));
        }
        return null;
    }

    public FluidState m_6425_(BlockPos pos) {
        return Fluids.f_76191_.m_76145_();
    }

    @Override
    public abstract Vec3i getSize();

    public float m_7717_(Direction direction, boolean shaded) {
        return 1.0f;
    }

    public LevelLightEngine m_5518_() {
        return null;
    }

    public int m_6171_(BlockPos pos, ColorResolver color) {
        Biome plains = (Biome)this.world.m_5962_().m_175515_(Registry.f_122885_).m_123013_(Biomes.f_48202_);
        return color.m_130045_(plains, (double)pos.m_123341_(), (double)pos.m_123343_());
    }

    public int m_45517_(LightLayer type, BlockPos pos) {
        return 15;
    }

    public int m_45524_(BlockPos pos, int ambientDarkening) {
        return 15 - ambientDarkening;
    }

    public int m_141928_() {
        return 255;
    }

    public int m_141937_() {
        return 0;
    }
}

