/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import org.dynmap.Handler;
import org.dynmap.Log;

public class AsynchronousQueue<T> {
    private Object lock = new Object();
    private Thread thread;
    private LinkedBlockingQueue<T> queue = new LinkedBlockingQueue();
    private Set<T> set = new HashSet<T>();
    private Handler<T> handler;
    private int dequeueTime;
    private int accelDequeueTime;
    public int accelDequeueThresh;
    private int pendingcnt;
    private int pendinglimit;
    private boolean normalprio;

    public AsynchronousQueue(Handler<T> handler, int dequeueTime, int accelDequeueThresh, int accelDequeueTime, int pendinglimit, boolean normalprio) {
        this.handler = handler;
        this.dequeueTime = dequeueTime;
        this.accelDequeueTime = accelDequeueTime;
        this.accelDequeueThresh = accelDequeueThresh;
        if (pendinglimit < 1) {
            pendinglimit = 1;
        }
        this.pendinglimit = pendinglimit;
        this.normalprio = normalprio;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean push(T t) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.set.add(t)) {
                return false;
            }
        }
        this.queue.offer(t);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private T pop() {
        try {
            T t = this.queue.take();
            Object object = this.lock;
            synchronized (object) {
                this.set.remove(t);
            }
            return t;
        }
        catch (InterruptedException ix) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(T t) {
        Object object = this.lock;
        synchronized (object) {
            if (this.set.remove(t)) {
                this.queue.remove(t);
                return true;
            }
        }
        return false;
    }

    public int size() {
        return this.set.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<T> popAll() {
        ArrayList<T> s;
        Object object = this.lock;
        synchronized (object) {
            s = new ArrayList<T>(this.queue);
            this.queue.clear();
            this.set.clear();
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this.lock;
        synchronized (object) {
            this.thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    AsynchronousQueue.this.running();
                }
            });
            this.thread.setDaemon(true);
            this.thread.start();
            try {
                if (!this.normalprio) {
                    this.thread.setPriority(1);
                }
            }
            catch (SecurityException e) {
                Log.info("Failed to set minimum priority for worker thread!");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.lock;
        synchronized (object) {
            if (this.thread == null) {
                return;
            }
            Thread oldThread = this.thread;
            this.thread = null;
            Log.info("Stopping map renderer...");
            oldThread.interrupt();
            try {
                oldThread.join(1000L);
            }
            catch (InterruptedException e) {
                Log.info("Waiting for map renderer to stop is interrupted");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void running() {
        try {
            while (Thread.currentThread() == this.thread) {
                Object object = this.lock;
                synchronized (object) {
                    while (this.pendingcnt >= this.pendinglimit) {
                        try {
                            this.lock.wait(this.accelDequeueTime);
                        }
                        catch (InterruptedException ix) {
                            if (Thread.currentThread() != this.thread) {
                                return;
                            }
                            throw ix;
                        }
                    }
                }
                T t = this.pop();
                if (t != null) {
                    Object object2 = this.lock;
                    synchronized (object2) {
                        ++this.pendingcnt;
                    }
                    this.handler.handle(t);
                }
                if (this.set.size() >= this.accelDequeueThresh) {
                    this.sleep(this.accelDequeueTime);
                    continue;
                }
                this.sleep(this.dequeueTime);
            }
        }
        catch (Exception ex) {
            Log.severe("Exception on rendering-thread", ex);
        }
    }

    private boolean sleep(int time) {
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException e) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void done(T t) {
        Object object = this.lock;
        synchronized (object) {
            if (this.pendingcnt > 0) {
                --this.pendingcnt;
            }
            this.lock.notifyAll();
        }
    }
}

