/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.chunky.world;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.zip.InflaterInputStream;
import org.popcraft.chunky.nbt.CompoundTag;
import org.popcraft.chunky.nbt.IntTag;
import org.popcraft.chunky.nbt.Tag;
import org.popcraft.chunky.util.ChunkMath;
import org.popcraft.chunky.world.Chunk;

public final class RegionFile {
    private static final int ENTRIES = 1024;
    private static final int SECTOR_SIZE = 4096;
    private final Map<Long, Chunk> chunks = new HashMap<Long, Chunk>();

    public RegionFile(File file) {
        try (RandomAccessFile region = new RandomAccessFile(file, "r");){
            int i;
            int[] offsetTable = new int[1024];
            int[] sizeTable = new int[1024];
            for (int i2 = 0; i2 < 1024; ++i2) {
                int location = region.readInt();
                offsetTable[i2] = location >> 8 & 0xFFFFFF;
                sizeTable[i2] = location & 0xFF;
            }
            int[] timestampTable = new int[1024];
            for (i = 0; i < 1024; ++i) {
                timestampTable[i] = region.readInt();
            }
            for (i = 0; i < 1024; ++i) {
                int offset = offsetTable[i] * 4096;
                int size = sizeTable[i] * 4096;
                if (offset == 0 && size == 0) continue;
                region.seek(offset);
                int length = region.readInt();
                byte compressionType = region.readByte();
                if (compressionType != 2) {
                    throw new UnsupportedOperationException("Not in zlib format");
                }
                byte[] compressed = new byte[length - 1];
                region.readFully(compressed);
                DataInputStream input = new DataInputStream(new InflaterInputStream(new ByteArrayInputStream(compressed)));
                Tag tag = Tag.load(input);
                if (!(tag instanceof CompoundTag)) continue;
                CompoundTag data = (CompoundTag)tag;
                Optional<IntTag> xPos = data.getInt("xPos");
                Optional<IntTag> zPos = data.getInt("zPos");
                if (xPos.isEmpty() || zPos.isEmpty()) continue;
                int x = xPos.get().value();
                int z = zPos.get().value();
                long pos = ChunkMath.pack(x, z);
                this.chunks.put(pos, new Chunk(data, timestampTable[i], x, z));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Collection<Chunk> getChunks() {
        return this.chunks.values();
    }

    public Optional<Chunk> getChunk(int x, int z) {
        long pos = ChunkMath.pack(x, z);
        return Optional.ofNullable(this.chunks.get(pos));
    }
}

