/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.chunky;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.ParsedCommandNode;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Map;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.DimensionArgument;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLPaths;
import org.popcraft.chunky.Chunky;
import org.popcraft.chunky.command.ChunkyCommand;
import org.popcraft.chunky.command.CommandArguments;
import org.popcraft.chunky.command.suggestion.SuggestionProviders;
import org.popcraft.chunky.event.task.GenerationTaskFinishEvent;
import org.popcraft.chunky.event.task.GenerationTaskUpdateEvent;
import org.popcraft.chunky.listeners.bossbar.BossBarTaskFinishListener;
import org.popcraft.chunky.listeners.bossbar.BossBarTaskUpdateListener;
import org.popcraft.chunky.platform.ForgePlayer;
import org.popcraft.chunky.platform.ForgeSender;
import org.popcraft.chunky.platform.ForgeServer;
import org.popcraft.chunky.platform.impl.GsonConfig;

@Mod(value="chunky")
public class ChunkyForge {
    public static final String MOD_ID = "chunky";
    private Chunky chunky;

    public ChunkyForge() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        MinecraftServer server = event.getServer();
        Path configPath = FMLPaths.CONFIGDIR.get().resolve("chunky/config.json");
        this.chunky = new Chunky(new ForgeServer(this, server), new GsonConfig(configPath));
        if (this.chunky.getConfig().getContinueOnRestart()) {
            this.chunky.getCommands().get("continue").execute(this.chunky.getServer().getConsole(), CommandArguments.empty());
        }
        this.chunky.getEventBus().subscribe(GenerationTaskUpdateEvent.class, new BossBarTaskUpdateListener());
        this.chunky.getEventBus().subscribe(GenerationTaskFinishEvent.class, new BossBarTaskFinishListener());
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)MOD_ID).requires(serverCommandSource -> serverCommandSource.m_6761_(2))).executes(context -> {
            ForgeSender sender;
            Entity patt3126$temp = ((CommandSourceStack)context.getSource()).m_81373_();
            if (patt3126$temp instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)patt3126$temp;
                sender = new ForgePlayer(player);
            } else {
                sender = new ForgeSender((CommandSourceStack)context.getSource());
            }
            Map<String, ChunkyCommand> commands = this.chunky.getCommands();
            String input = context.getInput().substring(((ParsedCommandNode)context.getLastChild().getNodes().get(0)).getRange().getStart());
            String[] tokens = input.split(" ");
            String subCommand = tokens.length > 1 && commands.containsKey(tokens[1]) ? tokens[1] : "help";
            CommandArguments arguments = tokens.length > 2 ? CommandArguments.of(Arrays.copyOfRange(tokens, 2, tokens.length)) : CommandArguments.empty();
            commands.get(subCommand).execute(sender, arguments);
            return 1;
        });
        this.registerArguments(command, new ArgumentBuilder[]{Commands.m_82127_((String)"cancel"), Commands.m_82129_((String)"world", (ArgumentType)DimensionArgument.m_88805_())});
        this.registerArguments(command, new ArgumentBuilder[]{Commands.m_82127_((String)"center"), Commands.m_82129_((String)"x", (ArgumentType)StringArgumentType.word()), Commands.m_82129_((String)"z", (ArgumentType)StringArgumentType.word())});
        this.registerArguments(command, new ArgumentBuilder[]{Commands.m_82127_((String)"confirm")});
        this.registerArguments(command, new ArgumentBuilder[]{Commands.m_82127_((String)"continue"), Commands.m_82129_((String)"world", (ArgumentType)DimensionArgument.m_88805_())});
        this.registerArguments(command, new ArgumentBuilder[]{Commands.m_82127_((String)"corners"), Commands.m_82129_((String)"x1", (ArgumentType)StringArgumentType.word()), Commands.m_82129_((String)"z1", (ArgumentType)StringArgumentType.word()), Commands.m_82129_((String)"x2", (ArgumentType)StringArgumentType.word()), Commands.m_82129_((String)"z2", (ArgumentType)StringArgumentType.word())});
        this.registerArguments(command, new ArgumentBuilder[]{Commands.m_82127_((String)"help"), Commands.m_82129_((String)"page", (ArgumentType)IntegerArgumentType.integer())});
        this.registerArguments(command, new ArgumentBuilder[]{Commands.m_82127_((String)"pattern"), Commands.m_82129_((String)"pattern", (ArgumentType)StringArgumentType.string()).suggests(SuggestionProviders.PATTERNS), Commands.m_82129_((String)"value", (ArgumentType)StringArgumentType.string())});
        this.registerArguments(command, new ArgumentBuilder[]{Commands.m_82127_((String)"pause"), Commands.m_82129_((String)"world", (ArgumentType)DimensionArgument.m_88805_())});
        this.registerArguments(command, new ArgumentBuilder[]{Commands.m_82127_((String)"progress")});
        this.registerArguments(command, new ArgumentBuilder[]{Commands.m_82127_((String)"quiet"), Commands.m_82129_((String)"interval", (ArgumentType)IntegerArgumentType.integer())});
        this.registerArguments(command, new ArgumentBuilder[]{Commands.m_82127_((String)"radius"), Commands.m_82129_((String)"radius", (ArgumentType)StringArgumentType.word()), Commands.m_82129_((String)"radius", (ArgumentType)StringArgumentType.word())});
        this.registerArguments(command, new ArgumentBuilder[]{Commands.m_82127_((String)"reload"), Commands.m_82129_((String)"type", (ArgumentType)StringArgumentType.word())});
        this.registerArguments(command, new ArgumentBuilder[]{Commands.m_82127_((String)"selection")});
        this.registerArguments(command, new ArgumentBuilder[]{Commands.m_82127_((String)"shape"), Commands.m_82129_((String)"shape", (ArgumentType)StringArgumentType.string()).suggests(SuggestionProviders.SHAPES)});
        this.registerArguments(command, new ArgumentBuilder[]{Commands.m_82127_((String)"silent")});
        this.registerArguments(command, new ArgumentBuilder[]{Commands.m_82127_((String)"spawn")});
        this.registerArguments(command, new ArgumentBuilder[]{Commands.m_82127_((String)"start"), Commands.m_82129_((String)"world", (ArgumentType)DimensionArgument.m_88805_()), Commands.m_82129_((String)"shape", (ArgumentType)StringArgumentType.string()).suggests(SuggestionProviders.SHAPES), Commands.m_82129_((String)"centerX", (ArgumentType)StringArgumentType.word()), Commands.m_82129_((String)"centerZ", (ArgumentType)StringArgumentType.word()), Commands.m_82129_((String)"radiusX", (ArgumentType)StringArgumentType.word()), Commands.m_82129_((String)"radiusZ", (ArgumentType)StringArgumentType.word())});
        this.registerArguments(command, new ArgumentBuilder[]{Commands.m_82127_((String)"trim"), Commands.m_82129_((String)"world", (ArgumentType)DimensionArgument.m_88805_()), Commands.m_82129_((String)"shape", (ArgumentType)StringArgumentType.string()).suggests(SuggestionProviders.SHAPES), Commands.m_82129_((String)"centerX", (ArgumentType)StringArgumentType.word()), Commands.m_82129_((String)"centerZ", (ArgumentType)StringArgumentType.word()), Commands.m_82129_((String)"radiusX", (ArgumentType)StringArgumentType.word()), Commands.m_82129_((String)"radiusZ", (ArgumentType)StringArgumentType.word())});
        this.registerArguments(command, new ArgumentBuilder[]{Commands.m_82127_((String)"worldborder")});
        this.registerArguments(command, new ArgumentBuilder[]{Commands.m_82127_((String)"world"), Commands.m_82129_((String)"world", (ArgumentType)DimensionArgument.m_88805_())});
        server.m_129892_().m_82094_().register(command);
    }

    @SafeVarargs
    private <S> void registerArguments(LiteralArgumentBuilder<S> command, ArgumentBuilder<S, ?> ... arguments) {
        for (int i = arguments.length - 1; i > 0; --i) {
            arguments[i - 1].then(arguments[i].executes(command.getCommand()));
        }
        command.then(arguments[0].executes(command.getCommand()));
    }

    @SubscribeEvent
    public void onServerStopping(ServerStoppingEvent event) {
        if (this.chunky != null) {
            this.chunky.disable();
        }
    }

    public Chunky getChunky() {
        return this.chunky;
    }
}

