/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.item;

import cofh.core.capability.CapabilityArchery;
import cofh.core.capability.templates.ArcheryAmmoItemWrapper;
import cofh.core.util.ProxyUtils;
import cofh.core.util.helpers.ArcheryHelper;
import cofh.lib.api.capability.IArcheryAmmoItem;
import cofh.lib.api.item.ICoFHItem;
import cofh.lib.util.Constants;
import cofh.lib.util.Utils;
import cofh.lib.util.helpers.MathHelper;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.FireworkRocketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class CrossbowItemCoFH
extends CrossbowItem
implements ICoFHItem {
    protected int enchantability = 1;
    protected float accuracyModifier = 1.0f;
    protected float damageModifier = 1.0f;
    protected float velocityModifier = 1.0f;
    protected Supplier<CreativeModeTab> displayGroup;
    protected Supplier<Boolean> showInGroups = Constants.TRUE;
    protected String modId = "";

    public CrossbowItemCoFH(Item.Properties builder) {
        super(builder);
        ProxyUtils.registerItemModelProperty((Item)this, new ResourceLocation("pull"), this::getPullModelProperty);
        ProxyUtils.registerItemModelProperty((Item)this, new ResourceLocation("ammo"), this::getAmmoModelProperty);
    }

    public CrossbowItemCoFH(Tier tier, Item.Properties builder) {
        this(builder);
        this.setParams(tier);
    }

    public CrossbowItemCoFH(int enchantability, float accuracyModifier, float damageModifier, float velocityModifier, Item.Properties builder) {
        this(builder);
        this.setParams(enchantability, accuracyModifier, damageModifier, velocityModifier);
    }

    public CrossbowItemCoFH setParams(Tier tier) {
        this.enchantability = tier.m_6601_();
        this.damageModifier = tier.m_6631_() / 4.0f;
        this.velocityModifier = tier.m_6624_() / 20.0f;
        return this;
    }

    public CrossbowItemCoFH setParams(int enchantability, float accuracyModifier, float damageModifier, float velocityModifier) {
        this.enchantability = enchantability;
        this.accuracyModifier = accuracyModifier;
        this.damageModifier = damageModifier;
        this.velocityModifier = velocityModifier;
        return this;
    }

    public int m_6473_() {
        return this.enchantability;
    }

    public void m_7373_(ItemStack stack, @Nullable Level levelIn, List<Component> tooltip, TooltipFlag flagIn) {
        if (this.isLoaded(stack)) {
            tooltip.add((Component)Component.m_237115_((String)"info.cofh.crossbow_loaded").m_130946_(" ").m_7220_(this.getLoadedAmmo(stack).m_41611_()));
        }
    }

    public float getPullModelProperty(ItemStack stack, Level level, LivingEntity entity, int seed) {
        if (entity == null || !entity.m_21211_().equals(stack)) {
            return 0.0f;
        }
        int baseDuration = this.m_8105_(stack);
        int duration = baseDuration - entity.m_21212_();
        return MathHelper.clamp((float)duration / (float)baseDuration, 0.0f, 1.0f);
    }

    public float getAmmoModelProperty(ItemStack stack, Level level, LivingEntity entity, int seed) {
        if (this.getLoadedAmmo(stack).m_41619_()) {
            return 0.0f;
        }
        if (this.getLoadedAmmo(stack).m_41720_() instanceof FireworkRocketItem) {
            return 0.5f;
        }
        return 1.0f;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (this.isLoaded(stack)) {
            this.setLoaded(stack, !this.shootLoadedAmmo(level, (LivingEntity)player, hand, stack));
            return InteractionResultHolder.m_19096_((Object)stack);
        }
        if (!ArcheryHelper.findAmmo(player, stack).m_41619_() || player.f_36077_.f_35937_) {
            player.m_6672_(hand);
            return InteractionResultHolder.m_19096_((Object)stack);
        }
        return InteractionResultHolder.m_19100_((Object)stack);
    }

    public int m_8105_(ItemStack stack) {
        return CrossbowItemCoFH.m_40939_((ItemStack)stack);
    }

    public void m_5929_(Level level, LivingEntity living, ItemStack stack, int durationRemaining) {
        if (!level.m_5776_()) {
            int totalDuration = this.m_8105_(stack);
            int duration = totalDuration - durationRemaining;
            if (duration == totalDuration / 4) {
                level.m_6263_(null, living.m_20185_(), living.m_20186_(), living.m_20189_(), this.m_40851_(Utils.getItemEnchantmentLevel(Enchantments.f_44960_, stack)), SoundSource.PLAYERS, 0.5f, 1.0f);
            }
            if (duration == totalDuration / 2) {
                level.m_6263_(null, living.m_20185_(), living.m_20186_(), living.m_20189_(), SoundEvents.f_11842_, SoundSource.PLAYERS, 0.5f, 1.0f);
            }
        }
    }

    public void m_5551_(ItemStack stack, Level level, LivingEntity living, int durationRemaining) {
        if (durationRemaining < 0 && !CrossbowItemCoFH.m_40932_((ItemStack)stack) && this.loadAmmo(living, stack)) {
            CrossbowItemCoFH.m_40884_((ItemStack)stack, (boolean)true);
            level.m_6263_(null, living.m_20185_(), living.m_20186_(), living.m_20189_(), SoundEvents.f_11841_, living instanceof Player ? SoundSource.PLAYERS : SoundSource.HOSTILE, 1.0f, 1.0f / (level.f_46441_.m_188501_() * 0.5f + 1.0f) + 0.2f);
        }
    }

    public boolean m_41463_(ItemStack stack) {
        return true;
    }

    public boolean loadAmmo(LivingEntity living, ItemStack crossbow) {
        if (living instanceof Player) {
            boolean infinite;
            Player player = (Player)living;
            ItemStack ammo = ArcheryHelper.findAmmo(player, crossbow);
            if (!ammo.m_41619_() && ammo.m_41720_() instanceof FireworkRocketItem) {
                boolean success = this.loadAmmo(player, crossbow, ammo);
                if (success && !player.f_36077_.f_35937_) {
                    ammo.m_41774_(1);
                }
                return success;
            }
            IArcheryAmmoItem ammoCap = (IArcheryAmmoItem)ammo.getCapability(CapabilityArchery.AMMO_ITEM_CAPABILITY).orElse((Object)new ArcheryAmmoItemWrapper(ammo));
            boolean bl = infinite = player.f_36077_.f_35937_ || ammoCap.isInfinite(crossbow, player) || ArcheryHelper.isArrow(ammo) && ((ArrowItem)ammo.m_41720_()).isInfinite(ammo, crossbow, player);
            if (!ammo.m_41619_() || infinite) {
                boolean success;
                if (ammo.m_41619_()) {
                    ammo = new ItemStack((ItemLike)Items.f_42412_);
                }
                if ((success = this.loadAmmo(player, crossbow, ammo)) && !infinite) {
                    ammoCap.onArrowLoosed(player);
                    if (ammo.m_41619_()) {
                        player.f_36093_.m_36057_(ammo);
                    }
                }
                return success;
            }
        }
        return false;
    }

    public boolean loadAmmo(Player player, ItemStack crossbow, ItemStack ammo) {
        crossbow.m_41784_().m_128365_("Ammo", (Tag)ammo.m_41739_(new CompoundTag()));
        CrossbowItemCoFH.m_40884_((ItemStack)crossbow, (boolean)true);
        return true;
    }

    public ItemStack getLoadedAmmo(ItemStack crossbow) {
        CompoundTag nbt = crossbow.m_41783_();
        if (nbt != null && nbt.m_128441_("Ammo")) {
            return ItemStack.m_41712_((CompoundTag)nbt.m_128469_("Ammo"));
        }
        return ItemStack.f_41583_;
    }

    public void removeLoadedAmmo(ItemStack crossbow) {
        crossbow.m_41749_("Ammo");
    }

    public void setLoaded(ItemStack crossbow, boolean loaded) {
        CrossbowItem.m_40884_((ItemStack)crossbow, (boolean)loaded);
    }

    public boolean isLoaded(ItemStack crossbow) {
        return CrossbowItem.m_40932_((ItemStack)crossbow);
    }

    public boolean shootLoadedAmmo(Level level, LivingEntity living, InteractionHand hand, ItemStack crossbow) {
        if (living instanceof Player) {
            Player shooter = (Player)living;
            ItemStack ammo = this.getLoadedAmmo(crossbow);
            if (!ammo.m_41619_()) {
                int multishot = Utils.getItemEnchantmentLevel(Enchantments.f_44959_, crossbow);
                int damage = 0;
                for (int i = -multishot; i <= multishot; ++i) {
                    AbstractArrow projectile;
                    if (ammo.m_41619_()) continue;
                    if (ammo.getCapability(CapabilityArchery.AMMO_ITEM_CAPABILITY).isPresent() || ammo.m_41720_() instanceof ArrowItem) {
                        AbstractArrow arrow = ArcheryHelper.createArrow(level, ammo, shooter);
                        projectile = this.adjustArrow(crossbow, arrow, shooter.f_36077_.f_35937_ || i != 0);
                        ++damage;
                    } else if (ammo.m_41720_() instanceof FireworkRocketItem) {
                        projectile = new FireworkRocketEntity(level, ammo, (Entity)shooter, shooter.m_20185_(), shooter.m_20188_() - (double)0.15f, shooter.m_20189_(), true);
                        damage += 3;
                    } else {
                        return false;
                    }
                    level.m_7967_((Entity)this.shootProjectile(shooter, (Projectile)projectile, this.getBaseSpeed(ammo), 1.0f, (float)i * 10.0f));
                    float pitch = level.f_46441_.m_188501_() * 0.32f + 0.865f;
                    level.m_6263_(null, shooter.m_20185_(), shooter.m_20186_(), shooter.m_20189_(), SoundEvents.f_11847_, SoundSource.PLAYERS, 1.0f, pitch);
                }
                this.onCrossbowShot(shooter, hand, crossbow, damage);
            }
        }
        this.removeLoadedAmmo(crossbow);
        return true;
    }

    public float getBaseSpeed(ItemStack ammo) {
        return ammo.m_41720_() instanceof FireworkRocketItem ? 1.6f : 3.15f;
    }

    public AbstractArrow adjustArrow(ItemStack crossbow, AbstractArrow arrow, boolean creativePickup) {
        arrow.m_36762_(true);
        arrow.m_36740_(SoundEvents.f_11840_);
        arrow.m_36793_(true);
        int pierce = Utils.getItemEnchantmentLevel(Enchantments.f_44961_, crossbow);
        if (pierce > 0) {
            arrow.m_36767_((byte)pierce);
        }
        if (creativePickup) {
            arrow.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
        }
        return arrow;
    }

    public Projectile shootProjectile(Player shooter, Projectile projectile, float speed, float inaccuracy, float angle) {
        Vector3f vector3f = new Vector3f(shooter.m_20252_(1.0f));
        vector3f.m_122251_(new Quaternion(new Vector3f(shooter.m_20289_(1.0f)), angle, true));
        projectile.m_6686_((double)vector3f.m_122239_(), (double)vector3f.m_122260_(), (double)vector3f.m_122269_(), speed, inaccuracy);
        return projectile;
    }

    public void onCrossbowShot(Player shooter, InteractionHand hand, ItemStack crossbow, int damage) {
        crossbow.m_41622_(damage, (LivingEntity)shooter, entity -> entity.m_21190_(hand));
        if (shooter instanceof ServerPlayer) {
            if (!shooter.f_19853_.m_5776_()) {
                CriteriaTriggers.f_10555_.m_65462_((ServerPlayer)shooter, crossbow);
            }
            shooter.m_36246_(Stats.f_12982_.m_12902_((Object)crossbow.m_41720_()));
        }
    }

    @Override
    public CrossbowItemCoFH setDisplayGroup(Supplier<CreativeModeTab> displayGroup) {
        this.displayGroup = displayGroup;
        return this;
    }

    @Override
    public CrossbowItemCoFH setModId(String modId) {
        this.modId = modId;
        return this;
    }

    @Override
    public CrossbowItemCoFH setShowInGroups(Supplier<Boolean> showInGroups) {
        this.showInGroups = showInGroups;
        return this;
    }

    public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> items) {
        if (!this.showInGroups.get().booleanValue() || this.displayGroup != null && this.displayGroup.get() != null && this.displayGroup.get() != group) {
            return;
        }
        super.m_6787_(group, items);
    }

    public Collection<CreativeModeTab> getCreativeTabs() {
        return this.displayGroup != null && this.displayGroup.get() != null ? Collections.singletonList(this.displayGroup.get()) : super.getCreativeTabs();
    }

    public String getCreatorModId(ItemStack itemStack) {
        return this.modId == null || this.modId.isEmpty() ? super.getCreatorModId(itemStack) : this.modId;
    }
}

