/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.item;

import cofh.core.item.ItemCoFH;
import cofh.lib.api.ContainerType;
import cofh.lib.api.item.IEnergyContainerItem;
import cofh.lib.energy.EnergyContainerItemWrapper;
import cofh.lib.util.helpers.StringHelper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.IEnergyStorage;

public abstract class EnergyContainerItem
extends ItemCoFH
implements IEnergyContainerItem {
    protected int maxEnergy;
    protected int extract;
    protected int receive;

    protected EnergyContainerItem(Item.Properties builder, int maxEnergy, int extract, int receive) {
        super(builder);
        this.maxEnergy = maxEnergy;
        this.extract = extract;
        this.receive = receive;
        this.setEnchantability(5);
    }

    public EnergyContainerItem(Item.Properties builder, int maxEnergy, int maxTransfer) {
        this(builder, maxEnergy, maxTransfer, maxTransfer);
    }

    public EnergyContainerItem setMaxEnergy(int maxEnergy) {
        this.maxEnergy = maxEnergy;
        return this;
    }

    @Override
    protected void tooltipDelegate(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        boolean creative = this.isCreative(stack, ContainerType.ENERGY);
        if (this.getMaxEnergyStored(stack) > 0) {
            tooltip.add((Component)(creative ? StringHelper.getTextComponent(StringHelper.localize("info.cofh.energy") + ": ").m_7220_((Component)StringHelper.getTextComponent("info.cofh.infinite").m_130940_(ChatFormatting.LIGHT_PURPLE).m_130940_(ChatFormatting.ITALIC)) : StringHelper.getTextComponent(StringHelper.localize("info.cofh.energy") + ": " + StringHelper.getScaledNumber(this.getEnergyStored(stack)) + " / " + StringHelper.getScaledNumber(this.getMaxEnergyStored(stack)) + " " + StringHelper.localize("info.cofh.unit_rf"))));
        }
        this.addEnergyTooltip(stack, worldIn, tooltip, flagIn, this.getExtract(stack), this.getReceive(stack), creative);
    }

    public boolean shouldCauseBlockBreakReset(ItemStack oldStack, ItemStack newStack) {
        return newStack.m_41720_() != oldStack.m_41720_() || this.getEnergyStored(oldStack) > 0 != this.getEnergyStored(newStack) > 0;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return super.shouldCauseReequipAnimation(oldStack, newStack, slotChanged) && (slotChanged || this.getEnergyStored(oldStack) > 0 != this.getEnergyStored(newStack) > 0);
    }

    public boolean m_142522_(ItemStack stack) {
        return !this.isCreative(stack, ContainerType.ENERGY) && this.getEnergyStored(stack) > 0;
    }

    public int m_142159_(ItemStack stack) {
        return 0xD01010;
    }

    public int m_142158_(ItemStack stack) {
        if (stack.m_41783_() == null) {
            return 0;
        }
        return (int)Math.round(13.0 * (double)this.getEnergyStored(stack) / (double)this.getMaxEnergyStored(stack));
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new EnergyContainerItemWrapper(stack, this, (Capability<? extends IEnergyStorage>)this.getEnergyCapability());
    }

    @Override
    public int getExtract(ItemStack container) {
        return this.extract;
    }

    @Override
    public int getReceive(ItemStack container) {
        return this.receive;
    }

    @Override
    public int getMaxEnergyStored(ItemStack container) {
        return this.getMaxStored(container, this.maxEnergy);
    }
}

