/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.event;

import cofh.core.client.CoreKeys;
import cofh.core.client.model.FluidContainerItemModel;
import cofh.core.client.particle.impl.ArcParticle;
import cofh.core.client.particle.impl.BeamParticle;
import cofh.core.client.particle.impl.BlastParticle;
import cofh.core.client.particle.impl.BlastWaveParticle;
import cofh.core.client.particle.impl.FireParticle;
import cofh.core.client.particle.impl.FrostParticle;
import cofh.core.client.particle.impl.MistParticle;
import cofh.core.client.particle.impl.PlasmaBallParticle;
import cofh.core.client.particle.impl.ShardParticle;
import cofh.core.client.particle.impl.ShockwaveParticle;
import cofh.core.client.particle.impl.SparkParticle;
import cofh.core.client.particle.impl.StreamParticle;
import cofh.core.client.particle.impl.WindSpiralParticle;
import cofh.core.client.particle.impl.WindVortexParticle;
import cofh.core.init.CoreParticles;
import cofh.lib.api.item.IColorableItem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.color.item.ItemColors;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="cofh_core", bus=Mod.EventBusSubscriber.Bus.MOD)
public class CoreClientSetupEvents {
    private static final List<Item> COLORABLE_ITEMS = new ArrayList<Item>();

    private CoreClientSetupEvents() {
    }

    @SubscribeEvent
    public static void registerKeyMappings(RegisterKeyMappingsEvent event) {
        event.register(CoreKeys.MULTIMODE_INCREMENT);
        event.register(CoreKeys.MULTIMODE_DECREMENT);
    }

    @SubscribeEvent
    public static void colorSetupItem(RegisterColorHandlersEvent.Item event) {
        ItemColors colors = event.getItemColors();
        for (Item colorable : COLORABLE_ITEMS) {
            colors.m_92689_(((IColorableItem)colorable)::getColor, new ItemLike[]{colorable});
        }
    }

    @SubscribeEvent
    public static void registerModels(ModelEvent.RegisterGeometryLoaders event) {
        event.register("fluid_container", (IGeometryLoader)new FluidContainerItemModel.Loader());
    }

    @SubscribeEvent
    public static void registerParticleFactories(RegisterParticleProvidersEvent event) {
        event.register((ParticleType)CoreParticles.FROST.get(), FrostParticle::factory);
        event.register((ParticleType)CoreParticles.PLASMA.get(), PlasmaBallParticle::factory);
        event.register((ParticleType)CoreParticles.SPARK.get(), SparkParticle::factory);
        event.register((ParticleType)CoreParticles.FIRE.get(), FireParticle::factory);
        event.register((ParticleType)CoreParticles.BLAST.get(), BlastParticle::factory);
        event.register((ParticleType)CoreParticles.MIST.get(), MistParticle::factory);
        event.register((ParticleType)CoreParticles.SHOCKWAVE.get(), ShockwaveParticle::factory);
        event.register((ParticleType)CoreParticles.BLAST_WAVE.get(), BlastWaveParticle::factory);
        event.register((ParticleType)CoreParticles.WIND_VORTEX.get(), WindVortexParticle::factory);
        event.register((ParticleType)CoreParticles.WIND_SPIRAL.get(), WindSpiralParticle::factory);
        event.register((ParticleType)CoreParticles.BEAM.get(), BeamParticle::factory);
        event.register((ParticleType)CoreParticles.STRAIGHT_ARC.get(), ArcParticle::factory);
        event.register((ParticleType)CoreParticles.SHARD.get(), ShardParticle::factory);
        event.register((ParticleType)CoreParticles.STREAM.get(), StreamParticle::factory);
    }

    public static void addColorable(Item colorable) {
        if (colorable instanceof IColorableItem) {
            COLORABLE_ITEMS.add(colorable);
        }
    }
}

